set(_THIS_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(_THIS_DIR "${CMAKE_CURRENT_LIST_DIR}")

if(CMAKE_CURRENT_FUNCTION)
  message(SEND_ERROR "`CMAKE_CURRENT_FUNCTION` is not expected to be set here")
endif()
if(CMAKE_CURRENT_FUNCTION_LIST_FILE)
  message(SEND_ERROR "`CMAKE_CURRENT_FUNCTION_LIST_FILE` is not expected to be set here")
endif()
if(CMAKE_CURRENT_FUNCTION_LIST_DIR)
  message(SEND_ERROR "`CMAKE_CURRENT_FUNCTION_LIST_DIR` is not expected to be set here")
endif()
if(CMAKE_CURRENT_FUNCTION_LIST_LINE)
  message(SEND_ERROR "`CMAKE_CURRENT_FUNCTION_LIST_LINE` is not expected to be set here")
endif()

function(bar)
  if(NOT CMAKE_CURRENT_FUNCTION STREQUAL "bar")
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_FILE MATCHES "^.*/CMAKE_CURRENT_FUNCTION.cmake$")
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_FILE`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_FILE STREQUAL _THIS_FILE)
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_FILE`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_DIR MATCHES "^.*/Tests/RunCMake/function$")
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_DIR`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_DIR STREQUAL _THIS_DIR)
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_DIR`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_LINE EQUAL 17)
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_LINE`")
  endif()
endfunction()

function(foo)
  if(NOT CMAKE_CURRENT_FUNCTION STREQUAL "foo")
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_FILE MATCHES "^.*/function/CMAKE_CURRENT_FUNCTION.cmake$")
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_FILE`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_FILE STREQUAL _THIS_FILE)
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_FILE`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_DIR MATCHES "^.*/Tests/RunCMake/function$")
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_DIR`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_LINE EQUAL 38)
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_LINE`")
  endif()
  if(NOT CMAKE_CURRENT_FUNCTION_LIST_DIR STREQUAL _THIS_DIR)
    message(SEND_ERROR "Bad value of `CMAKE_CURRENT_FUNCTION_LIST_DIR`")
  endif()
  bar()
endfunction()

foo()

if(CMAKE_CURRENT_FUNCTION)
  message(SEND_ERROR "`CMAKE_CURRENT_FUNCTION` is not expected to be set here")
endif()
if(CMAKE_CURRENT_FUNCTION_LIST_FILE)
  message(SEND_ERROR "`CMAKE_CURRENT_FUNCTION_LIST_FILE` is not expected to be set here")
endif()
if(CMAKE_CURRENT_FUNCTION_LIST_DIR)
  message(SEND_ERROR "`CMAKE_CURRENT_FUNCTION_LIST_DIR` is not expected to be set here")
endif()
if(CMAKE_CURRENT_FUNCTION_LIST_LINE)
  message(SEND_ERROR "`CMAKE_CURRENT_FUNCTION_LIST_LINE` is not expected to be set here")
endif()

include("${CMAKE_CURRENT_LIST_DIR}/DummyMacro.cmake")

function(calling_macro)
  dummy()
endfunction()

calling_macro()

# ATTENTION `CMAKE_CURRENT_LIST_LINE` can't be used in `math()'
function(print_self)
    file(STRINGS "${CMAKE_CURRENT_FUNCTION_LIST_FILE}" _lines)
    math(EXPR _begin "${CMAKE_CURRENT_FUNCTION_LIST_LINE} - 1")
    list(SUBLIST _lines ${_begin} 7 _lines) # This function has 7 lines only
    list(JOIN _lines "\n" _lines)
    message(STATUS "Print the `${CMAKE_CURRENT_FUNCTION}` function:\n${_lines}")
endfunction()

print_self()
