; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine < %s -S | FileCheck %s

define i8 @phi_ugt_high_bits(i8 %x) {
; CHECK-LABEL: @phi_ugt_high_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], -65
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i8 64
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp ugt i8 %x, 191
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 64
  ret i8 %r
F:
  br label %T
}

define i8 @phi_ult_low_bits(i8 %x) {
; CHECK-LABEL: @phi_ult_low_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[X:%.*]], -64
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    br label [[F]]
; CHECK:       F:
; CHECK-NEXT:    ret i8 64
;
entry:
  %cmp = icmp ult i8 %x, 192
  br i1 %cmp, label %T, label %F
T:
  br label %F
F:
  %v = phi i8 [ %x, %entry], [-1, %T]
  %r = and i8 %v, 64
  ret i8 %r
}

define i8 @phi_ugt_high_bits_fail(i8 %x) {
; CHECK-LABEL: @phi_ugt_high_bits_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], -66
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ -1, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 64
; CHECK-NEXT:    ret i8 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp ugt i8 %x, 190
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 64
  ret i8 %r
F:
  br label %T
}

define i8 @phi_uge_high_bits(i8 %x) {
; CHECK-LABEL: @phi_uge_high_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], -65
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i8 64
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp uge i8 %x, 192
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 64
  ret i8 %r
F:
  br label %T
}

define i8 @phi_uge_high_bits_fail(i8 %x) {
; CHECK-LABEL: @phi_uge_high_bits_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], 5
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ -1, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 1
; CHECK-NEXT:    ret i8 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp ugt i8 %x, 5
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 1
  ret i8 %r
F:
  br label %T
}

define i8 @phi_sge_high_bits(i8 %x) {
; CHECK-LABEL: @phi_sge_high_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], 95
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i8 96
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sge i8 %x, 96
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 96
  ret i8 %r
F:
  br label %T
}

define i8 @phi_sge_high_bits_fail(i8 %x) {
; CHECK-LABEL: @phi_sge_high_bits_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], -2
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ -1, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 1
; CHECK-NEXT:    ret i8 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sge i8 %x, -1
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 1
  ret i8 %r
F:
  br label %T
}

define i8 @phi_sgt_high_bits(i8 %x) {
; CHECK-LABEL: @phi_sgt_high_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], -1
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i8 0
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sgt i8 %x, -1
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [0, %F]
  %r = and i8 %v, 128
  ret i8 %r
F:
  br label %T
}

define i8 @phi_sgt_high_bits2(i8 %x) {
; CHECK-LABEL: @phi_sgt_high_bits2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], 63
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i8 64
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sgt i8 %x, 63
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 64
  ret i8 %r
F:
  br label %T
}

define i8 @phi_sgt_high_bits_fail(i8 %x) {
; CHECK-LABEL: @phi_sgt_high_bits_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], 62
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ -1, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 64
; CHECK-NEXT:    ret i8 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sgt i8 %x, 62
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 64
  ret i8 %r
F:
  br label %T
}

define i8 @phi_slt_high_bits(i8 %x) {
; CHECK-LABEL: @phi_slt_high_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i8 -128
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp slt i8 %x, 0
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 128
  ret i8 %r
F:
  br label %T
}

define i8 @phi_slt_high_bits2(i8 %x) {
; CHECK-LABEL: @phi_slt_high_bits2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], -64
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i8 0
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp slt i8 %x, -64
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [0, %F]
  %r = and i8 %v, 64
  ret i8 %r
F:
  br label %T
}

define i8 @phi_slt_high_bits_fail(i8 %x) {
; CHECK-LABEL: @phi_slt_high_bits_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], -63
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ 0, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 64
; CHECK-NEXT:    ret i8 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp slt i8 %x, -63
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [0, %F]
  %r = and i8 %v, 64
  ret i8 %r
F:
  br label %T
}

define i8 @phi_sle_high_bits(i8 %x) {
; CHECK-LABEL: @phi_sle_high_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], -64
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i8 0
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sle i8 %x, -65
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [0, %F]
  %r = and i8 %v, 64
  ret i8 %r
F:
  br label %T
}

define i8 @phi_sle_low_bits(i8 %x) {
; CHECK-LABEL: @phi_sle_low_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], 65
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    br label [[F]]
; CHECK:       F:
; CHECK-NEXT:    ret i8 64
;
entry:
  %cmp = icmp sle i8 %x, 64
  br i1 %cmp, label %T, label %F
T:
  br label %F
F:
  %v = phi i8 [ %x, %entry], [-1, %T]
  %r = and i8 %v, 64
  ret i8 %r
}

define i8 @phi_sle_high_bits_fail(i8 %x) {
; CHECK-LABEL: @phi_sle_high_bits_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], 1
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ -1, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], -128
; CHECK-NEXT:    ret i8 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sle i8 %x, 0
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 128
  ret i8 %r
F:
  br label %T
}

define i8 @phi_sle_high_bits_fail2(i8 %x) {
; CHECK-LABEL: @phi_sle_high_bits_fail2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], -63
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ -1, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 64
; CHECK-NEXT:    ret i8 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %cmp = icmp sle i8 %x, -64
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 64
  ret i8 %r
F:
  br label %T
}

define i8 @phi_ugt_high_bits_and_known(i8 %xx) {
; CHECK-LABEL: @phi_ugt_high_bits_and_known(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[XX:%.*]], -65
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i8 65
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %x = or i8 %xx, 1
  %cmp = icmp ugt i8 %x, 191
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 65
  ret i8 %r
F:
  br label %T
}

define i8 @phi_ugt_high_bits_and_known_todo_high_depths(i8 %xx, i8 %y, i8 %z) {
; CHECK-LABEL: @phi_ugt_high_bits_and_known_todo_high_depths(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[YY:%.*]] = and i8 [[Y:%.*]], -2
; CHECK-NEXT:    [[XXX:%.*]] = and i8 [[YY]], [[XX:%.*]]
; CHECK-NEXT:    [[ZZ:%.*]] = or i8 [[Z:%.*]], 1
; CHECK-NEXT:    [[X:%.*]] = add i8 [[XXX]], [[ZZ]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X]], -65
; CHECK-NEXT:    br i1 [[CMP]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[V:%.*]] = phi i8 [ [[X]], [[ENTRY:%.*]] ], [ -1, [[F]] ]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 65
; CHECK-NEXT:    ret i8 [[R]]
; CHECK:       F:
; CHECK-NEXT:    br label [[T]]
;
entry:
  %yy = and i8 %y, -2
  %xxx = and i8 %xx, %yy
  %zz = or i8 %z, 1
  %x = add i8 %xxx, %zz
  %cmp = icmp ugt i8 %x, 191
  br i1 %cmp, label %T, label %F
T:
  %v = phi i8 [ %x, %entry], [-1, %F]
  %r = and i8 %v, 65
  ret i8 %r
F:
  br label %T
}

;Illustrate if 2 pointers are non-equal when one of them is a recursive GEP.
;Cases which folds to a canonical icmp(ptr1, ptr2)
define i1 @recursiveGEP_withPtrSub1(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    ret i1 false
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub1_PhiOperandsCommuted(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub1_PhiOperandsCommuted(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[VAL1:%.*]], [[ENTRY:%.*]] ], [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    ret i1 false
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %val1, %entry ], [ %test.0.i, %while.cond.i ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub1_SubOperandsCommuted(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub1_SubOperandsCommuted(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    ret i1 false
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.rhs.cast.i, %sub.ptr.lhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub2(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 -1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    ret i1 false
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 -1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub3(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEST_VAL1:%.*]] = getelementptr inbounds i8, ptr [[VAL1:%.*]], i64 7
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[TEST_VAL1]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    ret i1 false
;
entry:
  %test.val1 = getelementptr inbounds i8, ptr %val1, i64 7
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %test.val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %1 = getelementptr inbounds i8, ptr %val1, i64 5
  %sub.ptr.rhs.cast.i = ptrtoint ptr %1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub1_notKnownNonEqual1(ptr %val1, i64 %val2) {
; CHECK-LABEL: @recursiveGEP_withPtrSub1_notKnownNonEqual1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i8, ptr [[VAL1]], i64 [[VAL2:%.*]]
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[TEST_0_I]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %1 = getelementptr inbounds i8, ptr %val1, i64 %val2
  %sub.ptr.rhs.cast.i = ptrtoint ptr %1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub1_notKnownNonEqual2(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub1_notKnownNonEqual2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEST_VAL1:%.*]] = getelementptr inbounds i8, ptr [[VAL1:%.*]], i64 -1
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[TEST_VAL1]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[TEST_0_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  %test.val1 = getelementptr inbounds i8, ptr %val1, i64 -1
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %test.val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub1_notKnownNonEqual3(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub1_notKnownNonEqual3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEST_VAL1:%.*]] = getelementptr inbounds i8, ptr [[VAL1:%.*]], i64 5
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[TEST_VAL1]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 -1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[TEST_0_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  %test.val1 = getelementptr inbounds i8, ptr %val1, i64 5
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %test.val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 -1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub_maybeZero(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub_maybeZero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A_PN_I]], align 2
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[A_PN_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %0 = load i8, ptr %a.pn.i, align 2
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %a.pn.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

;Non-inbounds test.
;Test where Step is non-inbound.
define i1 @recursiveGEP_withPtrSub_noninboundStep1(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub_noninboundStep1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[TEST_0_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub_noninboundStep2(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub_noninboundStep2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr i8, ptr [[A_PN_I]], i64 -1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[TEST_0_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr i8, ptr %a.pn.i, i64 -1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

;Test where Step and GEP B are non-inbound.
define i1 @recursiveGEP_withPtrSub_noninboundStepAndB(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub_noninboundStepAndB(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEST:%.*]] = getelementptr inbounds i8, ptr [[VAL1:%.*]], i64 2
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[TEST]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[A_PN_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  %test = getelementptr inbounds i8, ptr %val1, i64 2
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %test, %entry ]
  %test.0.i = getelementptr i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %test.1.i = getelementptr i8, ptr %val1, i64 1
  %sub.ptr.rhs.cast.i = ptrtoint ptr %test.1.i to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

;Test where Start and Step are non-inbound.
define i1 @recursiveGEP_withPtrSub_noninboundStartAndStep(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub_noninboundStartAndStep(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEST:%.*]] = getelementptr i8, ptr [[VAL1:%.*]], i64 1
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[TEST]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[TEST_0_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  %test = getelementptr i8, ptr %val1, i64 1
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %test, %entry ]
  %test.0.i = getelementptr i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

;Test where Start and GEP B are non-inbounds pointer with same definition.
define i1 @recursiveGEP_withPtrSub_noninboundSameDefStartAndB(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub_noninboundSameDefStartAndB(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEST:%.*]] = getelementptr i8, ptr [[VAL1:%.*]], i64 1
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[TEST]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[A_PN_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  %test = getelementptr i8, ptr %val1, i64 1
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %test, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %test2 = getelementptr i8, ptr %val1, i64 1
  %sub.ptr.rhs.cast.i = ptrtoint ptr %test2 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

;Test where Start and GEP B are non-inbounds and exactly same pointers.
define i1 @recursiveGEP_withPtrSub_noninboundSameStartAndB(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub_noninboundSameStartAndB(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEST:%.*]] = getelementptr i8, ptr [[VAL1:%.*]], i64 1
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[TEST]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    ret i1 false
;
entry:
  %test = getelementptr i8, ptr %val1, i64 1
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %test, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %test to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub_scalableGEP(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub_scalableGEP(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr <vscale x 16 x i8>, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 1
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[TEST_0_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr <vscale x 16 x i8>, ptr %a.pn.i, i64 1
  %0 =  load i8, ptr %test.0.i, align 1
  %cmp3.not.i = icmp eq i8 %0, 0
  br  i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

define i1 @recursiveGEP_withPtrSub_scalableGEP_inbounds(ptr %val1) {
; CHECK-LABEL: @recursiveGEP_withPtrSub_scalableGEP_inbounds(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds <vscale x 16 x i8>, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 1
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    [[BOOL:%.*]] = icmp eq ptr [[TEST_0_I]], [[VAL1]]
; CHECK-NEXT:    ret i1 [[BOOL]]
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr inbounds <vscale x 16 x i8>, ptr %a.pn.i, i64 1
  %0 =  load i8, ptr %test.0.i, align 1
  %cmp3.not.i = icmp eq i8 %0, 0
  br  i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %bool = icmp eq i64 %sub.ptr.sub.i, 0
  ret i1 %bool
}

; Test cmp(or), where one of argument to OR is a SUB of ptr2int with a recursive GEP.
define i1 @recursiveGEP_orcmp(ptr %val1, i64 %val2) {
; CHECK-LABEL: @recursiveGEP_orcmp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    ret i1 false
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %orval = or i64 %sub.ptr.sub.i, %val2
  %bool = icmp eq i64 %orval, 0
  ret i1 %bool
}

define i1 @recursiveGEP_orcmp_orOperandsCommuted(ptr %val1, i64 %val2) {
; CHECK-LABEL: @recursiveGEP_orcmp_orOperandsCommuted(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    ret i1 false
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %orval = or i64 %val2, %sub.ptr.sub.i
  %bool = icmp eq i64 %orval, 0
  ret i1 %bool
}

; Test one of the argument to SUB is a ptr2int of a recursive GEP, with multiple use of SUB.
define i1 @recursiveGEP_orcmpMultiUse(ptr %val1, i64 %val2, ptr %dv1, ptr %dv2) {
; CHECK-LABEL: @recursiveGEP_orcmpMultiUse(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_COND_I:%.*]]
; CHECK:       while.cond.i:
; CHECK-NEXT:    [[A_PN_I:%.*]] = phi ptr [ [[TEST_0_I:%.*]], [[WHILE_COND_I]] ], [ [[VAL1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TEST_0_I]] = getelementptr inbounds i8, ptr [[A_PN_I]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[TEST_0_I]], align 2
; CHECK-NEXT:    [[CMP3_NOT_I:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP3_NOT_I]], label [[WHILE_END_I:%.*]], label [[WHILE_COND_I]]
; CHECK:       while.end.i:
; CHECK-NEXT:    br i1 false, label [[IF_THEN:%.*]], label [[IF_END4:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[CLEANUP:%.*]]
; CHECK:       if.end4:
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    ret i1 true
;
entry:
  br label %while.cond.i

while.cond.i:
  %a.pn.i = phi ptr [ %test.0.i, %while.cond.i ], [ %val1, %entry ]
  %test.0.i = getelementptr inbounds i8, ptr %a.pn.i, i64 1
  %0 = load i8, ptr %test.0.i, align 2
  %cmp3.not.i = icmp eq i8 %0, 0
  br i1 %cmp3.not.i, label %while.end.i, label %while.cond.i

while.end.i:
  %sub.ptr.lhs.cast.i = ptrtoint ptr %test.0.i to i64
  %sub.ptr.rhs.cast.i = ptrtoint ptr %val1 to i64
  %sub.ptr.sub.i = sub i64 %sub.ptr.lhs.cast.i, %sub.ptr.rhs.cast.i
  %orval = or i64 %sub.ptr.sub.i, %val2
  %or.cond = icmp eq i64 %orval, 0
  br i1 %or.cond, label %if.then, label %if.end4

if.then:
  %cmp = icmp eq ptr %dv1, %dv2
  br label %cleanup

if.end4:
  %tobool = icmp ne i64 %sub.ptr.sub.i, 0
  br label %cleanup

cleanup:
  %retval.0 = phi i1 [ %cmp, %if.then ], [ %tobool, %if.end4 ]
  ret i1 %retval.0
}
