#! /bin/sh
#/*-----------------------------------------------------------------*/
#/*! 
#  \file createbuildoctavepackage.sh
#  \brief Create the octave package 
#  \author  M. Gastineau 
#           Astronomie et Systemes Dynamiques, IMCCE, CNRS, Observatoire de Paris. 
#
#   Copyright,  2018, CNRS
#   email of the author : Mickael.Gastineau@obspm.fr
#  
#*/
#/*-----------------------------------------------------------------*/
#
#/*-----------------------------------------------------------------*/
#/* License  of this file :
#  This file is "triple-licensed", you have to choose one  of the three licenses 
#  below to apply on this file.
#  
#     CeCILL-C
#     	The CeCILL-C license is close to the GNU LGPL.
#     	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )
#   
#  or CeCILL-B
#        The CeCILL-B license is close to the BSD.
#        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)
#  
#  or CeCILL v2.1
#       The CeCILL license is compatible with the GNU GPL.
#       ( http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html )
#  
# 
# This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under 
# French law and abiding by the rules of distribution of free software.  
# You can  use, modify and/ or redistribute the software under the terms 
# of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA  
# at the following URL "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
# */
# /*-----------------------------------------------------------------*/

CALCEPHMEX_VERSION=3.5.5
CALCEPHMEX_PACKAGE=calcephoct
CALCEPHMEX_PACKAGEDIR=$CALCEPHMEX_PACKAGE-$CALCEPHMEX_VERSION
TOPDIR=../
CALCEPH_TARBALL=calceph-3.5.5.tar.gz

ls -l $CALCEPH_TARBALL || exit 1
rm -r -f $CALCEPHMEX_PACKAGEDIR
mkdir $CALCEPHMEX_PACKAGEDIR || exit 1
cd $CALCEPHMEX_PACKAGEDIR || exit 1
cp $TOPDIR/COPYING_CECILL_V2.1.LIB  COPYING || exit 1
cp $TOPDIR/NEWS  . || exit 1
cp -R -p $TOPDIR/mexapi/src  $TOPDIR/mexapi/tests  . || exit 1
rm -f src/Makefile* || exit 1
rm -f src/*.mex* tests/*.mex* src/*.o tests/*.o || exit 1
cp $TOPDIR/mexapi/packaging/octave/Makefile.src src/Makefile || exit 1
cp -R -p $TOPDIR/doc/html/mex  doc || exit 1
cp $TOPDIR/mexapi/packaging/octave/DESCRIPTION . || exit 1
tar xzf ../$CALCEPH_TARBALL || exit 1

cd ..
tar cvzf $CALCEPHMEX_PACKAGEDIR.tar.gz $CALCEPHMEX_PACKAGEDIR
rm -r -f $CALCEPHMEX_PACKAGEDIR

