﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/QueryGenerationInput.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace BedrockAgentRuntime
{
namespace Model
{

QueryGenerationInput::QueryGenerationInput() : 
    m_textHasBeenSet(false),
    m_type(InputQueryType::NOT_SET),
    m_typeHasBeenSet(false)
{
}

QueryGenerationInput::QueryGenerationInput(JsonView jsonValue)
  : QueryGenerationInput()
{
  *this = jsonValue;
}

QueryGenerationInput& QueryGenerationInput::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("text"))
  {
    m_text = jsonValue.GetString("text");

    m_textHasBeenSet = true;
  }

  if(jsonValue.ValueExists("type"))
  {
    m_type = InputQueryTypeMapper::GetInputQueryTypeForName(jsonValue.GetString("type"));

    m_typeHasBeenSet = true;
  }

  return *this;
}

JsonValue QueryGenerationInput::Jsonize() const
{
  JsonValue payload;

  if(m_textHasBeenSet)
  {
   payload.WithString("text", m_text);

  }

  if(m_typeHasBeenSet)
  {
   payload.WithString("type", InputQueryTypeMapper::GetNameForInputQueryType(m_type));
  }

  return payload;
}

} // namespace Model
} // namespace BedrockAgentRuntime
} // namespace Aws
