﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ec2/model/AcceptCapacityReservationBillingOwnershipRequest.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

using namespace Aws::EC2::Model;
using namespace Aws::Utils;

AcceptCapacityReservationBillingOwnershipRequest::AcceptCapacityReservationBillingOwnershipRequest() : 
    m_dryRun(false),
    m_dryRunHasBeenSet(false),
    m_capacityReservationIdHasBeenSet(false)
{
}

Aws::String AcceptCapacityReservationBillingOwnershipRequest::SerializePayload() const
{
  Aws::StringStream ss;
  ss << "Action=AcceptCapacityReservationBillingOwnership&";
  if(m_dryRunHasBeenSet)
  {
    ss << "DryRun=" << std::boolalpha << m_dryRun << "&";
  }

  if(m_capacityReservationIdHasBeenSet)
  {
    ss << "CapacityReservationId=" << StringUtils::URLEncode(m_capacityReservationId.c_str()) << "&";
  }

  ss << "Version=2016-11-15";
  return ss.str();
}


void  AcceptCapacityReservationBillingOwnershipRequest::DumpBodyToUrl(Aws::Http::URI& uri ) const
{
  uri.SetQueryString(SerializePayload());
}
