﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/customer-profiles/model/MarketoSourceProperties.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace CustomerProfiles
{
namespace Model
{

MarketoSourceProperties::MarketoSourceProperties() : 
    m_objectHasBeenSet(false)
{
}

MarketoSourceProperties::MarketoSourceProperties(JsonView jsonValue)
  : MarketoSourceProperties()
{
  *this = jsonValue;
}

MarketoSourceProperties& MarketoSourceProperties::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Object"))
  {
    m_object = jsonValue.GetString("Object");

    m_objectHasBeenSet = true;
  }

  return *this;
}

JsonValue MarketoSourceProperties::Jsonize() const
{
  JsonValue payload;

  if(m_objectHasBeenSet)
  {
   payload.WithString("Object", m_object);

  }

  return payload;
}

} // namespace Model
} // namespace CustomerProfiles
} // namespace Aws
