﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appstream/model/FleetType.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace AppStream
  {
    namespace Model
    {
      namespace FleetTypeMapper
      {

        static const int ALWAYS_ON_HASH = HashingUtils::HashString("ALWAYS_ON");
        static const int ON_DEMAND_HASH = HashingUtils::HashString("ON_DEMAND");
        static const int ELASTIC_HASH = HashingUtils::HashString("ELASTIC");


        FleetType GetFleetTypeForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ALWAYS_ON_HASH)
          {
            return FleetType::ALWAYS_ON;
          }
          else if (hashCode == ON_DEMAND_HASH)
          {
            return FleetType::ON_DEMAND;
          }
          else if (hashCode == ELASTIC_HASH)
          {
            return FleetType::ELASTIC;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<FleetType>(hashCode);
          }

          return FleetType::NOT_SET;
        }

        Aws::String GetNameForFleetType(FleetType enumValue)
        {
          switch(enumValue)
          {
          case FleetType::NOT_SET:
            return {};
          case FleetType::ALWAYS_ON:
            return "ALWAYS_ON";
          case FleetType::ON_DEMAND:
            return "ON_DEMAND";
          case FleetType::ELASTIC:
            return "ELASTIC";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace FleetTypeMapper
    } // namespace Model
  } // namespace AppStream
} // namespace Aws
