

AC_DEFUN([ABI_AR_HINTS],[
  dnl Init
  abi_ar_vendor_hnt="none"
  abi_ar_version_hnt="none"
  abi_sys_spec_hnt="none"

  dnl Look for hints flags
  AC_MSG_CHECKING([which ar hints to apply])

  dnl Case built from config/hints/ar_*.conf
  if test "${abi_ar_vendor}" = "ibm"; then
    abi_ar_vendor_hnt="ibm"
    abi_ar_version_hnt="default"
    case "${abi_sys_spec}" in
      aix-*)
        abi_sys_spec_hnt="aix-*"
        ARFLAGS_32BITS='-X 32'
        ARFLAGS_64BITS='-X 64'
        ;;
      *)
        abi_sys_spec_hnt="default"
        ;;
    esac   # [case: abi_sys_spec, indent: 1, item: False]
  fi

  dnl Display settings
  AC_MSG_RESULT([${abi_ar_vendor_hnt}/${abi_ar_version_hnt}/${abi_sys_spec_hnt}])

]) #ABI_AR_HINTS


AC_DEFUN([ABI_CPP_HINTS],[
  dnl Init
  abi_cpp_vendor_hnt="none"
  abi_cpp_version_hnt="none"
  abi_sys_spec_hnt="none"

  dnl Look for hints flags
  AC_MSG_CHECKING([which cpp hints to apply])

  dnl Case built from config/hints/cpp_*.conf
  case "${abi_cpp_vendor}" in
    ibm)
      abi_cpp_vendor_hnt="ibm"
      abi_cpp_version_hnt="default"
      case "${abi_sys_spec}" in
        aix-*)
          abi_sys_spec_hnt="aix-*"
          CPPFLAGS_HINTS_EXT='-P -traditional-cpp'
          ;;
        linux-*)
          abi_sys_spec_hnt="linux-*"
          CPPFLAGS_HINTS_EXT='-P -traditional-cpp'
          ;;
        *)
          abi_sys_spec_hnt="default"
          ;;
      esac   # [case: abi_sys_spec, indent: 2, item: True]
      ;;
    *)
      abi_cpp_vendor_hnt="default"
      abi_cpp_version_hnt="default"
      abi_sys_spec_hnt="default"
      CPPFLAGS_HINTS_EXT='-P -std=c99'
      ;;
  esac   # [case: abi_cpp_vendor, indent: 0, item: True]

  dnl Display settings
  AC_MSG_RESULT([${abi_cpp_vendor_hnt}/${abi_cpp_version_hnt}/${abi_sys_spec_hnt}])

]) #ABI_CPP_HINTS


AC_DEFUN([ABI_CC_HINTS],[
  dnl Init
  abi_cc_vendor_hnt="none"
  abi_cc_version_hnt="none"
  abi_sys_spec_hnt="none"

  dnl Look for hints flags
  AC_MSG_CHECKING([which cc hints to apply])

  dnl Case built from config/hints/cc_*.conf
  case "${abi_cc_vendor}" in
    arm)
      abi_cc_vendor_hnt="arm"
      abi_cc_version_hnt="default"
      abi_sys_spec_hnt="default"
      CFLAGS_32BITS='-m32'
      CFLAGS_64BITS='-m64'
      CFLAGS_PIC='-fPIC'
      ;;
    gnu)
      abi_cc_vendor_hnt="gnu"
      abi_cc_version_hnt="default"
      case "${abi_sys_spec}" in
        irix-mips)
          abi_sys_spec_hnt="irix-mips"
          CFLAGS_32BITS='-mabi=32'
          CFLAGS_64BITS='-mabi=64'
          CFLAGS_PIC='-fPIC'
          ;;
        *)
          abi_sys_spec_hnt="default"
          CFLAGS_32BITS='-m32'
          CFLAGS_64BITS='-m64'
          CFLAGS_PIC='-fPIC'
          ;;
      esac   # [case: abi_sys_spec, indent: 2, item: True]
      ;;
    ibm)
      abi_cc_vendor_hnt="ibm"
      abi_cc_version_hnt="default"
      abi_sys_spec_hnt="default"
      CFLAGS_64BITS='-q64'
      CPPFLAGS_HINTS='-Wp,-DHAVE_CONFIG_H'
      CFLAGS_HINTS='-qlanglvl=extc99 -qsuppress=1520-031:1520-003'
      CFLAGS_PIC='-qpic'
      ;;
    intel)
      abi_cc_vendor_hnt="intel"
      abi_cc_version_hnt="default"
      abi_sys_spec_hnt="default"
      CC_LDFLAGS_HINTS='-static-libgcc -static-intel'
      openmp='-qopenmp'
      CFLAGS_PIC='-fPIC'
      ;;
    llvm)
      abi_cc_vendor_hnt="llvm"
      abi_cc_version_hnt="default"
      abi_sys_spec_hnt="default"
      CFLAGS_32BITS='-m32'
      CFLAGS_64BITS='-m64'
      CFLAGS_PIC='-fPIC'
      ;;
    nvhpc)
      abi_cc_vendor_hnt="nvhpc"
      abi_cc_version_hnt="default"
      abi_sys_spec_hnt="default"
      CFLAGS_32BITS='-m32'
      CFLAGS_64BITS='-m64'
      CFLAGS_PIC='-fPIC'
      ;;
    cray)
      abi_cc_vendor_hnt="cray"
      abi_cc_version_hnt="default"
      abi_sys_spec_hnt="default"
      CFLAGS_PIC='-fPIC'
      ;;
  esac   # [case: abi_cc_vendor, indent: 0, item: True]

  dnl Display settings
  AC_MSG_RESULT([${abi_cc_vendor_hnt}/${abi_cc_version_hnt}/${abi_sys_spec_hnt}])

]) #ABI_CC_HINTS


AC_DEFUN([ABI_XPP_HINTS],[
  dnl Init
  abi_xpp_vendor_hnt="none"
  abi_xpp_version_hnt="none"
  abi_sys_spec_hnt="none"

  dnl Look for hints flags
  AC_MSG_CHECKING([which xpp hints to apply])

  dnl WARNING: no config files were found for language

  dnl Display settings
  AC_MSG_RESULT([${abi_xpp_vendor_hnt}/${abi_xpp_version_hnt}/${abi_sys_spec_hnt}])

]) #ABI_XPP_HINTS


AC_DEFUN([ABI_CXX_HINTS],[
  dnl Init
  abi_cxx_vendor_hnt="none"
  abi_cxx_version_hnt="none"
  abi_sys_spec_hnt="none"

  dnl Look for hints flags
  AC_MSG_CHECKING([which cxx hints to apply])

  dnl Case built from config/hints/cxx_*.conf
  case "${abi_cxx_vendor}" in
    arm)
      abi_cxx_vendor_hnt="arm"
      abi_cxx_version_hnt="default"
      abi_sys_spec_hnt="default"
      CXXFLAGS_32BITS='-m32'
      CXXFLAGS_64BITS='-m64'
      CXXFLAGS_PIC='-fPIC'
      ;;
    gnu)
      abi_cxx_vendor_hnt="gnu"
      abi_cxx_version_hnt="default"
      abi_sys_spec_hnt="default"
      CXXFLAGS_32BITS='-m32'
      CXXFLAGS_64BITS='-m64'
      CXXFLAGS_PIC='-fPIC'
      ;;
    ibm)
      abi_cxx_vendor_hnt="ibm"
      abi_cxx_version_hnt="default"
      abi_sys_spec_hnt="default"
      CXXFLAGS_64BITS='-q64'
      CXXFLAGS_PIC='-qpic'
      ;;
    intel)
      abi_cxx_vendor_hnt="intel"
      abi_cxx_version_hnt="default"
      abi_sys_spec_hnt="default"
      CXX_LDFLAGS_HINTS='-static-libgcc -static-intel'
      CXXFLAGS_PIC='-fPIC'
      ;;
    llvm)
      abi_cxx_vendor_hnt="llvm"
      abi_cxx_version_hnt="default"
      abi_sys_spec_hnt="default"
      CXXFLAGS_32BITS='-m32'
      CXXFLAGS_64BITS='-m64'
      CXXFLAGS_PIC='-fPIC'
      ;;
    nvhpc)
      abi_cxx_vendor_hnt="nvhpc"
      abi_cxx_version_hnt="default"
      abi_sys_spec_hnt="default"
      CXXFLAGS_PIC='-fPIC'
      ;;
    cray)
      abi_cxx_vendor_hnt="cray"
      abi_cxx_version_hnt="default"
      abi_sys_spec_hnt="default"
      CXXFLAGS_PIC='-fPIC'
      ;;
  esac   # [case: abi_cxx_vendor, indent: 0, item: True]

  dnl Display settings
  AC_MSG_RESULT([${abi_cxx_vendor_hnt}/${abi_cxx_version_hnt}/${abi_sys_spec_hnt}])

]) #ABI_CXX_HINTS


AC_DEFUN([ABI_FPP_HINTS],[
  dnl Init
  abi_fpp_vendor_hnt="none"
  abi_fpp_version_hnt="none"
  abi_sys_spec_hnt="none"

  dnl Look for hints flags
  AC_MSG_CHECKING([which fpp hints to apply])

  dnl Case built from config/hints/fpp_*.conf
  case "${abi_fpp_vendor}" in
    ibm)
      abi_fpp_vendor_hnt="ibm"
      abi_fpp_version_hnt="default"
      abi_sys_spec_hnt="default"
      FPPFLAGS_HINTS_EXT='-P -traditional-cpp'
      ;;
    *)
      abi_fpp_vendor_hnt="default"
      abi_fpp_version_hnt="default"
      abi_sys_spec_hnt="default"
      FPPFLAGS_HINTS_EXT='-P'
      ;;
  esac   # [case: abi_fpp_vendor, indent: 0, item: True]

  dnl Display settings
  AC_MSG_RESULT([${abi_fpp_vendor_hnt}/${abi_fpp_version_hnt}/${abi_sys_spec_hnt}])

]) #ABI_FPP_HINTS


AC_DEFUN([ABI_FC_HINTS],[
  dnl Init
  abi_fc_vendor_hnt="none"
  abi_fc_version_hnt="none"
  abi_sys_spec_hnt="none"

  dnl Look for hints flags
  AC_MSG_CHECKING([which fc hints to apply])

  dnl Case built from config/hints/fc_*.conf
  case "${abi_fc_vendor}" in
    absoft)
      abi_fc_vendor_hnt="absoft"
      abi_fc_version_hnt="default"
      abi_sys_spec_hnt="default"
      FCFLAGS_FIXEDFORM='-ffixed'
      FCFLAGS_FREEFORM='-ffree'
      FCFLAGS_MODDIR='-p ../mods'
      FCFLAGS_OPENMP='-openmp'
      FCFLAGS_PIC='-fPIC'
      FPPFLAGS_HINTS='-P'
      ;;
    arm)
      abi_fc_vendor_hnt="arm"
      abi_fc_version_hnt="default"
      abi_sys_spec_hnt="default"
      FCFLAGS_32BITS='-m32'
      FCFLAGS_64BITS='-m64'
      FCFLAGS_PIC='-fPIC'
      FCFLAGS_OPENMP='-fopenmp -mp'
      FCFLAGS_MODDIR='-module $(abinit_moddir)'
      FCFLAGS_BIGENDIAN='-mbig-endian -frecord-marker=4'
      FCFLAGS_FREEFORM='-ffree-form'
      FCFLAGS_FIXEDFORM='-ffixed-form'
      FCFLAGS_HINTS='-Mextend -Qunused-arguments'
      ;;
    gnu)
      abi_fc_vendor_hnt="gnu"
      case "${abi_fc_version}" in
        7.*)
          abi_fc_version_hnt="7.*"
          abi_sys_spec_hnt="default"
          FCFLAGS_32BITS='-m32'
          FCFLAGS_64BITS='-m64'
          FCFLAGS_BIGENDIAN='-fconvert=big-endian -frecord-marker=4'
          FCFLAGS_FIXEDFORM='-ffixed-form'
          FCFLAGS_FREEFORM='-ffree-form'
          FCFLAGS_PIC='-fPIC'
          FCFLAGS_MODDIR='-J../mods'
          FCFLAGS_HINTS='-ffree-line-length-none'
          FCFLAGS_OPENMP='-fopenmp'
          ;;
        8.*)
          abi_fc_version_hnt="8.*"
          abi_sys_spec_hnt="default"
          FCFLAGS_32BITS='-m32'
          FCFLAGS_64BITS='-m64'
          FCFLAGS_BIGENDIAN='-fconvert=big-endian -frecord-marker=4'
          FCFLAGS_FIXEDFORM='-ffixed-form'
          FCFLAGS_FREEFORM='-ffree-form'
          FCFLAGS_PIC='-fPIC'
          FCFLAGS_MODDIR='-J../mods'
          FCFLAGS_HINTS='-ffree-line-length-none'
          FCFLAGS_OPENMP='-fopenmp'
          ;;
        9.*)
          abi_fc_version_hnt="9.*"
          abi_sys_spec_hnt="default"
          FCFLAGS_32BITS='-m32'
          FCFLAGS_64BITS='-m64'
          FCFLAGS_BIGENDIAN='-fconvert=big-endian -frecord-marker=4'
          FCFLAGS_FIXEDFORM='-ffixed-form'
          FCFLAGS_FREEFORM='-ffree-form'
          FCFLAGS_PIC='-fPIC'
          FCFLAGS_MODDIR='-J../mods'
          FCFLAGS_HINTS='-ffree-line-length-none'
          FCFLAGS_OPENMP='-fopenmp'
          ;;
        *)
          abi_fc_version_hnt="default"
          abi_sys_spec_hnt="default"
          FCFLAGS_32BITS='-m32'
          FCFLAGS_64BITS='-m64'
          FCFLAGS_BIGENDIAN='-fconvert=big-endian -frecord-marker=4'
          FCFLAGS_FIXEDFORM='-ffixed-form'
          FCFLAGS_FREEFORM='-ffree-form'
          FCFLAGS_PIC='-fPIC'
          FCFLAGS_MODDIR='-J../mods'
          FCFLAGS_HINTS='-ffree-line-length-none -fallow-argument-mismatch'
          FCFLAGS_OPENMP='-fopenmp'
          ;;
      esac   # [case: abi_fc_version, indent: 2, item: True]
      ;;
    ibm)
      abi_fc_vendor_hnt="ibm"
      abi_fc_version_hnt="default"
      abi_sys_spec_hnt="default"
      FCFLAGS_32BITS='-q32'
      FCFLAGS_64BITS='-q64'
      FCFLAGS_FIXEDFORM='-qsuffix=cpp=F:f=f -qfixed'
      FCFLAGS_FREEFORM='-qsuffix=cpp=F90:f=f90 -qfree=f90'
      FCFLAGS_PIC='-qpic'
      FCFLAGS_MODDIR='-qmoddir=../mods -I../mods'
      FPPFLAGS_HINTS='-WF,-DHAVE_CONFIG_H'
      FCFLAGS_HINTS='-q64 -qzerosize -bmaxdata:2000000000 -qmaxmem=-1 -qspillsize=1664 -qstrict -qsuppress=1520-003:1520-031:1515-009'
      FCFLAGS_OPENMP='-qsmp'
      ;;
    intel)
      abi_fc_vendor_hnt="intel"
      abi_fc_version_hnt="default"
      abi_sys_spec_hnt="default"
      FCFLAGS_BIGENDIAN='-convert big_endian'
      FCFLAGS_FIXEDFORM='-fixed'
      FCFLAGS_FREEFORM='-free'
      FCFLAGS_MODDIR='-module ../mods'
      FCFLAGS_PIC='-fPIC'
      FCFLAGS_HINTS='-extend-source -nofpscomp'
      FC_LDFLAGS_HINTS='-static-intel -static-libgcc'
      FCFLAGS_OPENMP='-qopenmp'
      ;;
    llvm)
      abi_fc_vendor_hnt="llvm"
      abi_fc_version_hnt="default"
      abi_sys_spec_hnt="default"
      FCFLAGS_32BITS='-m32'
      FCFLAGS_64BITS='-m64'
      FCFLAGS_PIC='-fPIC'
      FCFLAGS_OPENMP='-fopenmp'
      FCFLAGS_OPENMP_OFFLOAD='-fopenmp --offload-arch=__GPU_ARCH__'
      FCFLAGS_MODDIR='-module ../mods'
      FCFLAGS_BIGENDIAN='-mbig-endian -frecord-marker=4'
      FCFLAGS_FREEFORM='-Mfree'
      FCFLAGS_FIXEDFORM='-Mfixed'
      FCFLAGS_HINTS='-Mextend -Qunused-arguments'
      ;;
    nag)
      abi_fc_vendor_hnt="nag"
      abi_fc_version_hnt="default"
      abi_sys_spec_hnt="default"
      FCFLAGS_64BITS='-64t'
      FCFLAGS_FIXEDFORM='-fixed'
      FCFLAGS_FREEFORM='-free'
      FCFLAGS_PIC='-PIC'
      FCFLAGS_OPENMP='-openmp'
      FCFLAGS_MODDIR='-mdir ../mods -I../mods'
      FCFLAGS_HINTS='-DFC_NAG  -w -kind=byte -gline -dcfuns -C=intovf -C=present -C=array -mismatch'
      ;;
    nvhpc)
      abi_fc_vendor_hnt="nvhpc"
      abi_fc_version_hnt="default"
      abi_sys_spec_hnt="default"
      FCFLAGS_FIXEDFORM='-Mfixed'
      FCFLAGS_FREEFORM='-Mfree'
      FCFLAGS_MODDIR='-module ../mods'
      FCFLAGS_PIC='-fPIC'
      FCFLAGS_HINTS='-Mextend'
      FCFLAGS_OPENMP='-mp'
      FCFLAGS_OPENMP_OFFLOAD='-mp=gpu -Minfo=mp -gpu=cc__GPU_ARCH__'
      FC_LDFLAGS_HINTS=''
      ;;
    pgi)
      abi_fc_vendor_hnt="pgi"
      abi_fc_version_hnt="default"
      abi_sys_spec_hnt="default"
      FCFLAGS_FIXEDFORM='-Mfixed'
      FCFLAGS_FREEFORM='-Mfree'
      FCFLAGS_MODDIR='-module ../mods'
      FCFLAGS_PIC='-fPIC'
      FCFLAGS_HINTS='-Mextend'
      FC_LDFLAGS_HINTS=''
      ;;
    cray)
      abi_fc_vendor_hnt="cray"
      abi_fc_version_hnt="default"
      abi_sys_spec_hnt="default"
      FCFLAGS_BIGENDIAN='-h byteswapio'
      FCFLAGS_FIXEDFORM='-f fixed'
      FCFLAGS_FREEFORM='-f free'
      FCFLAGS_PIC='-f PIC'
      FCFLAGS_MODDIR='-J ../mods'
      FCFLAGS_OPENMP='-f openmp'
      FCFLAGS_HINTS='-DFC_CRAY -ef'
      ;;
  esac   # [case: abi_fc_vendor, indent: 0, item: True]

  dnl Display settings
  AC_MSG_RESULT([${abi_fc_vendor_hnt}/${abi_fc_version_hnt}/${abi_sys_spec_hnt}])

]) #ABI_FC_HINTS
