#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscglobusauthorize_ PETSCGLOBUSAUTHORIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscglobusauthorize_ petscglobusauthorize
#endif
PETSC_EXTERN void petscglobusauthorize_(MPI_Fint *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  *ierr = PetscGlobusAuthorize(MPI_Comm_f2c(*(a)), b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscglobusgettransfers_ PETSCGLOBUSGETTRANSFERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscglobusgettransfers_ petscglobusgettransfers
#endif
PETSC_EXTERN void petscglobusgettransfers_(MPI_Fint *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscGlobusGetTransfers(MPI_Comm_f2c(*(a)), c_b, c, l_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscglobusupload_ PETSCGLOBUSUPLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscglobusupload_ petscglobusupload
#endif
PETSC_EXTERN void petscglobusupload_(MPI_Fint *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscGlobusUpload(MPI_Comm_f2c(*(a)), c_b, c_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
