#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqsellsetpreallocation_ MATSEQSELLSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqsellsetpreallocation_ matseqsellsetpreallocation
#endif
PETSC_EXTERN void matseqsellsetpreallocation_(Mat *a, PetscInt *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatSeqSELLSetPreallocation(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqsellgetfillratio_ MATSEQSELLGETFILLRATIO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqsellgetfillratio_ matseqsellgetfillratio
#endif
PETSC_EXTERN void matseqsellgetfillratio_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatSeqSELLGetFillRatio(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqsellgetmaxslicewidth_ MATSEQSELLGETMAXSLICEWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqsellgetmaxslicewidth_ matseqsellgetmaxslicewidth
#endif
PETSC_EXTERN void matseqsellgetmaxslicewidth_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatSeqSELLGetMaxSliceWidth(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqsellgetavgslicewidth_ MATSEQSELLGETAVGSLICEWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqsellgetavgslicewidth_ matseqsellgetavgslicewidth
#endif
PETSC_EXTERN void matseqsellgetavgslicewidth_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatSeqSELLGetAvgSliceWidth(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqsellsetsliceheight_ MATSEQSELLSETSLICEHEIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqsellsetsliceheight_ matseqsellsetsliceheight
#endif
PETSC_EXTERN void matseqsellsetsliceheight_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatSeqSELLSetSliceHeight(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqsellgetvarslicesize_ MATSEQSELLGETVARSLICESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqsellgetvarslicesize_ matseqsellgetvarslicesize
#endif
PETSC_EXTERN void matseqsellgetvarslicesize_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatSeqSELLGetVarSliceSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqsell_ MATCREATESEQSELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqsell_ matcreateseqsell
#endif
PETSC_EXTERN void matcreateseqsell_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscInt e[], Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatCreateSeqSELL(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
