#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetreferencetree_ DMPLEXSETREFERENCETREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetreferencetree_ dmplexsetreferencetree
#endif
PETSC_EXTERN void dmplexsetreferencetree_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetReferenceTree(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetreferencetree_ DMPLEXGETREFERENCETREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetreferencetree_ dmplexgetreferencetree
#endif
PETSC_EXTERN void dmplexgetreferencetree_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetReferenceTree(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexreferencetreegetchildsymmetry_ DMPLEXREFERENCETREEGETCHILDSYMMETRY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexreferencetreegetchildsymmetry_ dmplexreferencetreegetchildsymmetry
#endif
PETSC_EXTERN void dmplexreferencetreegetchildsymmetry_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscInt *h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(h);
  *ierr = DMPlexReferenceTreeGetChildSymmetry(*a, *b, *c, *d, *e, *f, g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatedefaultreferencetree_ DMPLEXCREATEDEFAULTREFERENCETREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatedefaultreferencetree_ dmplexcreatedefaultreferencetree
#endif
PETSC_EXTERN void dmplexcreatedefaultreferencetree_(MPI_Fint *a, PetscInt *b, PetscBool *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateDefaultReferenceTree(MPI_Comm_f2c(*(a)), *b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsettree_ DMPLEXSETTREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsettree_ dmplexsettree
#endif
PETSC_EXTERN void dmplexsettree_(DM *a, PetscSection *b, PetscInt c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexSetTree(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgettreeparent_ DMPLEXGETTREEPARENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgettreeparent_ dmplexgettreeparent
#endif
PETSC_EXTERN void dmplexgettreeparent_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexGetTreeParent(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextreerefinecell_ DMPLEXTREEREFINECELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextreerefinecell_ dmplextreerefinecell
#endif
PETSC_EXTERN void dmplextreerefinecell_(DM *a, PetscInt *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexTreeRefineCell(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeinjectorreferencetree_ DMPLEXCOMPUTEINJECTORREFERENCETREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeinjectorreferencetree_ dmplexcomputeinjectorreferencetree
#endif
PETSC_EXTERN void dmplexcomputeinjectorreferencetree_(DM *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexComputeInjectorReferenceTree(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransfervectree_ DMPLEXTRANSFERVECTREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransfervectree_ dmplextransfervectree
#endif
PETSC_EXTERN void dmplextransfervectree_(DM *a, Vec *b, DM *c, Vec *d, PetscSF *e, PetscSF *f, PetscInt *g, PetscInt *h, PetscBool *i, PetscReal *j, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(h);
  *ierr = DMPlexTransferVecTree(*a, *b, *c, *d, *e, *f, g, h, *i ? PETSC_TRUE : PETSC_FALSE, *j);
  if (*ierr) return;
}
