#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabfemcreatequadraturedefault_ DMMOABFEMCREATEQUADRATUREDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabfemcreatequadraturedefault_ dmmoabfemcreatequadraturedefault
#endif
PETSC_EXTERN void dmmoabfemcreatequadraturedefault_(const PetscInt *a, const PetscInt *b, PetscQuadrature *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMMoabFEMCreateQuadratureDefault(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabptormapping_ DMMOABPTORMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabptormapping_ dmmoabptormapping
#endif
PETSC_EXTERN void dmmoabptormapping_(const PetscInt *a, const PetscInt *b, const PetscReal *c, const PetscReal *d, PetscReal *e, PetscReal *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  *ierr = DMMoabPToRMapping(*a, *b, c, d, e, f);
  if (*ierr) return;
}
