#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchypresetdiscretegradient_ PCHYPRESETDISCRETEGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchypresetdiscretegradient_ pchypresetdiscretegradient
#endif
PETSC_EXTERN void pchypresetdiscretegradient_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCHYPRESetDiscreteGradient(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchypresetdiscretecurl_ PCHYPRESETDISCRETECURL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchypresetdiscretecurl_ pchypresetdiscretecurl
#endif
PETSC_EXTERN void pchypresetdiscretecurl_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCHYPRESetDiscreteCurl(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchypresetinterpolations_ PCHYPRESETINTERPOLATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchypresetinterpolations_ pchypresetinterpolations
#endif
PETSC_EXTERN void pchypresetinterpolations_(PC *a, PetscInt *b, Mat *c, Mat d[], Mat *e, Mat f[], PetscErrorCode *ierr)
{
  *ierr = PCHYPRESetInterpolations(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchypresetalphapoissonmatrix_ PCHYPRESETALPHAPOISSONMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchypresetalphapoissonmatrix_ pchypresetalphapoissonmatrix
#endif
PETSC_EXTERN void pchypresetalphapoissonmatrix_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCHYPRESetAlphaPoissonMatrix(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchypresetbetapoissonmatrix_ PCHYPRESETBETAPOISSONMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchypresetbetapoissonmatrix_ pchypresetbetapoissonmatrix
#endif
PETSC_EXTERN void pchypresetbetapoissonmatrix_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCHYPRESetBetaPoissonMatrix(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchypresetedgeconstantvectors_ PCHYPRESETEDGECONSTANTVECTORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchypresetedgeconstantvectors_ pchypresetedgeconstantvectors
#endif
PETSC_EXTERN void pchypresetedgeconstantvectors_(PC *a, Vec *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = PCHYPRESetEdgeConstantVectors(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchypreamssetinteriornodes_ PCHYPREAMSSETINTERIORNODES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchypreamssetinteriornodes_ pchypreamssetinteriornodes
#endif
PETSC_EXTERN void pchypreamssetinteriornodes_(PC *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = PCHYPREAMSSetInteriorNodes(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchypresettype_ PCHYPRESETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchypresettype_ pchypresettype
#endif
PETSC_EXTERN void pchypresettype_(PC *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCHYPRESetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchypregettype_ PCHYPREGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchypregettype_ pchypregettype
#endif
PETSC_EXTERN void pchypregettype_(PC *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PCHYPREGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggalerkinsetmatproductalgorithm_ PCMGGALERKINSETMATPRODUCTALGORITHM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggalerkinsetmatproductalgorithm_ pcmggalerkinsetmatproductalgorithm
#endif
PETSC_EXTERN void pcmggalerkinsetmatproductalgorithm_(PC *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCMGGalerkinSetMatProductAlgorithm(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggalerkingetmatproductalgorithm_ PCMGGALERKINGETMATPRODUCTALGORITHM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggalerkingetmatproductalgorithm_ pcmggalerkingetmatproductalgorithm
#endif
PETSC_EXTERN void pcmggalerkingetmatproductalgorithm_(PC *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PCMGGalerkinGetMatProductAlgorithm(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
