#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitrestrictis_ PCFIELDSPLITRESTRICTIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitrestrictis_ pcfieldsplitrestrictis
#endif
PETSC_EXTERN void pcfieldsplitrestrictis_(PC *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitRestrictIS(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetfields_ PCFIELDSPLITSETFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetfields_ pcfieldsplitsetfields
#endif
PETSC_EXTERN void pcfieldsplitsetfields_(PC *a, char b[], PetscInt *c, const PetscInt d[], const PetscInt e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = PCFieldSplitSetFields(*a, c_b, *c, d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetdiaguseamat_ PCFIELDSPLITSETDIAGUSEAMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetdiaguseamat_ pcfieldsplitsetdiaguseamat
#endif
PETSC_EXTERN void pcfieldsplitsetdiaguseamat_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetDiagUseAmat(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitgetdiaguseamat_ PCFIELDSPLITGETDIAGUSEAMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitgetdiaguseamat_ pcfieldsplitgetdiaguseamat
#endif
PETSC_EXTERN void pcfieldsplitgetdiaguseamat_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCFieldSplitGetDiagUseAmat(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetoffdiaguseamat_ PCFIELDSPLITSETOFFDIAGUSEAMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetoffdiaguseamat_ pcfieldsplitsetoffdiaguseamat
#endif
PETSC_EXTERN void pcfieldsplitsetoffdiaguseamat_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetOffDiagUseAmat(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitgetoffdiaguseamat_ PCFIELDSPLITGETOFFDIAGUSEAMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitgetoffdiaguseamat_ pcfieldsplitgetoffdiaguseamat
#endif
PETSC_EXTERN void pcfieldsplitgetoffdiaguseamat_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCFieldSplitGetOffDiagUseAmat(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetis_ PCFIELDSPLITSETIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetis_ pcfieldsplitsetis
#endif
PETSC_EXTERN void pcfieldsplitsetis_(PC *a, char b[], IS *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCFieldSplitSetIS(*a, c_b, *c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitgetis_ PCFIELDSPLITGETIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitgetis_ pcfieldsplitgetis
#endif
PETSC_EXTERN void pcfieldsplitgetis_(PC *a, char b[], IS *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCFieldSplitGetIS(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitgetisbyindex_ PCFIELDSPLITGETISBYINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitgetisbyindex_ pcfieldsplitgetisbyindex
#endif
PETSC_EXTERN void pcfieldsplitgetisbyindex_(PC *a, PetscInt *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCFieldSplitGetISByIndex(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetblocksize_ PCFIELDSPLITSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetblocksize_ pcfieldsplitsetblocksize
#endif
PETSC_EXTERN void pcfieldsplitsetblocksize_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetBlockSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetschurpre_ PCFIELDSPLITSETSCHURPRE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetschurpre_ pcfieldsplitsetschurpre
#endif
PETSC_EXTERN void pcfieldsplitsetschurpre_(PC *a, PCFieldSplitSchurPreType *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetSchurPre(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitgetschurpre_ PCFIELDSPLITGETSCHURPRE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitgetschurpre_ pcfieldsplitgetschurpre
#endif
PETSC_EXTERN void pcfieldsplitgetschurpre_(PC *a, PCFieldSplitSchurPreType *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCFieldSplitGetSchurPre(*a, b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitschurgets_ PCFIELDSPLITSCHURGETS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitschurgets_ pcfieldsplitschurgets
#endif
PETSC_EXTERN void pcfieldsplitschurgets_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCFieldSplitSchurGetS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitschurrestores_ PCFIELDSPLITSCHURRESTORES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitschurrestores_ pcfieldsplitschurrestores
#endif
PETSC_EXTERN void pcfieldsplitschurrestores_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCFieldSplitSchurRestoreS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetschurfacttype_ PCFIELDSPLITSETSCHURFACTTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetschurfacttype_ pcfieldsplitsetschurfacttype
#endif
PETSC_EXTERN void pcfieldsplitsetschurfacttype_(PC *a, PCFieldSplitSchurFactType *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetSchurFactType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetschurscale_ PCFIELDSPLITSETSCHURSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetschurscale_ pcfieldsplitsetschurscale
#endif
PETSC_EXTERN void pcfieldsplitsetschurscale_(PC *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetSchurScale(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitgetschurblocks_ PCFIELDSPLITGETSCHURBLOCKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitgetschurblocks_ pcfieldsplitgetschurblocks
#endif
PETSC_EXTERN void pcfieldsplitgetschurblocks_(PC *a, Mat *b, Mat *c, Mat *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PCFieldSplitGetSchurBlocks(*a, b, c, d, e);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetgkbtol_ PCFIELDSPLITSETGKBTOL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetgkbtol_ pcfieldsplitsetgkbtol
#endif
PETSC_EXTERN void pcfieldsplitsetgkbtol_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetGKBTol(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetgkbmaxit_ PCFIELDSPLITSETGKBMAXIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetgkbmaxit_ pcfieldsplitsetgkbmaxit
#endif
PETSC_EXTERN void pcfieldsplitsetgkbmaxit_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetGKBMaxit(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetgkbdelay_ PCFIELDSPLITSETGKBDELAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetgkbdelay_ pcfieldsplitsetgkbdelay
#endif
PETSC_EXTERN void pcfieldsplitsetgkbdelay_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetGKBDelay(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetgkbnu_ PCFIELDSPLITSETGKBNU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetgkbnu_ pcfieldsplitsetgkbnu
#endif
PETSC_EXTERN void pcfieldsplitsetgkbnu_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetGKBNu(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsettype_ PCFIELDSPLITSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsettype_ pcfieldsplitsettype
#endif
PETSC_EXTERN void pcfieldsplitsettype_(PC *a, PCCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitgettype_ PCFIELDSPLITGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitgettype_ pcfieldsplitgettype
#endif
PETSC_EXTERN void pcfieldsplitgettype_(PC *a, PCCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetdmsplits_ PCFIELDSPLITSETDMSPLITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetdmsplits_ pcfieldsplitsetdmsplits
#endif
PETSC_EXTERN void pcfieldsplitsetdmsplits_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetDMSplits(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitgetdmsplits_ PCFIELDSPLITGETDMSPLITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitgetdmsplits_ pcfieldsplitgetdmsplits
#endif
PETSC_EXTERN void pcfieldsplitgetdmsplits_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCFieldSplitGetDMSplits(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitgetdetectsaddlepoint_ PCFIELDSPLITGETDETECTSADDLEPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitgetdetectsaddlepoint_ pcfieldsplitgetdetectsaddlepoint
#endif
PETSC_EXTERN void pcfieldsplitgetdetectsaddlepoint_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCFieldSplitGetDetectSaddlePoint(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcfieldsplitsetdetectsaddlepoint_ PCFIELDSPLITSETDETECTSADDLEPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcfieldsplitsetdetectsaddlepoint_ pcfieldsplitsetdetectsaddlepoint
#endif
PETSC_EXTERN void pcfieldsplitsetdetectsaddlepoint_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCFieldSplitSetDetectSaddlePoint(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
