#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetboundarytypes_ DMSTAGGETBOUNDARYTYPES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetboundarytypes_ dmstaggetboundarytypes
#endif
PETSC_EXTERN void dmstaggetboundarytypes_(DM *a, DMBoundaryType *b, DMBoundaryType *c, DMBoundaryType *d, PetscErrorCode *ierr)
{
  *ierr = DMStagGetBoundaryTypes(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetproductcoordinatearrays_ DMSTAGGETPRODUCTCOORDINATEARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetproductcoordinatearrays_ dmstaggetproductcoordinatearrays
#endif
PETSC_EXTERN void dmstaggetproductcoordinatearrays_(DM *a, void *b, void *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMStagGetProductCoordinateArrays(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetproductcoordinatearraysread_ DMSTAGGETPRODUCTCOORDINATEARRAYSREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetproductcoordinatearraysread_ dmstaggetproductcoordinatearraysread
#endif
PETSC_EXTERN void dmstaggetproductcoordinatearraysread_(DM *a, void *b, void *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMStagGetProductCoordinateArraysRead(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetcorners_ DMSTAGGETCORNERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetcorners_ dmstaggetcorners
#endif
PETSC_EXTERN void dmstaggetcorners_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscInt *h, PetscInt *i, PetscInt *j, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLINTEGER(i);
  CHKFORTRANNULLINTEGER(j);
  *ierr = DMStagGetCorners(*a, b, c, d, e, f, g, h, i, j);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetdof_ DMSTAGGETDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetdof_ dmstaggetdof
#endif
PETSC_EXTERN void dmstaggetdof_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMStagGetDOF(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetghostcorners_ DMSTAGGETGHOSTCORNERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetghostcorners_ dmstaggetghostcorners
#endif
PETSC_EXTERN void dmstaggetghostcorners_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  *ierr = DMStagGetGhostCorners(*a, b, c, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetglobalsizes_ DMSTAGGETGLOBALSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetglobalsizes_ dmstaggetglobalsizes
#endif
PETSC_EXTERN void dmstaggetglobalsizes_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMStagGetGlobalSizes(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetisfirstrank_ DMSTAGGETISFIRSTRANK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetisfirstrank_ dmstaggetisfirstrank
#endif
PETSC_EXTERN void dmstaggetisfirstrank_(DM *a, PetscBool *b, PetscBool *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = DMStagGetIsFirstRank(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetislastrank_ DMSTAGGETISLASTRANK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetislastrank_ dmstaggetislastrank
#endif
PETSC_EXTERN void dmstaggetislastrank_(DM *a, PetscBool *b, PetscBool *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = DMStagGetIsLastRank(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetlocalsizes_ DMSTAGGETLOCALSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetlocalsizes_ dmstaggetlocalsizes
#endif
PETSC_EXTERN void dmstaggetlocalsizes_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMStagGetLocalSizes(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetnumranks_ DMSTAGGETNUMRANKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetnumranks_ dmstaggetnumranks
#endif
PETSC_EXTERN void dmstaggetnumranks_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMStagGetNumRanks(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetentries_ DMSTAGGETENTRIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetentries_ dmstaggetentries
#endif
PETSC_EXTERN void dmstaggetentries_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMStagGetEntries(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetentrieslocal_ DMSTAGGETENTRIESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetentrieslocal_ dmstaggetentrieslocal
#endif
PETSC_EXTERN void dmstaggetentrieslocal_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMStagGetEntriesLocal(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetentriesperelement_ DMSTAGGETENTRIESPERELEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetentriesperelement_ dmstaggetentriesperelement
#endif
PETSC_EXTERN void dmstaggetentriesperelement_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMStagGetEntriesPerElement(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetstenciltype_ DMSTAGGETSTENCILTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetstenciltype_ dmstaggetstenciltype
#endif
PETSC_EXTERN void dmstaggetstenciltype_(DM *a, DMStagStencilType *b, PetscErrorCode *ierr)
{
  *ierr = DMStagGetStencilType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetstencilwidth_ DMSTAGGETSTENCILWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetstencilwidth_ dmstaggetstencilwidth
#endif
PETSC_EXTERN void dmstaggetstencilwidth_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMStagGetStencilWidth(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagcreatecompatibledmstag_ DMSTAGCREATECOMPATIBLEDMSTAG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagcreatecompatibledmstag_ dmstagcreatecompatibledmstag
#endif
PETSC_EXTERN void dmstagcreatecompatibledmstag_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, DM *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMStagCreateCompatibleDMStag(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetlocationslot_ DMSTAGGETLOCATIONSLOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetlocationslot_ dmstaggetlocationslot
#endif
PETSC_EXTERN void dmstaggetlocationslot_(DM *a, DMStagStencilLocation *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMStagGetLocationSlot(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetrefinementfactor_ DMSTAGGETREFINEMENTFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetrefinementfactor_ dmstaggetrefinementfactor
#endif
PETSC_EXTERN void dmstaggetrefinementfactor_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMStagGetRefinementFactor(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagmigratevec_ DMSTAGMIGRATEVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagmigratevec_ dmstagmigratevec
#endif
PETSC_EXTERN void dmstagmigratevec_(DM *a, Vec *b, DM *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMStagMigrateVec(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagpopulatelocaltoglobalinjective_ DMSTAGPOPULATELOCALTOGLOBALINJECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagpopulatelocaltoglobalinjective_ dmstagpopulatelocaltoglobalinjective
#endif
PETSC_EXTERN void dmstagpopulatelocaltoglobalinjective_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMStagPopulateLocalToGlobalInjective(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagrestoreproductcoordinatearrays_ DMSTAGRESTOREPRODUCTCOORDINATEARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagrestoreproductcoordinatearrays_ dmstagrestoreproductcoordinatearrays
#endif
PETSC_EXTERN void dmstagrestoreproductcoordinatearrays_(DM *a, void *b, void *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMStagRestoreProductCoordinateArrays(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagrestoreproductcoordinatearraysread_ DMSTAGRESTOREPRODUCTCOORDINATEARRAYSREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagrestoreproductcoordinatearraysread_ dmstagrestoreproductcoordinatearraysread
#endif
PETSC_EXTERN void dmstagrestoreproductcoordinatearraysread_(DM *a, void *b, void *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMStagRestoreProductCoordinateArraysRead(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetboundarytypes_ DMSTAGSETBOUNDARYTYPES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetboundarytypes_ dmstagsetboundarytypes
#endif
PETSC_EXTERN void dmstagsetboundarytypes_(DM *a, DMBoundaryType *b, DMBoundaryType *c, DMBoundaryType *d, PetscErrorCode *ierr)
{
  *ierr = DMStagSetBoundaryTypes(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetcoordinatedmtype_ DMSTAGSETCOORDINATEDMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetcoordinatedmtype_ dmstagsetcoordinatedmtype
#endif
PETSC_EXTERN void dmstagsetcoordinatedmtype_(DM *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMStagSetCoordinateDMType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetdof_ DMSTAGSETDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetdof_ dmstagsetdof
#endif
PETSC_EXTERN void dmstagsetdof_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  *ierr = DMStagSetDOF(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetnumranks_ DMSTAGSETNUMRANKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetnumranks_ dmstagsetnumranks
#endif
PETSC_EXTERN void dmstagsetnumranks_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMStagSetNumRanks(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetstenciltype_ DMSTAGSETSTENCILTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetstenciltype_ dmstagsetstenciltype
#endif
PETSC_EXTERN void dmstagsetstenciltype_(DM *a, DMStagStencilType *b, PetscErrorCode *ierr)
{
  *ierr = DMStagSetStencilType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetstencilwidth_ DMSTAGSETSTENCILWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetstencilwidth_ dmstagsetstencilwidth
#endif
PETSC_EXTERN void dmstagsetstencilwidth_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMStagSetStencilWidth(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetglobalsizes_ DMSTAGSETGLOBALSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetglobalsizes_ dmstagsetglobalsizes
#endif
PETSC_EXTERN void dmstagsetglobalsizes_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMStagSetGlobalSizes(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetownershipranges_ DMSTAGSETOWNERSHIPRANGES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetownershipranges_ dmstagsetownershipranges
#endif
PETSC_EXTERN void dmstagsetownershipranges_(DM *a, const PetscInt b[], const PetscInt c[], const PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMStagSetOwnershipRanges(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetrefinementfactor_ DMSTAGSETREFINEMENTFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetrefinementfactor_ dmstagsetrefinementfactor
#endif
PETSC_EXTERN void dmstagsetrefinementfactor_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMStagSetRefinementFactor(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetuniformcoordinates_ DMSTAGSETUNIFORMCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetuniformcoordinates_ dmstagsetuniformcoordinates
#endif
PETSC_EXTERN void dmstagsetuniformcoordinates_(DM *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscErrorCode *ierr)
{
  *ierr = DMStagSetUniformCoordinates(*a, *b, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetuniformcoordinatesexplicit_ DMSTAGSETUNIFORMCOORDINATESEXPLICIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetuniformcoordinatesexplicit_ dmstagsetuniformcoordinatesexplicit
#endif
PETSC_EXTERN void dmstagsetuniformcoordinatesexplicit_(DM *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscErrorCode *ierr)
{
  *ierr = DMStagSetUniformCoordinatesExplicit(*a, *b, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagsetuniformcoordinatesproduct_ DMSTAGSETUNIFORMCOORDINATESPRODUCT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagsetuniformcoordinatesproduct_ dmstagsetuniformcoordinatesproduct
#endif
PETSC_EXTERN void dmstagsetuniformcoordinatesproduct_(DM *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscErrorCode *ierr)
{
  *ierr = DMStagSetUniformCoordinatesProduct(*a, *b, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagvecgetarray_ DMSTAGVECGETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagvecgetarray_ dmstagvecgetarray
#endif
PETSC_EXTERN void dmstagvecgetarray_(DM *a, Vec *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMStagVecGetArray(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagvecgetarrayread_ DMSTAGVECGETARRAYREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagvecgetarrayread_ dmstagvecgetarrayread
#endif
PETSC_EXTERN void dmstagvecgetarrayread_(DM *a, Vec *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMStagVecGetArrayRead(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagvecrestorearray_ DMSTAGVECRESTOREARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagvecrestorearray_ dmstagvecrestorearray
#endif
PETSC_EXTERN void dmstagvecrestorearray_(DM *a, Vec *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMStagVecRestoreArray(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagvecrestorearrayread_ DMSTAGVECRESTOREARRAYREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagvecrestorearrayread_ dmstagvecrestorearrayread
#endif
PETSC_EXTERN void dmstagvecrestorearrayread_(DM *a, Vec *b, void *c, PetscErrorCode *ierr)
{
  *ierr = DMStagVecRestoreArrayRead(*a, *b, c);
  if (*ierr) return;
}
