#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscintsortsemiordered_ PETSCINTSORTSEMIORDERED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscintsortsemiordered_ petscintsortsemiordered
#endif
PETSC_EXTERN void petscintsortsemiordered_(PetscInt *a, PetscInt b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscIntSortSemiOrdered(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscintsortsemiorderedwitharray_ PETSCINTSORTSEMIORDEREDWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscintsortsemiorderedwitharray_ petscintsortsemiorderedwitharray
#endif
PETSC_EXTERN void petscintsortsemiorderedwitharray_(PetscInt *a, PetscInt b[], PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscIntSortSemiOrderedWithArray(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmpiintsortsemiordered_ PETSCMPIINTSORTSEMIORDERED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmpiintsortsemiordered_ petscmpiintsortsemiordered
#endif
PETSC_EXTERN void petscmpiintsortsemiordered_(PetscInt *a, PetscMPIInt b[], PetscErrorCode *ierr)
{
  *ierr = PetscMPIIntSortSemiOrdered(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmpiintsortsemiorderedwitharray_ PETSCMPIINTSORTSEMIORDEREDWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmpiintsortsemiorderedwitharray_ petscmpiintsortsemiorderedwitharray
#endif
PETSC_EXTERN void petscmpiintsortsemiorderedwitharray_(PetscInt *a, PetscMPIInt b[], PetscMPIInt c[], PetscErrorCode *ierr)
{
  *ierr = PetscMPIIntSortSemiOrderedWithArray(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrealsortsemiordered_ PETSCREALSORTSEMIORDERED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrealsortsemiordered_ petscrealsortsemiordered
#endif
PETSC_EXTERN void petscrealsortsemiordered_(PetscInt *a, PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PetscRealSortSemiOrdered(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrealsortsemiorderedwitharrayint_ PETSCREALSORTSEMIORDEREDWITHARRAYINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrealsortsemiorderedwitharrayint_ petscrealsortsemiorderedwitharrayint
#endif
PETSC_EXTERN void petscrealsortsemiorderedwitharrayint_(PetscInt *a, PetscReal b[], PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscRealSortSemiOrderedWithArrayInt(*a, b, c);
  if (*ierr) return;
}
