#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextscomputerhsfunctionfvm_ DMPLEXTSCOMPUTERHSFUNCTIONFVM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextscomputerhsfunctionfvm_ dmplextscomputerhsfunctionfvm
#endif
PETSC_EXTERN void dmplextscomputerhsfunctionfvm_(DM *a, PetscReal *b, Vec *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = DMPlexTSComputeRHSFunctionFVM(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextscomputeboundary_ DMPLEXTSCOMPUTEBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextscomputeboundary_ dmplextscomputeboundary
#endif
PETSC_EXTERN void dmplextscomputeboundary_(DM *a, PetscReal *b, Vec *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = DMPlexTSComputeBoundary(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextscomputeifunctionfem_ DMPLEXTSCOMPUTEIFUNCTIONFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextscomputeifunctionfem_ dmplextscomputeifunctionfem
#endif
PETSC_EXTERN void dmplextscomputeifunctionfem_(DM *a, PetscReal *b, Vec *c, Vec *d, Vec *e, void *f, PetscErrorCode *ierr)
{
  *ierr = DMPlexTSComputeIFunctionFEM(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextscomputeijacobianfem_ DMPLEXTSCOMPUTEIJACOBIANFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextscomputeijacobianfem_ dmplextscomputeijacobianfem
#endif
PETSC_EXTERN void dmplextscomputeijacobianfem_(DM *a, PetscReal *b, Vec *c, Vec *d, PetscReal *e, Mat *f, Mat *g, void *h, PetscErrorCode *ierr)
{
  *ierr = DMPlexTSComputeIJacobianFEM(*a, *b, *c, *d, *e, *f, *g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextscomputerhsfunctionfem_ DMPLEXTSCOMPUTERHSFUNCTIONFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextscomputerhsfunctionfem_ dmplextscomputerhsfunctionfem
#endif
PETSC_EXTERN void dmplextscomputerhsfunctionfem_(DM *a, PetscReal *b, Vec *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = DMPlexTSComputeRHSFunctionFEM(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmtscheckresidual_ DMTSCHECKRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmtscheckresidual_ dmtscheckresidual
#endif
PETSC_EXTERN void dmtscheckresidual_(TS *a, DM *b, PetscReal *c, Vec *d, Vec *e, PetscReal *f, PetscReal *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(g);
  *ierr = DMTSCheckResidual(*a, *b, *c, *d, *e, *f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmtscheckjacobian_ DMTSCHECKJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmtscheckjacobian_ dmtscheckjacobian
#endif
PETSC_EXTERN void dmtscheckjacobian_(TS *a, DM *b, PetscReal *c, Vec *d, Vec *e, PetscReal *f, PetscBool *g, PetscReal *h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(g);
  CHKFORTRANNULLREAL(h);
  *ierr = DMTSCheckJacobian(*a, *b, *c, *d, *e, *f, g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmtscheckfromoptions_ DMTSCHECKFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmtscheckfromoptions_ dmtscheckfromoptions
#endif
PETSC_EXTERN void dmtscheckfromoptions_(TS *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMTSCheckFromOptions(*a, *b);
  if (*ierr) return;
}
