#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabcreate_ DMMOABCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabcreate_ dmmoabcreate
#endif
PETSC_EXTERN void dmmoabcreate_(MPI_Fint *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMMoabCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabcreatemoab_ DMMOABCREATEMOAB
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabcreatemoab_ dmmoabcreatemoab
#endif
PETSC_EXTERN void dmmoabcreatemoab_(MPI_Fint *a, moab::Interface *b, moab::Tag *c, moab::Range *d, DM *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMMoabCreateMoab(MPI_Comm_f2c(*(a)), b, c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetinterface_ DMMOABSETINTERFACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetinterface_ dmmoabsetinterface
#endif
PETSC_EXTERN void dmmoabsetinterface_(DM *a, moab::Interface *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabSetInterface(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetlocalvertices_ DMMOABSETLOCALVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetlocalvertices_ dmmoabsetlocalvertices
#endif
PETSC_EXTERN void dmmoabsetlocalvertices_(DM *a, moab::Range *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabSetLocalVertices(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetallvertices_ DMMOABGETALLVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetallvertices_ dmmoabgetallvertices
#endif
PETSC_EXTERN void dmmoabgetallvertices_(DM *a, moab::Range *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabGetAllVertices(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetlocalelements_ DMMOABSETLOCALELEMENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetlocalelements_ dmmoabsetlocalelements
#endif
PETSC_EXTERN void dmmoabsetlocalelements_(DM *a, moab::Range *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabSetLocalElements(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetlocaltoglobaltag_ DMMOABSETLOCALTOGLOBALTAG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetlocaltoglobaltag_ dmmoabsetlocaltoglobaltag
#endif
PETSC_EXTERN void dmmoabsetlocaltoglobaltag_(DM *a, moab::Tag *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabSetLocalToGlobalTag(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetlocaltoglobaltag_ DMMOABGETLOCALTOGLOBALTAG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetlocaltoglobaltag_ dmmoabgetlocaltoglobaltag
#endif
PETSC_EXTERN void dmmoabgetlocaltoglobaltag_(DM *a, moab::Tag *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabGetLocalToGlobalTag(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetblocksize_ DMMOABSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetblocksize_ dmmoabsetblocksize
#endif
PETSC_EXTERN void dmmoabsetblocksize_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabSetBlockSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetblocksize_ DMMOABGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetblocksize_ dmmoabgetblocksize
#endif
PETSC_EXTERN void dmmoabgetblocksize_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMMoabGetBlockSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetsize_ DMMOABGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetsize_ dmmoabgetsize
#endif
PETSC_EXTERN void dmmoabgetsize_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMMoabGetSize(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetlocalsize_ DMMOABGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetlocalsize_ dmmoabgetlocalsize
#endif
PETSC_EXTERN void dmmoabgetlocalsize_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMMoabGetLocalSize(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetoffset_ DMMOABGETOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetoffset_ dmmoabgetoffset
#endif
PETSC_EXTERN void dmmoabgetoffset_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMMoabGetOffset(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetdimension_ DMMOABGETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetdimension_ dmmoabgetdimension
#endif
PETSC_EXTERN void dmmoabgetdimension_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMMoabGetDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgethierarchylevel_ DMMOABGETHIERARCHYLEVEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgethierarchylevel_ dmmoabgethierarchylevel
#endif
PETSC_EXTERN void dmmoabgethierarchylevel_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMMoabGetHierarchyLevel(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetmaterialblock_ DMMOABGETMATERIALBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetmaterialblock_ dmmoabgetmaterialblock
#endif
PETSC_EXTERN void dmmoabgetmaterialblock_(DM *a, const moab::EntityHandle *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMMoabGetMaterialBlock(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetvertexcoordinates_ DMMOABGETVERTEXCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetvertexcoordinates_ dmmoabgetvertexcoordinates
#endif
PETSC_EXTERN void dmmoabgetvertexcoordinates_(DM *a, PetscInt *b, const moab::EntityHandle *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = DMMoabGetVertexCoordinates(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabisentityonboundary_ DMMOABISENTITYONBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabisentityonboundary_ dmmoabisentityonboundary
#endif
PETSC_EXTERN void dmmoabisentityonboundary_(DM *a, const moab::EntityHandle *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMMoabIsEntityOnBoundary(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabcheckboundaryvertices_ DMMOABCHECKBOUNDARYVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabcheckboundaryvertices_ dmmoabcheckboundaryvertices
#endif
PETSC_EXTERN void dmmoabcheckboundaryvertices_(DM *a, PetscInt *b, const moab::EntityHandle *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = DMMoabCheckBoundaryVertices(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabcreatevertices_ DMMOABCREATEVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabcreatevertices_ dmmoabcreatevertices
#endif
PETSC_EXTERN void dmmoabcreatevertices_(DM *a, const PetscReal *b, PetscInt *c, moab::Range *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMMoabCreateVertices(*a, b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabcreateelement_ DMMOABCREATEELEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabcreateelement_ dmmoabcreateelement
#endif
PETSC_EXTERN void dmmoabcreateelement_(DM *a, const moab::EntityType *b, const moab::EntityHandle *c, PetscInt *d, moab::EntityHandle *e, PetscErrorCode *ierr)
{
  *ierr = DMMoabCreateElement(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabcreatesubmesh_ DMMOABCREATESUBMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabcreatesubmesh_ dmmoabcreatesubmesh
#endif
PETSC_EXTERN void dmmoabcreatesubmesh_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMMoabCreateSubmesh(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
