#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcissetusestiffnessscaling_ PCISSETUSESTIFFNESSSCALING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcissetusestiffnessscaling_ pcissetusestiffnessscaling
#endif
PETSC_EXTERN void pcissetusestiffnessscaling_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCISSetUseStiffnessScaling(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcissetsubdomaindiagonalscaling_ PCISSETSUBDOMAINDIAGONALSCALING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcissetsubdomaindiagonalscaling_ pcissetsubdomaindiagonalscaling
#endif
PETSC_EXTERN void pcissetsubdomaindiagonalscaling_(PC *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = PCISSetSubdomainDiagonalScaling(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcissetsubdomainscalingfactor_ PCISSETSUBDOMAINSCALINGFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcissetsubdomainscalingfactor_ pcissetsubdomainscalingfactor
#endif
PETSC_EXTERN void pcissetsubdomainscalingfactor_(PC *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = PCISSetSubdomainScalingFactor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcissetup_ PCISSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcissetup_ pcissetup
#endif
PETSC_EXTERN void pcissetup_(PC *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PCISSetUp(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcisreset_ PCISRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcisreset_ pcisreset
#endif
PETSC_EXTERN void pcisreset_(PC *a, PetscErrorCode *ierr)
{
  *ierr = PCISReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcisinitialize_ PCISINITIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcisinitialize_ pcisinitialize
#endif
PETSC_EXTERN void pcisinitialize_(PC *a, PetscErrorCode *ierr)
{
  *ierr = PCISInitialize(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcisapplyschur_ PCISAPPLYSCHUR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcisapplyschur_ pcisapplyschur
#endif
PETSC_EXTERN void pcisapplyschur_(PC *a, Vec *b, Vec *c, Vec *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  *ierr = PCISApplySchur(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcisscatterarrayntovecb_ PCISSCATTERARRAYNTOVECB
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcisscatterarrayntovecb_ pcisscatterarrayntovecb
#endif
PETSC_EXTERN void pcisscatterarrayntovecb_(PC *a, PetscScalar *b, Vec *c, InsertMode *d, ScatterMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = PCISScatterArrayNToVecB(*a, b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcisapplyinvschur_ PCISAPPLYINVSCHUR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcisapplyinvschur_ pcisapplyinvschur
#endif
PETSC_EXTERN void pcisapplyinvschur_(PC *a, Vec *b, Vec *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = PCISApplyInvSchur(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
