#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmallocvalidate_ PETSCMALLOCVALIDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmallocvalidate_ petscmallocvalidate
#endif
PETSC_EXTERN void petscmallocvalidate_(int *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscMallocValidate(*a, c_b, c_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmemoryview_ PETSCMEMORYVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmemoryview_ petscmemoryview
#endif
PETSC_EXTERN void petscmemoryview_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscMemoryView(v_a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmallocgetcurrentusage_ PETSCMALLOCGETCURRENTUSAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmallocgetcurrentusage_ petscmallocgetcurrentusage
#endif
PETSC_EXTERN void petscmallocgetcurrentusage_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscMallocGetCurrentUsage(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmallocgetmaximumusage_ PETSCMALLOCGETMAXIMUMUSAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmallocgetmaximumusage_ petscmallocgetmaximumusage
#endif
PETSC_EXTERN void petscmallocgetmaximumusage_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscMallocGetMaximumUsage(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmallocpushmaximumusage_ PETSCMALLOCPUSHMAXIMUMUSAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmallocpushmaximumusage_ petscmallocpushmaximumusage
#endif
PETSC_EXTERN void petscmallocpushmaximumusage_(int *a, PetscErrorCode *ierr)
{
  *ierr = PetscMallocPushMaximumUsage(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmallocpopmaximumusage_ PETSCMALLOCPOPMAXIMUMUSAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmallocpopmaximumusage_ petscmallocpopmaximumusage
#endif
PETSC_EXTERN void petscmallocpopmaximumusage_(int *a, PetscLogDouble *b, PetscErrorCode *ierr)
{
  *ierr = PetscMallocPopMaximumUsage(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmallocviewset_ PETSCMALLOCVIEWSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmallocviewset_ petscmallocviewset
#endif
PETSC_EXTERN void petscmallocviewset_(PetscLogDouble *a, PetscErrorCode *ierr)
{
  *ierr = PetscMallocViewSet(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmallocviewget_ PETSCMALLOCVIEWGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmallocviewget_ petscmallocviewget
#endif
PETSC_EXTERN void petscmallocviewget_(PetscBool *a, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(a);
  *ierr = PetscMallocViewGet(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmalloctraceset_ PETSCMALLOCTRACESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmalloctraceset_ petscmalloctraceset
#endif
PETSC_EXTERN void petscmalloctraceset_(PetscViewer *a, PetscBool *b, PetscLogDouble *c, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscMallocTraceSet(v_a, *b ? PETSC_TRUE : PETSC_FALSE, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmalloctraceget_ PETSCMALLOCTRACEGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmalloctraceget_ petscmalloctraceget
#endif
PETSC_EXTERN void petscmalloctraceget_(PetscBool *a, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(a);
  *ierr = PetscMallocTraceGet(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmallocsetdebug_ PETSCMALLOCSETDEBUG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmallocsetdebug_ petscmallocsetdebug
#endif
PETSC_EXTERN void petscmallocsetdebug_(PetscBool *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscMallocSetDebug(*a ? PETSC_TRUE : PETSC_FALSE, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmallocgetdebug_ PETSCMALLOCGETDEBUG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmallocgetdebug_ petscmallocgetdebug
#endif
PETSC_EXTERN void petscmallocgetdebug_(PetscBool *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(a);
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscMallocGetDebug(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmalloclogrequestedsizeset_ PETSCMALLOCLOGREQUESTEDSIZESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmalloclogrequestedsizeset_ petscmalloclogrequestedsizeset
#endif
PETSC_EXTERN void petscmalloclogrequestedsizeset_(PetscBool *a, PetscErrorCode *ierr)
{
  *ierr = PetscMallocLogRequestedSizeSet(*a ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmalloclogrequestedsizeget_ PETSCMALLOCLOGREQUESTEDSIZEGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmalloclogrequestedsizeget_ petscmalloclogrequestedsizeget
#endif
PETSC_EXTERN void petscmalloclogrequestedsizeget_(PetscBool *a, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(a);
  *ierr = PetscMallocLogRequestedSizeGet(a);
  if (*ierr) return;
}
