#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfunctionlistdestroy_ PETSCFUNCTIONLISTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfunctionlistdestroy_ petscfunctionlistdestroy
#endif
PETSC_EXTERN void petscfunctionlistdestroy_(PetscFunctionList *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscFunctionListDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfunctionlistclear_ PETSCFUNCTIONLISTCLEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfunctionlistclear_ petscfunctionlistclear
#endif
PETSC_EXTERN void petscfunctionlistclear_(PetscFunctionList *a, PetscErrorCode *ierr)
{
  *ierr = PetscFunctionListClear(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfunctionlistprintall_ PETSCFUNCTIONLISTPRINTALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfunctionlistprintall_ petscfunctionlistprintall
#endif
PETSC_EXTERN void petscfunctionlistprintall_(PetscErrorCode *ierr)
{
  *ierr = PetscFunctionListPrintAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfunctionlistprintnonempty_ PETSCFUNCTIONLISTPRINTNONEMPTY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfunctionlistprintnonempty_ petscfunctionlistprintnonempty
#endif
PETSC_EXTERN void petscfunctionlistprintnonempty_(PetscFunctionList *a, PetscErrorCode *ierr)
{
  *ierr = PetscFunctionListPrintNonEmpty(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfunctionlistview_ PETSCFUNCTIONLISTVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfunctionlistview_ petscfunctionlistview
#endif
PETSC_EXTERN void petscfunctionlistview_(PetscFunctionList *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscFunctionListView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfunctionlistduplicate_ PETSCFUNCTIONLISTDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfunctionlistduplicate_ petscfunctionlistduplicate
#endif
PETSC_EXTERN void petscfunctionlistduplicate_(PetscFunctionList *a, PetscFunctionList *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFunctionListDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
