#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetordering_ MATGETORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetordering_ matgetordering
#endif
PETSC_EXTERN void matgetordering_(Mat *a, char * b, IS *c, IS *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatGetOrdering(*a, c_b, c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetorderinglist_ MATGETORDERINGLIST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetorderinglist_ matgetorderinglist
#endif
PETSC_EXTERN void matgetorderinglist_(PetscFunctionList *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = MatGetOrderingList(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
