#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositegetnumberdm_ DMCOMPOSITEGETNUMBERDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositegetnumberdm_ dmcompositegetnumberdm
#endif
PETSC_EXTERN void dmcompositegetnumberdm_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMCompositeGetNumberDM(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositegetaccessarray_ DMCOMPOSITEGETACCESSARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositegetaccessarray_ dmcompositegetaccessarray
#endif
PETSC_EXTERN void dmcompositegetaccessarray_(DM *a, Vec *b, PetscInt *c, const PetscInt d[], Vec e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMCompositeGetAccessArray(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositegetlocalaccessarray_ DMCOMPOSITEGETLOCALACCESSARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositegetlocalaccessarray_ dmcompositegetlocalaccessarray
#endif
PETSC_EXTERN void dmcompositegetlocalaccessarray_(DM *a, Vec *b, PetscInt *c, const PetscInt d[], Vec e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMCompositeGetLocalAccessArray(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositerestoreaccessarray_ DMCOMPOSITERESTOREACCESSARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositerestoreaccessarray_ dmcompositerestoreaccessarray
#endif
PETSC_EXTERN void dmcompositerestoreaccessarray_(DM *a, Vec *b, PetscInt *c, const PetscInt d[], Vec e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMCompositeRestoreAccessArray(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositerestorelocalaccessarray_ DMCOMPOSITERESTORELOCALACCESSARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositerestorelocalaccessarray_ dmcompositerestorelocalaccessarray
#endif
PETSC_EXTERN void dmcompositerestorelocalaccessarray_(DM *a, Vec *b, PetscInt *c, const PetscInt d[], Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMCompositeRestoreLocalAccessArray(*a, *b, *c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositescatterarray_ DMCOMPOSITESCATTERARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositescatterarray_ dmcompositescatterarray
#endif
PETSC_EXTERN void dmcompositescatterarray_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMCompositeScatterArray(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositegatherarray_ DMCOMPOSITEGATHERARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositegatherarray_ dmcompositegatherarray
#endif
PETSC_EXTERN void dmcompositegatherarray_(DM *a, InsertMode *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMCompositeGatherArray(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositeadddm_ DMCOMPOSITEADDDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositeadddm_ dmcompositeadddm
#endif
PETSC_EXTERN void dmcompositeadddm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMCompositeAddDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositegetentriesarray_ DMCOMPOSITEGETENTRIESARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositegetentriesarray_ dmcompositegetentriesarray
#endif
PETSC_EXTERN void dmcompositegetentriesarray_(DM *a, DM b[], PetscErrorCode *ierr)
{
  *ierr = DMCompositeGetEntriesArray(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmcomposite.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcompositecreate_ DMCOMPOSITECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcompositecreate_ dmcompositecreate
#endif
PETSC_EXTERN void dmcompositecreate_(MPI_Fint *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMCompositeCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
