#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscformatconvertgetsize_ PETSCFORMATCONVERTGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscformatconvertgetsize_ petscformatconvertgetsize
#endif
PETSC_EXTERN void petscformatconvertgetsize_(char a[], size_t *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscFormatConvertGetSize(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscformatconvert_ PETSCFORMATCONVERT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscformatconvert_ petscformatconvert
#endif
PETSC_EXTERN void petscformatconvert_(char a[], char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscFormatConvert(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscformatrealarray_ PETSCFORMATREALARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscformatrealarray_ petscformatrealarray
#endif
PETSC_EXTERN void petscformatrealarray_(char a[], char b[], PetscInt *c, const PetscReal d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLREAL(d);
  *ierr = PetscFormatRealArray(a, l_a, c_b, *c, d);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
  FREECHAR(b, c_b);
}
