#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectoryset_ TSTRAJECTORYSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectoryset_ tstrajectoryset
#endif
PETSC_EXTERN void tstrajectoryset_(TSTrajectory *a, TS *b, PetscInt *c, PetscReal *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = TSTrajectorySet(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorygetnumsteps_ TSTRAJECTORYGETNUMSTEPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorygetnumsteps_ tstrajectorygetnumsteps
#endif
PETSC_EXTERN void tstrajectorygetnumsteps_(TSTrajectory *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSTrajectoryGetNumSteps(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectoryget_ TSTRAJECTORYGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectoryget_ tstrajectoryget
#endif
PETSC_EXTERN void tstrajectoryget_(TSTrajectory *a, TS *b, PetscInt *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = TSTrajectoryGet(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorygetvecs_ TSTRAJECTORYGETVECS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorygetvecs_ tstrajectorygetvecs
#endif
PETSC_EXTERN void tstrajectorygetvecs_(TSTrajectory *a, TS *b, PetscInt *c, PetscReal *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = TSTrajectoryGetVecs(*a, *b, *c, d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectoryviewfromoptions_ TSTRAJECTORYVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectoryviewfromoptions_ tstrajectoryviewfromoptions
#endif
PETSC_EXTERN void tstrajectoryviewfromoptions_(TSTrajectory *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = TSTrajectoryViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectoryview_ TSTRAJECTORYVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectoryview_ tstrajectoryview
#endif
PETSC_EXTERN void tstrajectoryview_(TSTrajectory *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = TSTrajectoryView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorycreate_ TSTRAJECTORYCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorycreate_ tstrajectorycreate
#endif
PETSC_EXTERN void tstrajectorycreate_(MPI_Fint *a, TSTrajectory *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSTrajectoryCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorysettype_ TSTRAJECTORYSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorysettype_ tstrajectorysettype
#endif
PETSC_EXTERN void tstrajectorysettype_(TSTrajectory *a, TS *b, char * c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = TSTrajectorySetType(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorygettype_ TSTRAJECTORYGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorygettype_ tstrajectorygettype
#endif
PETSC_EXTERN void tstrajectorygettype_(TSTrajectory *a, TS *b, char * c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = TSTrajectoryGetType(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectoryregisterall_ TSTRAJECTORYREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectoryregisterall_ tstrajectoryregisterall
#endif
PETSC_EXTERN void tstrajectoryregisterall_(PetscErrorCode *ierr)
{
  *ierr = TSTrajectoryRegisterAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectoryreset_ TSTRAJECTORYRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectoryreset_ tstrajectoryreset
#endif
PETSC_EXTERN void tstrajectoryreset_(TSTrajectory *a, PetscErrorCode *ierr)
{
  *ierr = TSTrajectoryReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorydestroy_ TSTRAJECTORYDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorydestroy_ tstrajectorydestroy
#endif
PETSC_EXTERN void tstrajectorydestroy_(TSTrajectory *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSTrajectoryDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorysetusehistory_ TSTRAJECTORYSETUSEHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorysetusehistory_ tstrajectorysetusehistory
#endif
PETSC_EXTERN void tstrajectorysetusehistory_(TSTrajectory *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSTrajectorySetUseHistory(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorysetmonitor_ TSTRAJECTORYSETMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorysetmonitor_ tstrajectorysetmonitor
#endif
PETSC_EXTERN void tstrajectorysetmonitor_(TSTrajectory *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSTrajectorySetMonitor(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorysetkeepfiles_ TSTRAJECTORYSETKEEPFILES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorysetkeepfiles_ tstrajectorysetkeepfiles
#endif
PETSC_EXTERN void tstrajectorysetkeepfiles_(TSTrajectory *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSTrajectorySetKeepFiles(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorysetdirname_ TSTRAJECTORYSETDIRNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorysetdirname_ tstrajectorysetdirname
#endif
PETSC_EXTERN void tstrajectorysetdirname_(TSTrajectory *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSTrajectorySetDirname(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorysetfiletemplate_ TSTRAJECTORYSETFILETEMPLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorysetfiletemplate_ tstrajectorysetfiletemplate
#endif
PETSC_EXTERN void tstrajectorysetfiletemplate_(TSTrajectory *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSTrajectorySetFiletemplate(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorysetfromoptions_ TSTRAJECTORYSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorysetfromoptions_ tstrajectorysetfromoptions
#endif
PETSC_EXTERN void tstrajectorysetfromoptions_(TSTrajectory *a, TS *b, PetscErrorCode *ierr)
{
  *ierr = TSTrajectorySetFromOptions(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorysetup_ TSTRAJECTORYSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorysetup_ tstrajectorysetup
#endif
PETSC_EXTERN void tstrajectorysetup_(TSTrajectory *a, TS *b, PetscErrorCode *ierr)
{
  *ierr = TSTrajectorySetUp(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorysetsolutiononly_ TSTRAJECTORYSETSOLUTIONONLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorysetsolutiononly_ tstrajectorysetsolutiononly
#endif
PETSC_EXTERN void tstrajectorysetsolutiononly_(TSTrajectory *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSTrajectorySetSolutionOnly(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorygetsolutiononly_ TSTRAJECTORYGETSOLUTIONONLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorygetsolutiononly_ tstrajectorygetsolutiononly
#endif
PETSC_EXTERN void tstrajectorygetsolutiononly_(TSTrajectory *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSTrajectoryGetSolutionOnly(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectorygetupdatedhistoryvecs_ TSTRAJECTORYGETUPDATEDHISTORYVECS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectorygetupdatedhistoryvecs_ tstrajectorygetupdatedhistoryvecs
#endif
PETSC_EXTERN void tstrajectorygetupdatedhistoryvecs_(TSTrajectory *a, TS *b, PetscReal *c, Vec *d, Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = TSTrajectoryGetUpdatedHistoryVecs(*a, *b, *c, d, e);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tstrajectoryrestoreupdatedhistoryvecs_ TSTRAJECTORYRESTOREUPDATEDHISTORYVECS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tstrajectoryrestoreupdatedhistoryvecs_ tstrajectoryrestoreupdatedhistoryvecs
#endif
PETSC_EXTERN void tstrajectoryrestoreupdatedhistoryvecs_(TSTrajectory *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSTrajectoryRestoreUpdatedHistoryVecs(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
