#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscwebclient.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petschttpsrequest_ PETSCHTTPSREQUEST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petschttpsrequest_ petschttpsrequest
#endif
PETSC_EXTERN void petschttpsrequest_(char a[], char b[], char c[], char d[], char e[], SSL *f, char g[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e, PETSC_FORTRAN_CHARLEN_T l_g)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscHTTPSRequest(c_a, c_b, c_c, c_d, c_e, f, g, l_g);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
  FIXRETURNCHAR(PETSC_TRUE, g, l_g);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscwebclient.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petschttprequest_ PETSCHTTPREQUEST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petschttprequest_ petschttprequest
#endif
PETSC_EXTERN void petschttprequest_(char a[], char b[], char c[], char d[], char e[], int *f, char g[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e, PETSC_FORTRAN_CHARLEN_T l_g)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscHTTPRequest(c_a, c_b, c_c, c_d, c_e, *f, g, l_g);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
  FIXRETURNCHAR(PETSC_TRUE, g, l_g);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpulljsonvalue_ PETSCPULLJSONVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpulljsonvalue_ petscpulljsonvalue
#endif
PETSC_EXTERN void petscpulljsonvalue_(char a[], char b[], char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscPullJSONValue(c_a, c_b, c, l_c, d);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FREECHAR(b, c_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpushjsonvalue_ PETSCPUSHJSONVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpushjsonvalue_ petscpushjsonvalue
#endif
PETSC_EXTERN void petscpushjsonvalue_(char a[], char b[], char c[], size_t *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscPushJSONValue(a, c_b, c_c, *d);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
