#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmredundant.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmredundantsetsize_ DMREDUNDANTSETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmredundantsetsize_ dmredundantsetsize
#endif
PETSC_EXTERN void dmredundantsetsize_(DM *a, PetscMPIInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMRedundantSetSize(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmredundant.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmredundantgetsize_ DMREDUNDANTGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmredundantgetsize_ dmredundantgetsize
#endif
PETSC_EXTERN void dmredundantgetsize_(DM *a, PetscMPIInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMRedundantGetSize(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmredundant.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmredundantcreate_ DMREDUNDANTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmredundantcreate_ dmredundantcreate
#endif
PETSC_EXTERN void dmredundantcreate_(MPI_Fint *a, PetscMPIInt *b, PetscInt *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(d);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMRedundantCreate(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
