#=

 @file pastix_enums.jl

 PaStiX julia wrapper to define enums and datatypes

 @copyright 2020-2023 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
                      Univ. Bordeaux. All rights reserved.

 @version 6.3.2
 @author Mathieu Faverge
 @author Selmane Lebdaoui
 @author Tony Delarue
 @author Alycia Lisito
 @author Tom Moenne-Loccoz
 @date 2023-11-10

 This file has been automatically generated with gen_wrappers.py

 @ingroup wrap_julia

=#

Pastix_int_t = Int32
pastix_mpi_enabled = false
const Pastix_data_t = Cvoid
const Pastix_rhs_t = Ptr{Cvoid}
const Pastix_graph_t = Ptr{Cvoid}

using spm
if pastix_mpi_enabled
    using MPI
end

function __get_mpi_type__()
    if !pastix_mpi_enabled
        return Cint
    elseif sizeof(MPI.MPI_Comm) == sizeof(Clong)
        return Clong
    elseif sizeof(MPI.MPI_Comm) == sizeof(Cint)
        return Cint
    end
    return Cvoid
end

@cenum Pastix_iparm_t {
    iparm_verbose                        = 1,
    iparm_io_strategy                    = 2,
    iparm_nnzeros                        = 3,
    iparm_nnzeros_block_local            = 4,
    iparm_allocated_terms                = 5,
    iparm_produce_stats                  = 6,
    iparm_trace                          = 7,
    iparm_mc64                           = 8,
    iparm_ordering                       = 9,
    iparm_ordering_default               = 10,
    iparm_scotch_mt                      = 11,
    iparm_scotch_switch_level            = 12,
    iparm_scotch_cmin                    = 13,
    iparm_scotch_cmax                    = 14,
    iparm_scotch_frat                    = 15,
    iparm_metis_ctype                    = 16,
    iparm_metis_rtype                    = 17,
    iparm_metis_no2hop                   = 18,
    iparm_metis_nseps                    = 19,
    iparm_metis_niter                    = 20,
    iparm_metis_ufactor                  = 21,
    iparm_metis_compress                 = 22,
    iparm_metis_ccorder                  = 23,
    iparm_metis_pfactor                  = 24,
    iparm_metis_seed                     = 25,
    iparm_metis_dbglvl                   = 26,
    iparm_amalgamation_lvlblas           = 27,
    iparm_amalgamation_lvlcblk           = 28,
    iparm_reordering_split               = 29,
    iparm_reordering_stop                = 30,
    iparm_splitting_strategy             = 31,
    iparm_splitting_levels_projections   = 32,
    iparm_splitting_levels_kway          = 33,
    iparm_splitting_projections_depth    = 34,
    iparm_splitting_projections_distance = 35,
    iparm_splitting_projections_width    = 36,
    iparm_min_blocksize                  = 37,
    iparm_max_blocksize                  = 38,
    iparm_tasks2d_level                  = 39,
    iparm_tasks2d_width                  = 40,
    iparm_allcand                        = 41,
    iparm_incomplete                     = 42,
    iparm_level_of_fill                  = 43,
    iparm_factorization                  = 44,
    iparm_facto_look_side                = 45,
    iparm_static_pivoting                = 46,
    iparm_free_cscuser                   = 47,
    iparm_schur_fact_mode                = 48,
    iparm_transpose_solve                = 49,
    iparm_schur_solv_mode                = 50,
    iparm_applyperm_ws                   = 51,
    iparm_refinement                     = 52,
    iparm_nbiter                         = 53,
    iparm_itermax                        = 54,
    iparm_gmres_im                       = 55,
    iparm_scheduler                      = 56,
    iparm_thread_nbr                     = 57,
    iparm_socket_nbr                     = 58,
    iparm_autosplit_comm                 = 59,
    iparm_gpu_nbr                        = 60,
    iparm_gpu_memory_percentage          = 61,
    iparm_gpu_memory_block_size          = 62,
    iparm_global_allocation              = 63,
    iparm_compress_min_width             = 64,
    iparm_compress_min_height            = 65,
    iparm_compress_when                  = 66,
    iparm_compress_method                = 67,
    iparm_compress_ortho                 = 68,
    iparm_compress_reltol                = 69,
    iparm_compress_preselect             = 70,
    iparm_compress_iluk                  = 71,
    iparm_mixed                          = 72,
    iparm_ftz                            = 73,
    iparm_mpi_thread_level               = 74,
    iparm_modify_parameter               = 75,
    iparm_start_task                     = 76,
    iparm_end_task                       = 77,
    iparm_float                          = 78,
    iparm_mtx_type                       = 79,
    iparm_dof_nbr                        = 80,
    iparm_size                           = 80,
}

@cenum Pastix_dparm_t {
    dparm_fill_in            = 1,
    dparm_epsilon_refinement = 2,
    dparm_relative_error     = 3,
    dparm_epsilon_magn_ctrl  = 4,
    dparm_order_time         = 5,
    dparm_symbfact_time      = 6,
    dparm_reorder_time       = 7,
    dparm_blend_time         = 8,
    dparm_analyze_time       = 9,
    dparm_pred_fact_time     = 10,
    dparm_fact_time          = 11,
    dparm_fact_flops         = 12,
    dparm_fact_thflops       = 13,
    dparm_fact_rlflops       = 14,
    dparm_fact_energy        = 15,
    dparm_mem_fr             = 16,
    dparm_mem_lr             = 17,
    dparm_solv_time          = 18,
    dparm_solv_flops         = 19,
    dparm_solv_thflops       = 20,
    dparm_solv_rlflops       = 21,
    dparm_solv_energy        = 22,
    dparm_refine_time        = 23,
    dparm_a_norm             = 24,
    dparm_compress_tolerance = 25,
    dparm_compress_min_ratio = 26,
    dparm_size               = 26,
}

@cenum Pastix_task_t {
    taskinit     = 0,
    taskordering = 1,
    tasksymbfact = 2,
    taskanalyze  = 3,
    tasknumfact  = 4,
    tasksolve    = 5,
    taskrefine   = 6,
    taskclean    = 7,
}

@cenum Pastix_trace_t {
    tracenot          = 0,
    tracenumfact      = 16,
    tracesolve        = 32,
    tracefactandsolve = 48,
}

@cenum Pastix_verbose_t {
    verbosenot = 0,
    verboseno  = 1,
    verboseyes = 2,
}

@cenum Pastix_io_t {
    iono        = 0,
    ioload      = 1,
    iosave      = 2,
    ioloadgraph = 4,
    iosavegraph = 8,
    ioloadcsc   = 16,
    iosavecsc   = 32,
}

@cenum Pastix_fact_mode_t {
    factmodelocal = 0,
    factmodeschur = 1,
    factmodeboth  = 2,
}

@cenum Pastix_solv_mode_t {
    solvmodelocal     = 0,
    solvmodeinterface = 1,
    solvmodeschur     = 2,
}

@cenum Pastix_refine_t {
    refinegmres    = 0,
    refinecg       = 1,
    refinesr       = 2,
    refinebicgstab = 3,
}

@cenum Pastix_factotype_t {
    factpotrf = 0,
    factsytrf = 1,
    factgetrf = 2,
    factpxtrf = 3,
    facthetrf = 4,
    factllh   = 0,
    factldlt  = 1,
    factlu    = 2,
    factllt   = 3,
    factldlh  = 4,
}

@cenum Pastix_factolookside_t {
    factleftlooking  = 0,
    factrightlooking = 1,
}

@cenum Pastix_scheduler_t {
    schedsequential = 0,
    schedstatic     = 1,
    schedparsec     = 2,
    schedstarpu     = 3,
    scheddynamic    = 4,
}

@cenum Pastix_ordering_t {
    orderscotch   = 0,
    ordermetis    = 1,
    orderpersonal = 2,
    orderptscotch = 3,
    orderparmetis = 4,
}

@cenum Pastix_mpithreadmode_t {
    mpinone             = 0,
    mpithreadsingle     = 1,
    mpithreadfunneled   = 2,
    mpithreadserialized = 3,
    mpithreadmultiple   = 4,
}

@cenum Pastix_error_t {
    success            = 0,
    err_unknown        = 1,
    err_alloc          = 2,
    err_notimplemented = 3,
    err_outofmemory    = 4,
    err_thread         = 5,
    err_internal       = 6,
    err_badparameter   = 7,
    err_file           = 8,
    err_integer_type   = 9,
    err_io             = 10,
    err_mpi            = 11,
}

@cenum Pastix_compress_when_t {
    compressnever      = 0,
    compresswhenbegin  = 1,
    compresswhenend    = 2,
    compresswhenduring = 3,
}

@cenum Pastix_compress_method_t {
    compressmethodsvd   = 0,
    compressmethodpqrcp = 1,
    compressmethodrqrcp = 2,
    compressmethodtqrcp = 3,
    compressmethodrqrrt = 4,
    compressmethodnbr   = 5,
}

@cenum Pastix_compress_ortho_t {
    compressorthocgs       = 0,
    compressorthoqr        = 1,
    compressorthopartialqr = 2,
}

@cenum Pastix_split_t {
    splitnot             = 0,
    splitkway            = 1,
    splitkwayprojections = 2,
}

@cenum Pastix_layout_t {
    rowmajor = 101,
    colmajor = 102,
}

@cenum Pastix_trans_t {
    notrans   = 111,
    trans     = 112,
    conjtrans = 113,
}

@cenum Pastix_uplo_t {
    upper      = 121,
    lower      = 122,
    upperlower = 123,
}

@cenum Pastix_coefside_t {
    lcoef  = 0,
    ucoef  = 1,
    lucoef = 2,
}

@cenum Pastix_diag_t {
    nonunit = 131,
    unit    = 132,
}

@cenum Pastix_side_t {
    left  = 141,
    right = 142,
}

@cenum Pastix_normtype_t {
    onenorm       = 171,
    frobeniusnorm = 174,
    infnorm       = 175,
    maxnorm       = 177,
}

@cenum Pastix_dir_t {
    dirforward  = 391,
    dirbackward = 392,
}

@cenum Pastix_mtxtype_t {
    general   = notrans,
    symmetric = trans,
    hermitian = conjtrans,
}

@cstruct Pastix_order_t {
    baseval::Pastix_int_t
    vertnbr::Pastix_int_t
    cblknbr::Pastix_int_t
    permtab::Ptr{Pastix_int_t}
    peritab::Ptr{Pastix_int_t}
    rangtab::Ptr{Pastix_int_t}
    treetab::Ptr{Pastix_int_t}
    selevtx::Ptr{Int8}
    sndenbr::Pastix_int_t
    sndetab::Ptr{Pastix_int_t}
    peritab_exp::Ptr{Pastix_int_t}
}

