#version 110

uniform mat4 worldViewProj;
uniform mat4 worldMat;
uniform vec4 texelOffsets;
uniform vec4 inColor;

attribute vec4 position;
varying vec4 oColor;
varying vec2 oDepth;
varying vec4 oWp;

void main()
{
  vec4 pos = worldViewProj * position;  
  pos.xy += texelOffsets.zw * pos.w;  
  gl_Position = pos;
  oWp = worldMat * position;
  
  oColor = inColor;
  oDepth = pos.zw; 
}
