# This file allows users to call find_package(MLIR) and pick up our targets.

# Compute the installation prefix from this LLVMConfig.cmake file location.
get_filename_component(MLIR_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)

set(LLVM_VERSION 18.1.6)
find_package(LLVM ${LLVM_VERSION} EXACT REQUIRED CONFIG
             HINTS "${MLIR_INSTALL_PREFIX}/lib/cmake/llvm")

set(MLIR_EXPORTED_TARGETS "mlir-pdll;mlir-tblgen;MLIRPresburger;MLIRAnalysis;MLIRAsmParser;MLIRBytecodeReader;MLIRBytecodeWriter;MLIRBytecodeOpInterface;MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithAttrToLLVMConversion;MLIRArithToAMDGPU;MLIRArithToArmSME;MLIRArithToLLVM;MLIRArithToSPIRV;MLIRArmNeon2dToIntr;MLIRArmSMEToSCF;MLIRArmSMEToLLVM;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexToLibm;MLIRComplexToLLVM;MLIRComplexToSPIRV;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSCF;MLIRControlFlowToSPIRV;MLIRConvertToLLVMInterface;MLIRConvertToLLVMPass;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRIndexToLLVM;MLIRIndexToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToFuncs;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToSPIRV;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRNVGPUToNVVM;MLIRNVVMToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToEmitC;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToMLProgram;MLIRTosaToSCF;MLIRTosaToTensor;MLIRUBToLLVM;MLIRUBToSPIRV;MLIRVectorToArmSME;MLIRVectorToGPU;MLIRVectorToLLVM;MLIRVectorToLLVMPass;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRObservers;MLIRDebug;MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineTransformOps;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRAMDGPUTransforms;MLIRAMDGPUUtils;MLIRAMXDialect;MLIRAMXTransforms;MLIRArithDialect;MLIRArithValueBoundsOpInterfaceImpl;MLIRArithTransforms;MLIRArithUtils;MLIRArmNeonDialect;MLIRArmSMEDialect;MLIRArmSMETransforms;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRBufferizationDialect;MLIRBufferizationPipelines;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRControlFlowTransforms;MLIRDLTIDialect;MLIREmitCDialect;MLIREmitCTransforms;MLIRFuncInlinerExtension;MLIRFuncAllExtensions;MLIRFuncDialect;MLIRFuncTransforms;MLIRFuncTransformOps;MLIRGPUDialect;MLIRGPUTransforms;MLIRGPUTransformOps;MLIRGPUPipelines;MLIRIndexDialect;MLIRIRDL;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransformOps;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRShardingInterface;MLIRMeshDialect;MLIRMeshTransforms;MLIRMLProgramDialect;MLIRMLProgramTransforms;MLIRNVGPUDialect;MLIRNVGPUUtils;MLIRNVGPUTransformOps;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenACCMPCommon;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRQuantDialect;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSparseTensorEnums;MLIRSparseTensorDialect;MLIRSparseTensorPipelines;MLIRSparseTensorTransformOps;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorTransformOps;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaShardingInterfaceImpl;MLIRTosaTransforms;MLIRTransformDebugExtension;MLIRTransformDialect;MLIRTransformLoopExtension;MLIRTransformPDLExtension;MLIRTransformDialectTransforms;MLIRTransformDialectUtils;MLIRUBDialect;MLIRDialectUtils;MLIRVectorDialect;MLIRMaskableOpInterface;MLIRMaskingOpInterface;MLIRVectorTransforms;MLIRVectorTransformOps;MLIRVectorUtils;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRDialect;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRDestinationStyleOpInterface;MLIRFunctionInterfaces;MLIRInferIntRangeInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRMemorySlotInterfaces;MLIRParallelCombiningOpInterface;MLIRRuntimeVerifiableOpInterface;MLIRShapedOpInterfaces;MLIRSideEffectInterfaces;MLIRSubsetOpInterface;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRValueBoundsOpInterface;MLIRInferIntRangeCommon;MLIRParser;MLIRPass;MLIRQuery;MLIRQueryMatcher;MLIRReduce;MLIRRewrite;MLIRRewritePDL;MLIRSupport;MLIRTableGen;MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRSPIRVTarget;MLIRArmNeonToLLVMIRTranslation;MLIRArmSMEToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRBuiltinToLLVMIRTranslation;MLIRGPUToLLVMIRTranslation;MLIRLLVMIRToLLVMTranslation;MLIRLLVMToLLVMIRTranslation;MLIRLLVMIRToNVVMTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRSPIRVToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRFromLLVMIRTranslationRegistration;MLIRTargetLLVM;MLIRNVVMTarget;MLIRROCDLTarget;MLIRLspServerSupportLib;MLIRLspServerLib;MLIROptLib;MLIRQueryLib;MLIRReduceLib;MLIRTblgenLib;MLIRTranslateLib;MLIRPDLLAST;MLIRPDLLCodeGen;MLIRPDLLODS;MLIRPluginsLib;MLIRTransformUtils;MLIRTransforms;MLIRExecutionEngineUtils;MLIRExecutionEngine;MLIRJitRunner;mlir_float16_utils;MLIRSparseTensorRuntime;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;mlir_arm_sme_abi_stubs;mlir_arm_runner_utils;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAMDGPU;obj.MLIRCAPIAMDGPU;MLIRCAPIArith;obj.MLIRCAPIArith;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIControlFlow;obj.MLIRCAPIControlFlow;MLIRCAPIMath;obj.MLIRCAPIMath;MLIRCAPIMemRef;obj.MLIRCAPIMemRef;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPIMLProgram;obj.MLIRCAPIMLProgram;MLIRCAPINVGPU;obj.MLIRCAPINVGPU;MLIRCAPINVVM;obj.MLIRCAPINVVM;MLIRCAPIROCDL;obj.MLIRCAPIROCDL;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIFunc;obj.MLIRCAPIFunc;MLIRCAPISPIRV;obj.MLIRCAPISPIRV;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPITransformDialect;obj.MLIRCAPITransformDialect;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIOpenMP;obj.MLIRCAPIOpenMP;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIVector;obj.MLIRCAPIVector;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegisterEverything;obj.MLIRCAPIRegisterEverything;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRCAPITarget;obj.MLIRCAPITarget;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;MLIR-C;MLIRMlirOptMain;MLIR;tblgen-to-irdl")
set(MLIR_CMAKE_DIR "${MLIR_INSTALL_PREFIX}/lib/cmake/mlir")
set(MLIR_INCLUDE_DIRS "${MLIR_INSTALL_PREFIX}/include")
set(MLIR_TABLEGEN_EXE "mlir-tblgen")
set(MLIR_PDLL_TABLEGEN_EXE "mlir-pdll")
set(MLIR_INSTALL_AGGREGATE_OBJECTS "1")
set(MLIR_ENABLE_BINDINGS_PYTHON "OFF")
set(MLIR_ENABLE_EXECUTION_ENGINE "1")

# For mlir_tablegen()
set(MLIR_INCLUDE_DIR "C:/M/B/src/build-MINGW64/include")
set(MLIR_MAIN_SRC_DIR "C:/M/B/src/mlir-18.1.6.src")

set_property(GLOBAL PROPERTY MLIR_ALL_LIBS "MLIRPresburger;MLIRAnalysis;MLIRAsmParser;MLIRBytecodeReader;MLIRBytecodeWriter;MLIRBytecodeOpInterface;MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithAttrToLLVMConversion;MLIRArithToAMDGPU;MLIRArithToArmSME;MLIRArithToLLVM;MLIRArithToSPIRV;MLIRArmNeon2dToIntr;MLIRArmSMEToSCF;MLIRArmSMEToLLVM;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexToLibm;MLIRComplexToLLVM;MLIRComplexToSPIRV;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSCF;MLIRControlFlowToSPIRV;MLIRConvertToLLVMInterface;MLIRConvertToLLVMPass;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRIndexToLLVM;MLIRIndexToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToFuncs;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToSPIRV;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRNVGPUToNVVM;MLIRNVVMToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToEmitC;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToMLProgram;MLIRTosaToSCF;MLIRTosaToTensor;MLIRUBToLLVM;MLIRUBToSPIRV;MLIRVectorToArmSME;MLIRVectorToGPU;MLIRVectorToLLVM;MLIRVectorToLLVMPass;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRObservers;MLIRDebug;MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineTransformOps;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRAMDGPUTransforms;MLIRAMDGPUUtils;MLIRAMXDialect;MLIRAMXTransforms;MLIRArithDialect;MLIRArithValueBoundsOpInterfaceImpl;MLIRArithTransforms;MLIRArithUtils;MLIRArmNeonDialect;MLIRArmSMEDialect;MLIRArmSMETransforms;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRBufferizationDialect;MLIRBufferizationPipelines;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRControlFlowTransforms;MLIRDLTIDialect;MLIREmitCDialect;MLIREmitCTransforms;MLIRFuncInlinerExtension;MLIRFuncAllExtensions;MLIRFuncDialect;MLIRFuncTransforms;MLIRFuncTransformOps;MLIRGPUDialect;MLIRGPUTransforms;MLIRGPUTransformOps;MLIRGPUPipelines;MLIRIndexDialect;MLIRIRDL;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransformOps;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRShardingInterface;MLIRMeshDialect;MLIRMeshTransforms;MLIRMLProgramDialect;MLIRMLProgramTransforms;MLIRNVGPUDialect;MLIRNVGPUUtils;MLIRNVGPUTransformOps;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenACCMPCommon;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRQuantDialect;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSparseTensorEnums;MLIRSparseTensorDialect;MLIRSparseTensorPipelines;MLIRSparseTensorTransformOps;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorTransformOps;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaShardingInterfaceImpl;MLIRTosaTransforms;MLIRTransformDebugExtension;MLIRTransformDialect;MLIRTransformLoopExtension;MLIRTransformPDLExtension;MLIRTransformDialectTransforms;MLIRTransformDialectUtils;MLIRUBDialect;MLIRDialectUtils;MLIRVectorDialect;MLIRMaskableOpInterface;MLIRMaskingOpInterface;MLIRVectorTransforms;MLIRVectorTransformOps;MLIRVectorUtils;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRDialect;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRDestinationStyleOpInterface;MLIRFunctionInterfaces;MLIRInferIntRangeInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRMemorySlotInterfaces;MLIRParallelCombiningOpInterface;MLIRRuntimeVerifiableOpInterface;MLIRShapedOpInterfaces;MLIRSideEffectInterfaces;MLIRSubsetOpInterface;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRValueBoundsOpInterface;MLIRInferIntRangeCommon;MLIRParser;MLIRPass;MLIRQuery;MLIRQueryMatcher;MLIRReduce;MLIRRewrite;MLIRRewritePDL;MLIRSupport;MLIRTableGen;MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRSPIRVTarget;MLIRArmNeonToLLVMIRTranslation;MLIRArmSMEToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRBuiltinToLLVMIRTranslation;MLIRGPUToLLVMIRTranslation;MLIRLLVMIRToLLVMTranslation;MLIRLLVMToLLVMIRTranslation;MLIRLLVMIRToNVVMTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRSPIRVToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRFromLLVMIRTranslationRegistration;MLIRTargetLLVM;MLIRNVVMTarget;MLIRROCDLTarget;MLIRLspServerSupportLib;MLIRLspServerLib;MLIROptLib;MLIRQueryLib;MLIRReduceLib;MLIRTblgenLib;MLIRTranslateLib;MLIRPDLLAST;MLIRPDLLCodeGen;MLIRPDLLODS;MLIRPluginsLib;MLIRTransformUtils;MLIRTransforms;MLIRExecutionEngineUtils;MLIRExecutionEngine;MLIRJitRunner;mlir_float16_utils;MLIRSparseTensorRuntime;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;mlir_arm_sme_abi_stubs;mlir_arm_runner_utils;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAMDGPU;obj.MLIRCAPIAMDGPU;MLIRCAPIArith;obj.MLIRCAPIArith;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIControlFlow;obj.MLIRCAPIControlFlow;MLIRCAPIMath;obj.MLIRCAPIMath;MLIRCAPIMemRef;obj.MLIRCAPIMemRef;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPIMLProgram;obj.MLIRCAPIMLProgram;MLIRCAPINVGPU;obj.MLIRCAPINVGPU;MLIRCAPINVVM;obj.MLIRCAPINVVM;MLIRCAPIROCDL;obj.MLIRCAPIROCDL;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIFunc;obj.MLIRCAPIFunc;MLIRCAPISPIRV;obj.MLIRCAPISPIRV;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPITransformDialect;obj.MLIRCAPITransformDialect;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIOpenMP;obj.MLIRCAPIOpenMP;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIVector;obj.MLIRCAPIVector;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegisterEverything;obj.MLIRCAPIRegisterEverything;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRCAPITarget;obj.MLIRCAPITarget;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;MLIR-C;MLIRMlirOptMain;MLIR")
set_property(GLOBAL PROPERTY MLIR_DIALECT_LIBS "MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineTransformOps;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRAMDGPUTransforms;MLIRAMDGPUUtils;MLIRAMXDialect;MLIRAMXTransforms;MLIRArithDialect;MLIRArithValueBoundsOpInterfaceImpl;MLIRArithTransforms;MLIRArithUtils;MLIRArmNeonDialect;MLIRArmSMEDialect;MLIRArmSMETransforms;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRBufferizationDialect;MLIRBufferizationPipelines;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRControlFlowTransforms;MLIRDLTIDialect;MLIREmitCDialect;MLIREmitCTransforms;MLIRFuncDialect;MLIRFuncTransforms;MLIRFuncTransformOps;MLIRGPUDialect;MLIRGPUTransforms;MLIRGPUTransformOps;MLIRGPUPipelines;MLIRIndexDialect;MLIRIRDL;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransformOps;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRMeshDialect;MLIRMeshTransforms;MLIRMLProgramDialect;MLIRMLProgramTransforms;MLIRNVGPUDialect;MLIRNVGPUUtils;MLIRNVGPUTransformOps;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRQuantDialect;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSparseTensorDialect;MLIRSparseTensorPipelines;MLIRSparseTensorTransformOps;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorTransformOps;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaShardingInterfaceImpl;MLIRTosaTransforms;MLIRTransformDebugExtension;MLIRTransformDialect;MLIRTransformLoopExtension;MLIRTransformPDLExtension;MLIRTransformDialectTransforms;MLIRTransformDialectUtils;MLIRUBDialect;MLIRVectorDialect;MLIRVectorTransforms;MLIRVectorTransformOps;MLIRVectorUtils;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRSPIRVTarget;MLIRNVVMTarget;MLIRROCDLTarget")
set_property(GLOBAL PROPERTY MLIR_CONVERSION_LIBS "MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithAttrToLLVMConversion;MLIRArithToAMDGPU;MLIRArithToArmSME;MLIRArithToLLVM;MLIRArithToSPIRV;MLIRArmNeon2dToIntr;MLIRArmSMEToSCF;MLIRArmSMEToLLVM;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexToLibm;MLIRComplexToLLVM;MLIRComplexToSPIRV;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSCF;MLIRControlFlowToSPIRV;MLIRConvertToLLVMInterface;MLIRConvertToLLVMPass;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRIndexToLLVM;MLIRIndexToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToFuncs;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToSPIRV;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRNVGPUToNVVM;MLIRNVVMToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToEmitC;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToMLProgram;MLIRTosaToSCF;MLIRTosaToTensor;MLIRUBToLLVM;MLIRUBToSPIRV;MLIRVectorToArmSME;MLIRVectorToGPU;MLIRVectorToLLVM;MLIRVectorToLLVMPass;MLIRVectorToSCF;MLIRVectorToSPIRV")
set_property(GLOBAL PROPERTY MLIR_EXTENSION_LIBS "MLIRFuncInlinerExtension;MLIRFuncAllExtensions")
set_property(GLOBAL PROPERTY MLIR_TRANSLATION_LIBS "MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSMEToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRBuiltinToLLVMIRTranslation;MLIRGPUToLLVMIRTranslation;MLIRLLVMIRToLLVMTranslation;MLIRLLVMToLLVMIRTranslation;MLIRLLVMIRToNVVMTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRSPIRVToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRFromLLVMIRTranslationRegistration")
set_property(GLOBAL PROPERTY MLIR_UPSTREAM_CAPI_LIBS "MLIRCAPIDebug;MLIRCAPIAMDGPU;MLIRCAPIArith;MLIRCAPIAsync;MLIRCAPIControlFlow;MLIRCAPIMath;MLIRCAPIMemRef;MLIRCAPIGPU;MLIRCAPILLVM;MLIRCAPILinalg;MLIRCAPIMLProgram;MLIRCAPINVGPU;MLIRCAPINVVM;MLIRCAPIROCDL;MLIRCAPISCF;MLIRCAPIShape;MLIRCAPISparseTensor;MLIRCAPIFunc;MLIRCAPISPIRV;MLIRCAPITensor;MLIRCAPITransformDialect;MLIRCAPIQuant;MLIRCAPIOpenMP;MLIRCAPIPDL;MLIRCAPIVector;MLIRCAPIConversion;MLIRCAPIInterfaces;MLIRCAPIIR;MLIRCAPIRegisterEverything;MLIRCAPITransforms;MLIRCAPITarget;MLIRCAPIExecutionEngine")

# Provide all our library targets to users.
# More specifically, configure MLIR so that it can be directly included in a top
# level CMakeLists.txt, but also so that it can be imported via `find_package`.
# This is based on how LLVM handles exports.
if(NOT TARGET MLIRSupport)
  include("${MLIR_CMAKE_DIR}/MLIRTargets.cmake")
endif()

# By creating these targets here, subprojects that depend on MLIR's
# tablegen-generated headers can always depend on these targets whether building
# in-tree with MLIR or not.
if(NOT TARGET mlir-tablegen-targets)
  add_custom_target(mlir-tablegen-targets)
endif()
if(NOT TARGET mlir-headers)
  add_custom_target(mlir-headers)
endif()
if(NOT TARGET mlir-generic-headers)
  add_custom_target(mlir-generic-headers)
endif()
if(NOT TARGET mlir-doc)
  add_custom_target(mlir-doc)
endif()
