#ifndef GODOT_CPP_OCCLUDERSHAPEPOLYGON_HPP
#define GODOT_CPP_OCCLUDERSHAPEPOLYGON_HPP


#include <gdnative_api_struct.gen.h>
#include <cstdint>

#include <core/CoreTypes.hpp>
#include <core/Ref.hpp>

#include "OccluderShape.hpp"
namespace godot {


class OccluderShapePolygon : public OccluderShape {
	struct ___method_bindings {
		godot_method_bind *mb_get_hole_points;
		godot_method_bind *mb_get_polygon_points;
		godot_method_bind *mb_is_two_way;
		godot_method_bind *mb_set_hole_point;
		godot_method_bind *mb_set_hole_points;
		godot_method_bind *mb_set_polygon_point;
		godot_method_bind *mb_set_polygon_points;
		godot_method_bind *mb_set_two_way;
	};
	static ___method_bindings ___mb;
	static void *_detail_class_tag;

public:
	static void ___init_method_bindings();
	inline static size_t ___get_id() { return (size_t)_detail_class_tag; }

	static inline const char *___get_class_name() { return (const char *) "OccluderShapePolygon"; }
	static inline const char *___get_godot_class_name() { return (const char *) "OccluderShapePolygon"; }
	static inline Object *___get_from_variant(Variant a) { godot_object *o = (godot_object*) a; return (o) ? (Object *) godot::nativescript_1_1_api->godot_nativescript_get_instance_binding_data(godot::_RegisterState::language_index, o) : nullptr; }

	// enums

	// constants


	static OccluderShapePolygon *_new();

	// methods
	PoolVector2Array get_hole_points() const;
	PoolVector2Array get_polygon_points() const;
	bool is_two_way() const;
	void set_hole_point(const int64_t index, const Vector2 position);
	void set_hole_points(const PoolVector2Array points);
	void set_polygon_point(const int64_t index, const Vector2 position);
	void set_polygon_points(const PoolVector2Array points);
	void set_two_way(const bool two_way);

};

}

#endif