
#pragma once


#include <map>
#include <vector>
#include <memory>

#include <glbinding/gl/types.h>

#include <globjects/globjects_api.h>
#include <globjects/Object.h>
#include <globjects/base/Instantiator.h>


namespace globjects 
{


class VertexAttributeBinding;
class Buffer;


// http://www.opengl.org/wiki/Vertex_Array_Object
class GLOBJECTS_API VertexArray : public Object, public Instantiator<VertexArray>
{
public:
    enum class AttributeImplementation
    {
        Legacy,
        VertexAttribBindingARB,
        DirectStateAccessARB
    };

    static void hintAttributeImplementation(AttributeImplementation impl);


public:
    VertexArray();

    virtual ~VertexArray();

    static std::unique_ptr<VertexArray> fromId(gl::GLuint id);
    static std::unique_ptr<VertexArray> defaultVAO();

    void bind() const;
    static void unbind();

    VertexAttributeBinding * binding(gl::GLuint bindingIndex);
    const VertexAttributeBinding * binding(gl::GLuint bindingIndex) const;

    void bindElementBuffer(const Buffer * buffer);

    void enable(gl::GLint attributeIndex);
    void disable(gl::GLint attributeIndex);

    std::vector<VertexAttributeBinding *> bindings();
    std::vector<const VertexAttributeBinding *> bindings() const;

    // drawing

    void drawArrays(gl::GLenum mode, gl::GLint first, gl::GLsizei count) const;
    void drawArraysInstanced(gl::GLenum mode, gl::GLint first, gl::GLsizei count, gl::GLsizei instanceCount) const;
    void drawArraysInstancedBaseInstance(gl::GLenum mode, gl::GLint first, gl::GLsizei count, gl::GLsizei instanceCount, gl::GLuint baseInstance) const;
    void drawArraysIndirect(gl::GLenum mode, const void * indirect = nullptr) const;

    void multiDrawArrays(gl::GLenum mode, gl::GLint * first, const gl::GLsizei * count, gl::GLsizei drawCount) const;
    void multiDrawArraysIndirect(gl::GLenum mode, const void * indirect, gl::GLsizei drawCount, gl::GLsizei stride) const;

    void drawElements(gl::GLenum mode, gl::GLsizei count, gl::GLenum type, const void * indices = nullptr) const;
    void drawElementsBaseVertex(gl::GLenum mode, gl::GLsizei count, gl::GLenum type, const void * indices, gl::GLint baseVertex) const;
    void drawElementsInstanced(gl::GLenum mode, gl::GLsizei count, gl::GLenum type, const void * indices, gl::GLsizei primitiveCount) const;
    void drawElementsInstancedBaseInstance(gl::GLenum mode, gl::GLsizei count, gl::GLenum type, const void * indices, gl::GLsizei instanceCount, gl::GLuint baseInstance) const;
    void drawElementsInstancedBaseVertex(gl::GLenum mode, gl::GLsizei count, gl::GLenum type, const void * indices, gl::GLsizei instanceCount, gl::GLint baseVertex) const;
    void drawElementsInstancedBaseVertexBaseInstance(gl::GLenum mode, gl::GLsizei count, gl::GLenum type, const void * indices, gl::GLsizei instanceCount, gl::GLint baseVertex, gl::GLuint baseInstance) const;

    void multiDrawElements(gl::GLenum mode, const gl::GLsizei * count, gl::GLenum type, const void ** indices, gl::GLsizei drawCount) const;
    void multiDrawElementsBaseVertex(gl::GLenum mode, const gl::GLsizei * count, gl::GLenum type, const void ** indices, gl::GLsizei drawCount, gl::GLint * baseVertex) const;
    void multiDrawElementsIndirect(gl::GLenum mode, gl::GLenum type, const void * indirect, gl::GLsizei drawCount, gl::GLsizei stride) const;

    void drawRangeElements(gl::GLenum mode, gl::GLuint start, gl::GLuint end, gl::GLsizei count, gl::GLenum type, const void * indices = nullptr) const;
    void drawRangeElementsBaseVertex(gl::GLenum mode, gl::GLuint start, gl::GLuint end, gl::GLsizei count, gl::GLenum type, const void * indices, gl::GLint baseVertex) const;

    // convenience
    struct MultiDrawArraysRange 
    { 
        gl::GLint first; 
        gl::GLsizei count; 
    };

    struct MultiDrawElementsRange 
    { 
        gl::GLsizei count; 
        void * indices; 
    };

    struct MultiDrawElementsBaseVertexRange 
    { 
        gl::GLsizei count;
        void * indices; 
        gl::GLint baseVertex; 
    };

    void multiDrawArrays(gl::GLenum mode, const std::vector<MultiDrawArraysRange> & ranges) const;
    void multiDrawElements(gl::GLenum mode, gl::GLenum type, const std::vector<MultiDrawElementsRange> & ranges) const;
    void multiDrawElementsBaseVertex(gl::GLenum mode, gl::GLenum type, const std::vector<MultiDrawElementsBaseVertexRange> & ranges) const;

    virtual gl::GLenum objectType() const override;


protected:
    VertexArray(std::unique_ptr<IDResource> && resource);


protected:
    std::map<gl::GLuint, std::unique_ptr<VertexAttributeBinding>> m_bindings;

};


} // namespace globjects
