#
# FLTKConfig.cmake - FLTK CMake configuration file for external projects.
#
# This file is generated by CMake and used to load FLTK's settings for
# an external project, i.e. a project using FLTK.
#
# It defines the following variables:
#
#  FLTK_VERSION           - FLTK version string ("x.y.z")
#  FLTK_INCLUDE_DIRS      - FLTK include directories
#  FLTK_LIBRARIES         - list of built FLTK libraries (not yet implemented)
#  FLTK_FLUID_EXECUTABLE  - needed by the function FLTK_RUN_FLUID
#                           (or the deprecated fltk_wrap_ui() CMake command)
#
# It defines the following deprecated variables for backwards
# compatibility (do not use for new projects):
#
#  FLTK_INCLUDE_DIR       - FLTK include directories (same as FLTK_INCLUDE_DIRS)
#
#  FLTK_USE_FILE          - previously used to set things up to use FLTK
#                         - deprecated since FLTK 1.3.4
#                         - will be removed in FLTK 1.4.0 or later
#
# Important note: FLTK's CMake build files are not yet complete and may be
# changed in future versions. This includes the list of defined variables
# above that may be changed if necessary.
#

set(FLTK_VERSION 1.3.11)

include(${CMAKE_CURRENT_LIST_DIR}/FLTK-Targets.cmake)

set(FLTK_INCLUDE_DIRS "/mingw64/include")
set(FLTK_USE_FILE ${CMAKE_CURRENT_LIST_DIR}/UseFLTK.cmake)

# For compatibility with CMake's FindFLTK.cmake:

set(FLTK_INCLUDE_DIR "${FLTK_INCLUDE_DIRS}")

if(CMAKE_CROSSCOMPILING)

  # Find a fluid executable on the build host to be able to build fluid programs

  find_program(FLTK_FLUID_HOST
    NAMES fluid fluid.exe
    PATHS ENV PATH
    NO_DEFAULT_PATH
    NO_CMAKE_FIND_ROOT_PATH
  )

  if(FLTK_FLUID_HOST)

    set(FLTK_FLUID_EXECUTABLE "${FLTK_FLUID_HOST}")

  else() # fluid not found on build host

    message(STATUS "FLTKConfig.cmake (cross-compiling): fluid not found on the build host")
    message(STATUS "Programs using fluid can't be built")
    # note: this assigns "FLTK_FLUID_HOST-NOTFOUND" and running fluid will fail
    set(FLTK_FLUID_EXECUTABLE "${FLTK_FLUID_HOST}")

  endif()

else(CMAKE_CROSSCOMPILING)

  # Use the target 'fluid' which is built together with the library.

  set(FLTK_FLUID_EXECUTABLE fluid)

endif(CMAKE_CROSSCOMPILING)

# Debug: should be commented out
# message(STATUS "FLTKConfig.cmake: FLTK_FLUID_EXECUTABLE = '${FLTK_FLUID_EXECUTABLE}'")
