#ifndef _CEGOBUFFERPAGE_H_INCLUDED_
#define _CEGOBUFFERPAGE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPage.h
// ----------------
// Cego BufferPage Class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBufferPage
// 
// Description: Database page container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include "CegoDefs.h"

class CegoBufferPage {
    
public:
    
    enum PageType { TABLE, TUPLE, BLOB, CLOB, BTREE_NODE, BTREE_LEAF };
    
    typedef struct PageHead {
	PageType pageType;
	PageIdType nextPageId;
    } PageHead;
    
    CegoBufferPage();
    CegoBufferPage(const CegoBufferPage& bp);
    CegoBufferPage(void *pagePtr, int pageSize);
    ~CegoBufferPage();
    
    void initPage(PageType t);

    void setFixed(bool isFixed);
    bool isFixed() const;

    void setPageId(PageIdType pageId);
    PageIdType& getPageId();
        
    void setNextPageId(PageIdType pageId);
    PageIdType& getNextPageId() const;
    
    void* newEntry(int size);
    void freeEntry(void *);
  
    int getNumEntries();
    
    void* getFirstEntry();
    void* getNextEntry();

    char* getChunkEntry() const;

    int getPageSize() const;
    int getChunkLen() const;
    int getEntryLen() const;
    int getEntryPos() const;
    
    void setType(PageType t);
    PageType& getType() const;

    void setPagePtr(char* ptr);
    void setPageHead(PageHead* ptr);
    void setPageSize(int pageSize);    

    void* getPagePtr() const;
    
    void printPage();

    CegoBufferPage& operator = ( const CegoBufferPage& bp);  
    bool operator == ( const CegoBufferPage& bp);
    bool operator != ( const CegoBufferPage& bp);

 private:

    PageIdType _pageId;
    
    int _pageSize;
    char *_pagePtr;
    
    char *_ePtr;
    char *_blobPtr;
    
    int _entryLen;
    int _entryPos;
    
    PageHead* _pageHead;

    bool _isFixed;
};

#endif
