/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.BorderStyle;
import com.github.ajalt.mordant.rendering.BorderStyleSection;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001Bw\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002J\b\u0010/\u001a\u000200H\u0002J(\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u0010\u00104\u001a\u0002002\u0006\u0010-\u001a\u00020\u000bH\u0002J7\u00105\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u000b2\b\u00107\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u00108J\u001a\u00109\u001a\u0004\u0018\u00010+2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u0006\u0010:\u001a\u00020!J,\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00030\u00032\u0006\u00103\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u001a\u0010<\u001a\u00020=2\u0006\u0010.\u001a\u00020\u000b2\b\b\u0002\u0010>\u001a\u00020\u0010H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001aR\u0014\u0010#\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001cR\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/github/ajalt/mordant/table/TableRenderer;", "", "rows", "", "Lcom/github/ajalt/mordant/table/Cell;", "Lcom/github/ajalt/mordant/table/ImmutableRow;", "borderStyle", "Lcom/github/ajalt/mordant/rendering/BorderStyle;", "borderTextStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "headerRowCount", "", "footerRowCount", "columnCount", "columnWidths", "columnBorders", "", "rowBorders", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "(Ljava/util/List;Lcom/github/ajalt/mordant/rendering/BorderStyle;Lcom/github/ajalt/mordant/rendering/TextStyle;IIILjava/util/List;Ljava/util/List;Ljava/util/List;Lcom/github/ajalt/mordant/terminal/Terminal;)V", "getBorderStyle", "()Lcom/github/ajalt/mordant/rendering/BorderStyle;", "getBorderTextStyle", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "getColumnBorders", "()Ljava/util/List;", "getColumnCount", "()I", "getColumnWidths", "getFooterRowCount", "getHeaderRowCount", "renderedRows", "Lcom/github/ajalt/mordant/rendering/Lines;", "getRowBorders", "rowCount", "getRowCount", "rowHeights", "getRows", "getT", "()Lcom/github/ajalt/mordant/terminal/Terminal;", "tableLines", "", "Lcom/github/ajalt/mordant/rendering/Span;", "cellAt", "x", "y", "drawBottomBorder", "", "drawCellContent", "tableLineY", "cell", "drawLeftBorderForColumn", "drawTopBorderForCell", "colWidth", "borderTop", "(IIIILjava/lang/Boolean;)I", "getTopLeftCorner", "render", "renderCell", "sectionOfRow", "Lcom/github/ajalt/mordant/rendering/BorderStyleSection;", "allowBottom", "mordant"})
final class TableRenderer {
    @NotNull
    private final List<List<Cell>> rows;
    @NotNull
    private final BorderStyle borderStyle;
    @NotNull
    private final TextStyle borderTextStyle;
    private final int headerRowCount;
    private final int footerRowCount;
    private final int columnCount;
    @NotNull
    private final List<Integer> columnWidths;
    @NotNull
    private final List<Boolean> columnBorders;
    @NotNull
    private final List<Boolean> rowBorders;
    @NotNull
    private final Terminal t;
    @NotNull
    private final List<List<Lines>> renderedRows;
    @NotNull
    private final List<Integer> rowHeights;
    @NotNull
    private final List<List<Span>> tableLines;

    /*
     * WARNING - void declaration
     */
    public TableRenderer(@NotNull List<? extends List<? extends Cell>> rows, @NotNull BorderStyle borderStyle, @NotNull TextStyle borderTextStyle, int headerRowCount, int footerRowCount, int columnCount, @NotNull List<Integer> columnWidths, @NotNull List<Boolean> columnBorders, @NotNull List<Boolean> rowBorders, @NotNull Terminal t) {
        List list;
        int n;
        int n2;
        void $this$count$iv;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Object object;
        Object object2;
        int n3;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(rows, "rows");
        Intrinsics.checkNotNullParameter(borderStyle, "borderStyle");
        Intrinsics.checkNotNullParameter(borderTextStyle, "borderTextStyle");
        Intrinsics.checkNotNullParameter(columnWidths, "columnWidths");
        Intrinsics.checkNotNullParameter(columnBorders, "columnBorders");
        Intrinsics.checkNotNullParameter(rowBorders, "rowBorders");
        Intrinsics.checkNotNullParameter(t, "t");
        this.rows = rows;
        this.borderStyle = borderStyle;
        this.borderTextStyle = borderTextStyle;
        this.headerRowCount = headerRowCount;
        this.footerRowCount = footerRowCount;
        this.columnCount = columnCount;
        this.columnWidths = columnWidths;
        this.columnBorders = columnBorders;
        this.rowBorders = rowBorders;
        this.t = t;
        Iterable iterable = this.rows;
        TableRenderer tableRenderer = this;
        boolean $i$f$map = false;
        void var13_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv2;
            void r;
            List list2 = (List)item$iv$iv;
            collection = destination$iv$iv;
            n3 = 0;
            Iterable $this$mapIndexed$iv2 = (Iterable)r;
            boolean $i$f$mapIndexed2 = false;
            Iterable iterable2 = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv2, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                Lines lines;
                void it;
                int n4 = index$iv$iv++;
                boolean bl = false;
                if (n4 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Cell cell2 = (Cell)item$iv$iv2;
                int n5 = n4;
                object2 = destination$iv$iv2;
                boolean bl2 = false;
                if (it instanceof Cell.Content) {
                    void x;
                    Iterable iterable3 = RangesKt.until((int)x, (int)(x + it.getColumnSpan()));
                    boolean bl3 = false;
                    int n6 = 0;
                    Iterator iterator2 = iterable3.iterator();
                    while (iterator2.hasNext()) {
                        void it2;
                        int n7;
                        int n8 = n7 = ((IntIterator)iterator2).nextInt();
                        int n9 = n6;
                        boolean bl4 = false;
                        int n10 = ((Number)this.getColumnWidths().get((int)it2)).intValue();
                        n6 = n9 + n10;
                    }
                    int w = n6;
                    lines = w == 0 ? ConstantsKt.getEMPTY_LINES() : ((Cell.Content)it).getContent().render(this.getT(), w).withStyle$mordant(((Cell.Content)it).getStyle());
                } else {
                    lines = ConstantsKt.getEMPTY_LINES();
                }
                Lines lines2 = lines;
                object2.add(lines2);
            }
            object = (List)destination$iv$iv2;
            collection.add(object);
        }
        collection = (List)destination$iv$iv;
        tableRenderer.renderedRows = collection;
        $this$map$iv = this.renderedRows;
        tableRenderer = this;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            int n11;
            Comparable comparable;
            void r;
            n3 = index$iv$iv++;
            boolean $this$mapIndexed$iv2 = false;
            if (n3 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List $i$f$mapIndexed2 = (List)item$iv$iv;
            int $this$mapIndexedTo$iv$iv2 = n3;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable4 = CollectionsKt.withIndex((Iterable)r);
            boolean bl5 = false;
            Iterator<Object> iterator3 = iterable4.iterator();
            if (!iterator3.hasNext()) {
                comparable = null;
            } else {
                void y;
                Cell x;
                IndexedValue $dstr$x$it = (IndexedValue)iterator3.next();
                boolean bl6 = false;
                int x2 = $dstr$x$it.component1();
                Lines it = (Lines)$dstr$x$it.component2();
                Comparable comparable2 = Integer.valueOf(it.getHeight() / ((x = this.cellAt(x2, (int)y)) == null ? 1 : x.getRowSpan()));
                while (iterator3.hasNext()) {
                    IndexedValue $dstr$x$it2 = (IndexedValue)iterator3.next();
                    $i$a$-maxOfOrNull-TableRenderer$rowHeights$1$1 = false;
                    int x3 = $dstr$x$it2.component1();
                    Lines it3 = (Lines)$dstr$x$it2.component2();
                    Comparable comparable3 = Integer.valueOf(it3.getHeight() / ((object2 = this.cellAt(x3, (int)y)) == null ? 1 : ((Cell)object2).getRowSpan()));
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n12 = (Integer)comparable;
            object = n12 == null ? 1 : (n11 = RangesKt.coerceAtLeast(n12, 1));
            collection.add(object);
        }
        tableRenderer.rowHeights = collection = (List)destination$iv$iv;
        $this$mapIndexed$iv = this.rowBorders;
        int n13 = CollectionsKt.sumOfInt((Iterable<Integer>)this.rowHeights);
        tableRenderer = this;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean it = (Boolean)element$iv;
                boolean bl = false;
                if (!it) continue;
                n = ++count$iv;
                boolean bl7 = false;
                if (n >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int n14 = n2;
        int n15 = n13 + n14;
        boolean bl = false;
        ArrayList<List> arrayList = new ArrayList<List>(n15);
        boolean bl8 = false;
        int n16 = 0;
        n16 = 0;
        n = n15;
        while (n16 < n) {
            int n17 = n16++;
            boolean bl9 = false;
            n3 = n17;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl10 = false;
            boolean bl11 = false;
            List list3 = new ArrayList();
            arrayList2.add(list3);
        }
        tableRenderer.tableLines = list = (List)arrayList;
    }

    @NotNull
    public final List<List<Cell>> getRows() {
        return this.rows;
    }

    @NotNull
    public final BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    @NotNull
    public final TextStyle getBorderTextStyle() {
        return this.borderTextStyle;
    }

    public final int getHeaderRowCount() {
        return this.headerRowCount;
    }

    public final int getFooterRowCount() {
        return this.footerRowCount;
    }

    public final int getColumnCount() {
        return this.columnCount;
    }

    @NotNull
    public final List<Integer> getColumnWidths() {
        return this.columnWidths;
    }

    @NotNull
    public final List<Boolean> getColumnBorders() {
        return this.columnBorders;
    }

    @NotNull
    public final List<Boolean> getRowBorders() {
        return this.rowBorders;
    }

    @NotNull
    public final Terminal getT() {
        return this.t;
    }

    private final int getRowCount() {
        return this.rows.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Lines render() {
        Collection<Line> collection;
        void $this$mapTo$iv$iv;
        Iterator<List<Cell>> iterator2;
        int n = 0;
        int n2 = this.columnWidths.size() + -1;
        if (n <= n2) {
            do {
                int x = n++;
                this.drawLeftBorderForColumn(x);
                int colWidth = ((Number)this.columnWidths.get(x)).intValue();
                int tableLineY = 0;
                iterator2 = this.rows.iterator();
                int n3 = 0;
                while (iterator2.hasNext()) {
                    int y = n3++;
                    List<Cell> row2 = iterator2.next();
                    int rowHeight = ((Number)this.rowHeights.get(y)).intValue();
                    Cell cell2 = CollectionsKt.getOrNull(row2, x);
                    Cell cell3 = cell2 == null ? (Cell)Cell.Empty.INSTANCE : cell2;
                    tableLineY += this.drawTopBorderForCell(tableLineY, x, y, colWidth, cell3.getBorderTop());
                    this.drawCellContent(tableLineY, cell3, x, y);
                    tableLineY += rowHeight;
                }
            } while (n <= n2);
        }
        this.drawLeftBorderForColumn(this.columnCount);
        this.drawBottomBorder();
        Iterable $this$map$iv = this.tableLines;
        boolean $i$f$map = false;
        Iterable x = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            List<Cell> item$iv$iv;
            List<Cell> y = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Line line = new Line((List<Span>)it);
            collection.add(line);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        return new Lines(list);
    }

    private final void drawBottomBorder() {
        Span span;
        if (!this.rowBorders.get(this.getRowCount()).booleanValue()) {
            return;
        }
        List<Span> line = this.tableLines.get(CollectionsKt.getLastIndex(this.tableLines));
        int n = 0;
        int n2 = this.columnWidths.size() + -1;
        if (n <= n2) {
            do {
                Span span2;
                int x;
                if (this.columnBorders.get(x = n++).booleanValue() && (span2 = this.getTopLeftCorner(x, this.getRowCount())) != null) {
                    Span span3 = span2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Span it = span3;
                    boolean bl3 = false;
                    line.add(it);
                }
                this.drawTopBorderForCell(CollectionsKt.getLastIndex(this.tableLines), x, this.getRowCount(), ((Number)this.columnWidths.get(x)).intValue(), false);
            } while (n <= n2);
        }
        if (this.columnBorders.get(this.columnCount).booleanValue() && (span = this.getTopLeftCorner(this.columnCount, this.getRowCount())) != null) {
            Span span4 = span;
            boolean bl = false;
            boolean bl4 = false;
            Span it = span4;
            boolean bl5 = false;
            line.add(it);
        }
    }

    private final void drawCellContent(int tableLineY, Cell cell2, int x, int y) {
        List<List<Span>> lines = this.renderCell(cell2, x, y);
        Iterator<List<Span>> iterator2 = lines.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            List<Span> line = iterator2.next();
            this.tableLines.get(tableLineY + i).addAll((Collection<Span>)line);
        }
    }

    private final int drawTopBorderForCell(int tableLineY, int x, int y, int colWidth, Boolean borderTop) {
        Cell cell2;
        if (!this.rowBorders.get(y).booleanValue()) {
            return 0;
        }
        if (colWidth == 0 || borderTop == null) {
            return 1;
        }
        String string = borderTop != false || ((cell2 = this.cellAt(x, y - 1)) == null ? false : Intrinsics.areEqual(cell2.getBorderBottom(), true)) ? TableRenderer.sectionOfRow$default(this, y, false, 2, null).getEw() : " ";
        this.tableLines.get(tableLineY).add(Span.Companion.word(StringsKt.repeat(string, colWidth), this.borderTextStyle));
        return 1;
    }

    private final void drawLeftBorderForColumn(int x) {
        if (!this.columnBorders.get(x).booleanValue()) {
            return;
        }
        int tableLineY = 0;
        Iterator<List<Cell>> iterator2 = this.rows.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int topBorderHeight;
            int n2;
            Cell cell2;
            int y = n++;
            List<Cell> row2 = iterator2.next();
            int rowHeight = ((Number)this.rowHeights.get(y)).intValue();
            Object object = CollectionsKt.getOrNull(row2, x);
            Cell cell3 = cell2 = object == null ? (Cell)Cell.Empty.INSTANCE : object;
            if (this.rowBorders.get(y).booleanValue() && (object = this.getTopLeftCorner(x, y)) != null) {
                Object object2 = object;
                boolean bl = false;
                n2 = 0;
                Object it = object2;
                boolean bl2 = false;
                this.tableLines.get(tableLineY).add((Span)it);
            }
            Boolean borderLeft = cell2.getBorderLeft();
            int n3 = topBorderHeight = this.rowBorders.get(y) != false ? 1 : 0;
            if (borderLeft != null) {
                Cell cell4;
                Span border = borderLeft != false || ((cell4 = this.cellAt(x - 1, y)) == null ? false : Intrinsics.areEqual(cell4.getBorderRight(), true)) ? Span.Companion.word(this.sectionOfRow(y, false).getNs(), this.borderTextStyle) : ConstantsKt.getSINGLE_SPACE();
                n2 = 0;
                if (n2 < rowHeight) {
                    do {
                        int i = n2++;
                        this.tableLines.get(tableLineY + i + topBorderHeight).add(border);
                    } while (n2 < rowHeight);
                }
            }
            tableLineY += rowHeight + topBorderHeight;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Span>> renderCell(Cell cell2, int x, int y) {
        List<Line> list;
        Cell cell3 = cell2;
        if (cell3 instanceof Cell.SpanRef) {
            list = CollectionsKt.emptyList();
        } else if (cell3 instanceof Cell.Empty) {
            List<Span> space = CollectionsKt.listOf(Span.Companion.space$default(Span.Companion, ((Number)this.columnWidths.get(x)).intValue(), null, 2, null));
            int n = ((Number)this.rowHeights.get(y)).intValue();
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<List<Span>> arrayList = new ArrayList<List<Span>>(n);
            boolean bl3 = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int n4 = n2++;
                boolean bl4 = false;
                int n5 = n4;
                ArrayList<List<Span>> arrayList2 = arrayList;
                boolean bl5 = false;
                List<Span> list2 = space;
                arrayList2.add(list2);
            }
            list = (List<Line>)arrayList;
        } else if (cell3 instanceof Cell.Content) {
            int n;
            void $this$count$iv;
            int it;
            int n6;
            int count$iv;
            int n7;
            void $this$count$iv2;
            int n8;
            int it2;
            int n9;
            Iterable iterable = RangesKt.until(x, x + cell2.getColumnSpan());
            boolean bl = false;
            int n10 = 0;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                int n11;
                int n12 = n11 = ((IntIterator)iterator2).nextInt();
                n9 = n10;
                boolean bl6 = false;
                n8 = ((Number)this.getColumnWidths().get(it2)).intValue();
                n10 = n9 + n8;
            }
            iterable = RangesKt.until(x + 1, x + cell2.getColumnSpan());
            n9 = n10;
            boolean $i$f$count22 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n7 = 0;
            } else {
                count$iv = 0;
                iterator2 = $this$count$iv2.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    it2 = element$iv = ((IntIterator)iterator2).nextInt();
                    n6 = 0;
                    if (!this.getColumnBorders().get(it2 + 1).booleanValue()) continue;
                    it2 = ++count$iv;
                    n6 = 0;
                    if (it2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n7 = count$iv;
            }
            n8 = n7;
            int cellWidth2 = RangesKt.coerceAtLeast(n9 + n8, 0);
            Iterable $i$f$count22 = RangesKt.until(y, y + cell2.getRowSpan());
            count$iv = 0;
            int n13 = 0;
            Iterator iterator3 = $i$f$count22.iterator();
            while (iterator3.hasNext()) {
                n6 = it2 = ((IntIterator)iterator3).nextInt();
                n9 = n13;
                boolean bl7 = false;
                n8 = ((Number)this.rowHeights.get(it)).intValue();
                n13 = n9 + n8;
            }
            $i$f$count22 = RangesKt.until(y + 1, y + cell2.getRowSpan());
            n9 = n13;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv2 = 0;
                iterator3 = $this$count$iv.iterator();
                while (iterator3.hasNext()) {
                    int element$iv;
                    it = element$iv = ((IntIterator)iterator3).nextInt();
                    boolean bl8 = false;
                    if (!this.getRowBorders().get(it + 1).booleanValue()) continue;
                    int n14 = ++count$iv2;
                    boolean bl9 = false;
                    if (n14 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv2;
            }
            n8 = n;
            int cellHeight = n9 + n8;
            list = LinesKt.setSize(((Cell.Content)cell2).getContent().render(this.t, cellWidth2).withStyle$mordant(((Cell.Content)cell2).getStyle()), cellWidth2, cellHeight, ((Cell.Content)cell2).getVerticalAlign(), ((Cell.Content)cell2).getTextAlign()).getLines();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final Cell cellAt(int x, int y) {
        List<Cell> list = CollectionsKt.getOrNull(this.rows, y);
        return list == null ? null : CollectionsKt.getOrNull(list, x);
    }

    private final Span getTopLeftCorner(int x, int y) {
        Cell cell2;
        Cell tl = this.cellAt(x - 1, y - 1);
        Cell tr = this.cellAt(x, y - 1);
        Cell bl = this.cellAt(x - 1, y);
        Cell br = this.cellAt(x, y);
        if ((tl != null || tr != null || bl != null || br != null) && ((cell2 = tl) == null ? null : cell2.getBorderRight()) == null && ((cell2 = tr) == null ? null : cell2.getBorderLeft()) == null && ((cell2 = tr) == null ? null : cell2.getBorderBottom()) == null && ((cell2 = br) == null ? null : cell2.getBorderTop()) == null && ((cell2 = bl) == null ? null : cell2.getBorderRight()) == null && ((cell2 = br) == null ? null : cell2.getBorderLeft()) == null && ((cell2 = tl) == null ? null : cell2.getBorderBottom()) == null && ((cell2 = bl) == null ? null : cell2.getBorderTop()) == null) {
            return null;
        }
        cell2 = tl;
        boolean bl2 = (cell2 == null ? false : Intrinsics.areEqual(cell2.getBorderRight(), true)) || ((cell2 = tr) == null ? false : Intrinsics.areEqual(cell2.getBorderLeft(), true));
        cell2 = tr;
        boolean bl3 = (cell2 == null ? false : Intrinsics.areEqual(cell2.getBorderBottom(), true)) || ((cell2 = br) == null ? false : Intrinsics.areEqual(cell2.getBorderTop(), true));
        cell2 = bl;
        boolean bl4 = (cell2 == null ? false : Intrinsics.areEqual(cell2.getBorderRight(), true)) || ((cell2 = br) == null ? false : Intrinsics.areEqual(cell2.getBorderLeft(), true));
        cell2 = tl;
        return TableRenderer.sectionOfRow$default(this, y, false, 2, null).getCorner(bl2, bl3, bl4, (cell2 == null ? false : Intrinsics.areEqual(cell2.getBorderBottom(), true)) || ((cell2 = bl) == null ? false : Intrinsics.areEqual(cell2.getBorderTop(), true)), this.borderTextStyle);
    }

    private final BorderStyleSection sectionOfRow(int y, boolean allowBottom) {
        return y < this.headerRowCount ? this.borderStyle.getHead() : (allowBottom && this.headerRowCount > 0 && y == this.headerRowCount ? this.borderStyle.getHeadBottom() : (allowBottom && this.footerRowCount > 0 && y == this.getRowCount() - this.footerRowCount ? this.borderStyle.getBodyBottom() : (this.footerRowCount == 0 || y < this.getRowCount() - this.footerRowCount ? this.borderStyle.getBody() : this.borderStyle.getFoot())));
    }

    static /* synthetic */ BorderStyleSection sectionOfRow$default(TableRenderer tableRenderer, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return tableRenderer.sectionOfRow(n, bl);
    }
}

