#!/usr/bin/python.exe
if __name__ == '__main__':
  import sys
  import os
  sys.path.insert(0, os.path.abspath('config'))
  import configure
  configure_options = [
    '--PETSC_ARCH=zto',
    '--with-debugging=0',
    '--with-hwloc=1',
    '--with-mpi=0',
    '--with-openblas-dir=/mingw32',
    '--with-openblas=1',
    '--with-openmp=1',
    '--with-precision=double',
    '--with-pthread=0',
    '--with-scalar-type=complex',
    '--with-shared-libraries=0',
    '--with-single-library=1',
    '--with-windows-graphics=0',
    '--with-x=0',
    'CC=gcc',
    'CFLAGS=-march=pentium4 -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong',
    'CPPFLAGS=-D__USE_MINGW_ANSI_STDIO=1',
    'CXX=g++',
    'CXXFLAGS=-march=pentium4 -mtune=generic -O2 -pipe',
    'FC=gfortran',
    'FFLAGS=-march=pentium4 -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -I/mingw32/include -fallow-invalid-boz -fallow-argument-mismatch',
    'LDFLAGS=-pipe -Wl,--no-seh -Wl,--large-address-aware -fopenmp',
    'LIBS= -lgfortran -lquadmath',
    'MAKEFLAGS=-j5',
  ]
  configure.petsc_configure(configure_options)
