# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Seacas/SEACASIoss clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "SEACASIoss requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.22.0)

## ---------------------------------------------------------------------------
## Compilers used by Seacas/SEACASIoss build
## ---------------------------------------------------------------------------

set(SEACASIoss_CXX_COMPILER "${_IMPORT_PREFIX}/bin/clang++.exe")

set(SEACASIoss_C_COMPILER "${_IMPORT_PREFIX}/bin/clang.exe")

set(SEACASIoss_Fortran_COMPILER "gfortran")
# Deprecated!
set(SEACASIoss_FORTRAN_COMPILER "gfortran") 


## ---------------------------------------------------------------------------
## Compiler flags used by Seacas/SEACASIoss build
## ---------------------------------------------------------------------------

## Give the build type
set(SEACASIoss_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(SEACASIoss_CXX_FLAGS [[ ]])

set(SEACASIoss_C_FLAGS [[-Wall -Wunused -pedantic -Wshadow -std=c11 ]])

set(SEACASIoss_Fortran_FLAGS [[ ]])
# Deprecated
set(SEACASIoss_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(SEACASIoss_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(SEACASIoss_SHARED_LIB_RPATH_COMMAND "${_IMPORT_PREFIX}/lib")
set(SEACASIoss_BUILD_SHARED_LIBS "ON")

set(SEACASIoss_LINKER ${_IMPORT_PREFIX}/bin/ld.lld.exe)
set(SEACASIoss_AR ${_IMPORT_PREFIX}/bin/llvm-ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(SEACASIoss_INSTALL_DIR "${_IMPORT_PREFIX}")

## List of package libraries
set(SEACASIoss_LIBRARIES SEACASIoss::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(SEACASIoss_MPI_LIBRARIES "")
set(SEACASIoss_MPI_LIBRARY_DIRS "")
set(SEACASIoss_MPI_INCLUDE_DIRS "")
set(SEACASIoss_MPI_EXEC "")
set(SEACASIoss_MPI_EXEC_MAX_NUMPROCS "")
set(SEACASIoss_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(SEACASIoss_ENABLE_SEACASExodus ON)
set(SEACASIoss_ENABLE_Zoltan ON)
set(SEACASIoss_ENABLE_fmt ON)
set(SEACASIoss_ENABLE_HDF5 OFF)
set(SEACASIoss_ENABLE_Pamgen OFF)
set(SEACASIoss_ENABLE_CGNS OFF)
set(SEACASIoss_ENABLE_ParMETIS OFF)
set(SEACASIoss_ENABLE_Faodel OFF)
set(SEACASIoss_ENABLE_Cereal OFF)
set(SEACASIoss_ENABLE_DLlib ON)
set(SEACASIoss_ENABLE_Pthread ON)
set(SEACASIoss_ENABLE_ADIOS2 OFF)
set(SEACASIoss_ENABLE_Catalyst2 OFF)
set(SEACASIoss_ENABLE_GTest OFF)
set(SEACASIoss_ENABLE_Kokkos OFF)
set(SEACASIoss_ENABLE_DataWarp OFF)

# Exported cache variables
set(SEACAS_ENABLE_DEBUG "OFF")
set(HAVE_SEACAS_DEBUG "OFF")
set(SEACASExodus_ENABLE_THREADSAFE "YES")
set(EXODUS_THREADSAFE "ON")
set(SEACASIoss_ENABLE_THREADSAFE "YES")
set(IOSS_THREADSAFE "ON")

# Include configuration of dependent packages
if (NOT TARGET SEACASExodus::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus/SEACASExodusConfig.cmake")
endif()
if (NOT TARGET Zoltan::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Zoltan/ZoltanConfig.cmake")
endif()
if (NOT TARGET fmt::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/fmt/fmtConfig.cmake")
endif()
if (NOT TARGET DLlib::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/DLlib/DLlibConfig.cmake")
endif()
if (NOT TARGET Pthread::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../../external_packages/Pthread/PthreadConfig.cmake")
endif()

# Import SEACASIoss targets
include("${CMAKE_CURRENT_LIST_DIR}/SEACASIossTargets.cmake")

# Standard TriBITS-compliant external package variables
set(SEACASIoss_IS_TRIBITS_COMPLIANT TRUE)
set(SEACASIoss_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(SEACASIoss_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(SEACASIoss_EXPORTED_PACKAGE_LIBS_NAMES "Ioex;Ioexnl;Ionull;Iovs;Iogn;Iotm;Iogs;Iohb;Iotr;Ionit;io_info_lib;Ioss")

foreach(libname IN LISTS SEACASIoss_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE SEACASIoss::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Seacas', then use the"
      " new namespaced target 'SEACASIoss::${libname}', or better yet,"
      " 'SEACASIoss::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'SEACASIoss'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Seacas', instead link against the"
      " libraries specified by the variable 'SEACASIoss_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
