%feature("docstring") OT::KDTree
"Partition tree data structure.

Allows one to store and search points fast.

Available constructors:
    KDTree(*sample*)

Parameters
----------
sample : 2-d sequence of float
    Points.

See also
--------
NearestNeighbourAlgorithm

Examples
--------
>>> import openturns as ot
>>> sample = ot.Normal(2).getSample(10)
>>> tree = ot.KDTree(sample)
>>> neighbour = sample[tree.query([0.1, 0.2])]"
