
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

####################################################################################

include("${CMAKE_CURRENT_LIST_DIR}/tritonTargets.cmake")

set(TRITON_ARCHIVE              "${PACKAGE_PREFIX_DIR}/lib/libtriton.dll.a")
set(TRITON_BITWUZLA_INTERFACE   OFF)
set(TRITON_BOOST_INTERFACE      ON)
set(TRITON_BUILD_SHARED_LIBS    ON)
set(TRITON_INCLUDE_DIRS         "${PACKAGE_PREFIX_DIR}/include")
set(TRITON_INSTALL_PREFIX       ${PACKAGE_PREFIX_DIR})
set(TRITON_LIBRARIES            "triton;;z3.dll;LLVM;;capstone.dll")
set(TRITON_LIBRARY              "${PACKAGE_PREFIX_DIR}/bin/libtriton.dll")
set(TRITON_LLVM_INTERFACE       ON)
set(TRITON_MSVC_STATIC          OFF)
set(TRITON_PYTHON_BINDINGS      ON)
set(TRITON_VERSION              1.0)
set(TRITON_Z3_INTERFACE         ON)

message(STATUS "Found Triton: ${CMAKE_CURRENT_LIST_DIR}/tritonConfig.cmake (found version ${TRITON_VERSION})")

include(CMakeFindDependencyMacro)

# Boost includes
if (TRITON_BOOST_INTERFACE)
  find_dependency(Boost)
endif()

# Triton include
include_directories("${PACKAGE_PREFIX_DIR}/include")
link_directories(BEFORE "${PACKAGE_PREFIX_DIR}/lib")

# Capstone include
include_directories("${PACKAGE_PREFIX_DIR}/include;${PACKAGE_PREFIX_DIR}/include")
link_directories(BEFORE "${PACKAGE_PREFIX_DIR}/lib")

# Python include directories
if (TRITON_PYTHON_BINDINGS)
    include_directories("")
    link_directories(BEFORE "")
endif()

# LLVM include and lib directories
if (TRITON_LLVM_INTERFACE)
    include_directories("${PACKAGE_PREFIX_DIR}/include")
    link_directories(BEFORE "${PACKAGE_PREFIX_DIR}/lib")
endif()

# Z3 include directories
if (TRITON_Z3_INTERFACE)
    include_directories("${PACKAGE_PREFIX_DIR}/include;${PACKAGE_PREFIX_DIR}/include")
    link_directories(BEFORE "${PACKAGE_PREFIX_DIR}/lib")
endif()

# Bitwuzla include directories
if (TRITON_BITWUZLA_INTERFACE)
    include_directories("")
    link_directories(BEFORE "")
endif()
