# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/MiniTensor clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "MiniTensor requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/MiniTensor build
## ---------------------------------------------------------------------------

set(MiniTensor_CXX_COMPILER "D:/M/msys64/clang64/bin/clang++.exe")

set(MiniTensor_C_COMPILER "D:/M/msys64/clang64/bin/clang.exe")

set(MiniTensor_Fortran_COMPILER "D:/M/msys64/clang64/bin/flang.exe")
# Deprecated!
set(MiniTensor_FORTRAN_COMPILER "D:/M/msys64/clang64/bin/flang.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/MiniTensor build
## ---------------------------------------------------------------------------

## Give the build type
set(MiniTensor_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(MiniTensor_CXX_FLAGS [[ ]])

set(MiniTensor_C_FLAGS [[-march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(MiniTensor_Fortran_FLAGS [[ ]])
# Deprecated
set(MiniTensor_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(MiniTensor_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(MiniTensor_SHARED_LIB_RPATH_COMMAND "/clang64/lib")
set(MiniTensor_BUILD_SHARED_LIBS "ON")

set(MiniTensor_LINKER D:/M/msys64/clang64/bin/ld.lld.exe)
set(MiniTensor_AR D:/M/msys64/clang64/bin/llvm-ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(MiniTensor_INSTALL_DIR "/clang64")

## List of package libraries
set(MiniTensor_LIBRARIES MiniTensor::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(MiniTensor_MPI_LIBRARIES "")
set(MiniTensor_MPI_LIBRARY_DIRS "")
set(MiniTensor_MPI_INCLUDE_DIRS "")
set(MiniTensor_MPI_EXEC "")
set(MiniTensor_MPI_EXEC_MAX_NUMPROCS "")
set(MiniTensor_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(MiniTensor_ENABLE_TeuchosCore ON)
set(MiniTensor_ENABLE_Kokkos ON)
set(MiniTensor_ENABLE_KokkosKernels ON)
set(MiniTensor_ENABLE_Sacado ON)

# Exported cache variables
set(MiniTensor_ENABLE_EXPLICIT_INSTANTIATION "ON")
set(HAVE_MINITENSOR_EXPLICIT_INSTANTIATION "ON")
set(MiniTensor_ENABLE_DEBUG "OFF")
set(HAVE_MINITENSOR_DEBUG "OFF")

# Include configuration of dependent packages
if (NOT TARGET TeuchosCore::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TeuchosCore/TeuchosCoreConfig.cmake")
endif()
if (NOT TARGET Kokkos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Kokkos/KokkosConfig.cmake")
endif()
if (NOT TARGET KokkosKernels::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../KokkosKernels/KokkosKernelsConfig.cmake")
endif()
if (NOT TARGET Sacado::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Sacado/SacadoConfig.cmake")
endif()

# Import MiniTensor targets
include("${CMAKE_CURRENT_LIST_DIR}/MiniTensorTargets.cmake")

# Standard TriBITS-compliant external package variables
set(MiniTensor_IS_TRIBITS_COMPLIANT TRUE)
set(MiniTensor_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(MiniTensor_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(MiniTensor_EXPORTED_PACKAGE_LIBS_NAMES "minitensor")

foreach(libname IN LISTS MiniTensor_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE MiniTensor::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'MiniTensor::${libname}', or better yet,"
      " 'MiniTensor::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'MiniTensor'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'MiniTensor_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
