# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/Stratimikos clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "Stratimikos requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/Stratimikos build
## ---------------------------------------------------------------------------

set(Stratimikos_CXX_COMPILER "D:/a/msys64/clang64/bin/clang++.exe")

set(Stratimikos_C_COMPILER "D:/a/msys64/clang64/bin/clang.exe")

set(Stratimikos_Fortran_COMPILER "D:/a/msys64/clang64/bin/flang.exe")
# Deprecated!
set(Stratimikos_FORTRAN_COMPILER "D:/a/msys64/clang64/bin/flang.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/Stratimikos build
## ---------------------------------------------------------------------------

## Give the build type
set(Stratimikos_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(Stratimikos_CXX_FLAGS [[ ]])

set(Stratimikos_C_FLAGS [[-march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(Stratimikos_Fortran_FLAGS [[ ]])
# Deprecated
set(Stratimikos_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(Stratimikos_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(Stratimikos_SHARED_LIB_RPATH_COMMAND "/clang64/lib")
set(Stratimikos_BUILD_SHARED_LIBS "ON")

set(Stratimikos_LINKER D:/a/msys64/clang64/bin/ld.lld.exe)
set(Stratimikos_AR D:/a/msys64/clang64/bin/llvm-ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(Stratimikos_INSTALL_DIR "/clang64")

## List of package libraries
set(Stratimikos_LIBRARIES Stratimikos::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(Stratimikos_MPI_LIBRARIES "")
set(Stratimikos_MPI_LIBRARY_DIRS "")
set(Stratimikos_MPI_INCLUDE_DIRS "")
set(Stratimikos_MPI_EXEC "")
set(Stratimikos_MPI_EXEC_MAX_NUMPROCS "")
set(Stratimikos_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(Stratimikos_ENABLE_ThyraCore ON)
set(Stratimikos_ENABLE_Amesos OFF)
set(Stratimikos_ENABLE_Amesos2 OFF)
set(Stratimikos_ENABLE_AztecOO OFF)
set(Stratimikos_ENABLE_Belos ON)
set(Stratimikos_ENABLE_Ifpack OFF)
set(Stratimikos_ENABLE_Ifpack2 OFF)
set(Stratimikos_ENABLE_ML OFF)
set(Stratimikos_ENABLE_EpetraExt OFF)
set(Stratimikos_ENABLE_ThyraEpetraAdapters OFF)
set(Stratimikos_ENABLE_ThyraTpetraAdapters OFF)

# Exported cache variables
set(Stratimikos_Belos_Timers "ON")
set(HAVE_STRATIMIKOS_BELOS_TIMERS "ON")
set(Stratimikos_ENABLE_EXPLICIT_INSTANTIATION "ON")
set(HAVE_STRATIMIKOS_EXPLICIT_INSTANTIATION "ON")

# Include configuration of dependent packages
if (NOT TARGET ThyraCore::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../ThyraCore/ThyraCoreConfig.cmake")
endif()
if (NOT TARGET Belos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Belos/BelosConfig.cmake")
endif()

# Import Stratimikos targets
include("${CMAKE_CURRENT_LIST_DIR}/StratimikosTargets.cmake")

# Standard TriBITS-compliant external package variables
set(Stratimikos_IS_TRIBITS_COMPLIANT TRUE)
set(Stratimikos_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(Stratimikos_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(Stratimikos_EXPORTED_PACKAGE_LIBS_NAMES "stratimikosbelos;stratimikos")

foreach(libname IN LISTS Stratimikos_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE Stratimikos::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'Stratimikos::${libname}', or better yet,"
      " 'Stratimikos::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'Stratimikos'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'Stratimikos_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
