-- mod-version:3
local syntax = require 'core.syntax'

syntax.add {
	name = "MiniScript",
	files = { "%.ms$" },
	comment = "//",
	patterns = {
		{ pattern = "//.*",                type = "comment"  },
		{ pattern = { '"', '"' },          type = "string"   },
		{ pattern = "[<>!=]=",             type = "operator" },
		{ pattern = "[%+%-%*%/%^@<>:]",    type = "operator" },
		{ pattern = "%d%.%d*[eE][-+]?%d+", type = "number"   },
		{ pattern = "%d%.%d*",             type = "number"   },
		{ pattern = "%.?%d*[eE][-+]?%d+",  type = "number"   },
		{ pattern = "%.?%d+",              type = "number"   },
		{ pattern = "[%a_][%w_]*",         type = "symbol"   },
	},
	symbols = {
		["if"]       = "keyword",
		["not"]      = "keyword",
		["and"]      = "keyword",
		["or"]       = "keyword",
		["else"]     = "keyword",
		["then"]     = "keyword",
		["for"]      = "keyword",
		["in"]       = "keyword",
		["while"]    = "keyword",
		["break"]    = "keyword",
		["continue"] = "keyword",
		["function"] = "keyword",
		["end"]      = "keyword",
		["return"]   = "keyword",
		["new"]      = "keyword",
		["isa"]      = "keyword",
		["self"]     = "keyword2",

		["true"]    = "literal",
		["false"]   = "literal",
		["null"]    = "literal",
		["globals"] = "literal",
		["locals"]  = "literal",
		["outer"]   = "literal",

		-- Built-in types's classes
		["number"]  = "literal",
		["string"]  = "literal",
		["list"]    = "literal",
		["map"]     = "literal",
		["funcRef"] = "literal",

		-- Intrinsic functions
		["abs"]      = "function",
		["acos"]     = "function",
		["asin"]     = "function",
		["atan"]     = "function",
		["bitAnd"]   = "function",
		["bitOr"]    = "function",
		["bitXor"]   = "function",
		["ceil"]     = "function",
		["char"]     = "function",
		["code"]     = "function",
		["cos"]      = "function",
		["floor"]    = "function",
		["hash"]     = "function",
		["hasIndex"] = "function",
		["indexes"]  = "function",
		["indexOf"]  = "function",
		["insert"]   = "function",
		["join"]     = "function",
		["len"]      = "function",
		["log"]      = "function",
		["lower"]    = "function",
		["pi"]       = "function",
		["pop"]      = "function",
		["print"]    = "function",
		["pull"]     = "function",
		["push"]     = "function",
		["range"]    = "function",
		["remove"]   = "function",
		["replace"]  = "function",
		["rnd"]      = "function",
		["round"]    = "function",
		["shuffle"]  = "function",
		["sign"]     = "function",
		["sin"]      = "function",
		["slice"]    = "function",
		["sort"]     = "function",
		["split"]    = "function",
		["sqrt"]     = "function",
		["str"]      = "function",
		["sum"]      = "function",
		["tan"]      = "function",
		["time"]     = "function",
		["upper"]    = "function",
		["val"]      = "function",
		["values"]   = "function",
		["version"]  = "function",
		["wait"]     = "function",
		["yield"]    = "function",
	},
}
