%feature("docstring") OT::BurrFactory
"Burr factory.

Notes
-----
The parameter :math:`\\Hat{c}_n` is the solution of the following non linear equation:

.. math::

    \\displaystyle 1+\\frac{c}{n}\\left[ SR - \\frac{n}{\\sum_{i=1}^n \\log(1+x_i^c)}SSR\\right] = 0

where :math:`\\displaystyle SR = \\displaystyle \\sum_{i=1}^n \\frac{ \\log(x_i)}{1+x_i^c}`
and :math:`\\displaystyle SSR = \\displaystyle \\sum_{i=1}^n \\frac{ x_i^c\\log(x_i)}{1+x_i^c}`

The resolution of this equation can be tuned through
`BurrFactory-RelativePrecision`, `BurrFactory-ResidualPrecision`,
`BurrFactory-MaximumIteration` in :class:`~openturns.ResourceMap`

Then

.. math::

    \\Hat{k}_n =  \\frac{n}{\\sum_{i=1}^n \\log(1+x_i^c)}

See also
--------
DistributionFactory, Burr"

// ---------------------------------------------------------------------

%feature("docstring") OT::BurrFactory::buildAsBurr
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsBurr()

    buildAsBurr(*sample*)

    buildAsBurr(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : sequence of float
    The parameters of the :class:`~openturns.Burr`.

Returns
-------
dist : :class:`~openturns.Burr`
    The estimated distribution as a Burr.
    
    In the first usage, the default Burr distribution is built."

