﻿!mod$ v1 sum:29ae0680a77ae0b3
module gridxc_interpolation
use gridxc_sys,only:die
private::die
integer(4),parameter,private::dp=8_4
intrinsic::selected_real_kind
private::selected_real_kind
type::spline_t
character(3_4,1),private::mesh
real(8),private::xmin
real(8),private::xmax
real(8),private::x1
real(8),private::dx
real(8),private::a
real(8),private::b
integer(4),private::n
real(8),allocatable,private::x(:)
real(8),allocatable,private::y(:)
real(8),allocatable,private::d2ydx2(:)
end type
real(8),parameter,private::dydxmax=9.90000000000000022500528357376e29_8
real(8),parameter,private::tol=9.99999999999999954748111825886258685613938723690807819366455078125e-7_8
private::generate_spline_master
private::find_interval
private::interpolate_interval
private::evaluate_spline_n
private::generate_spline_x
private::generate_spline_dx
private::evaluate_spline_x
private::evaluate_spline_dx
interface generate_spline
procedure::generate_spline_master
procedure::generate_spline_x
procedure::generate_spline_dx
end interface
interface evaluate_spline
procedure::evaluate_spline
procedure::evaluate_spline_n
procedure::evaluate_spline_x
procedure::evaluate_spline_dx
end interface
interface spline
procedure::generate_spline_x
procedure::generate_spline_dx
end interface
interface splint
procedure::evaluate_spline_x
procedure::evaluate_spline_dx
end interface
contains
subroutine generate_spline_master(dat,x,y,n,dydx1,dydxn,d2ydx2,store,stat)
type(spline_t),intent(out)::dat
integer(4),intent(in)::n
real(8),intent(in)::x(1_8:int(n,kind=8))
real(8),intent(in)::y(1_8:int(n,kind=8))
real(8),intent(in),optional::dydx1
real(8),intent(in),optional::dydxn
real(8),intent(out),optional::d2ydx2(1_8:int(n,kind=8))
logical(4),intent(in),optional::store
integer(4),intent(out),optional::stat
end
subroutine evaluate_spline(dat,x,y,dydx)
type(spline_t),intent(in)::dat
real(8),intent(in)::x
real(8),intent(out)::y
real(8),intent(out),optional::dydx
end
subroutine find_interval(dat,xi,x,kl,kh,xl,xh)
type(spline_t),intent(in)::dat
real(8),intent(in)::xi(:)
real(8),intent(in)::x
integer(4),intent(out)::kl
integer(4),intent(out)::kh
real(8),intent(out)::xl
real(8),intent(out)::xh
end
subroutine interpolate_interval(xl,xh,yl,yh,d2ydx2l,d2ydx2h,x,y,dydx)
real(8),intent(in)::xl
real(8),intent(in)::xh
real(8),intent(in)::yl
real(8),intent(in)::yh
real(8),intent(in)::d2ydx2l
real(8),intent(in)::d2ydx2h
real(8),intent(in)::x
real(8),intent(out)::y
real(8),intent(out),optional::dydx
end
subroutine evaluate_spline_n(dat,x,y,dydx)
type(spline_t),intent(in)::dat
real(8),intent(in)::x(:)
real(8),intent(out)::y(:)
real(8),intent(out),optional::dydx(:)
end
subroutine generate_spline_x(x,y,n,dydx1,dydxn,d2ydx2)
integer(4),intent(in)::n
real(8),intent(in)::x(1_8:int(n,kind=8))
real(8),intent(in)::y(1_8:int(n,kind=8))
real(8),intent(in)::dydx1
real(8),intent(in)::dydxn
real(8),intent(out)::d2ydx2(1_8:int(n,kind=8))
end
subroutine generate_spline_dx(dx,y,n,dydx1,dydxn,d2ydx2)
real(8),intent(in)::dx
integer(4),intent(in)::n
real(8),intent(in)::y(1_8:int(n,kind=8))
real(8),intent(in)::dydx1
real(8),intent(in)::dydxn
real(8),intent(out)::d2ydx2(1_8:int(n,kind=8))
end
subroutine evaluate_spline_x(xi,yi,d2ydx2,n,x,y,dydx)
integer(4),intent(in)::n
real(8),intent(in)::xi(1_8:int(n,kind=8))
real(8),intent(in)::yi(1_8:int(n,kind=8))
real(8),intent(in)::d2ydx2(1_8:int(n,kind=8))
real(8),intent(in)::x
real(8),intent(out)::y
real(8),intent(out),optional::dydx
end
subroutine evaluate_spline_dx(dx,yi,d2ydx2,n,x,y,dydx)
real(8),intent(in)::dx
integer(4),intent(in)::n
real(8),intent(in)::yi(1_8:int(n,kind=8))
real(8),intent(in)::d2ydx2(1_8:int(n,kind=8))
real(8),intent(in)::x
real(8),intent(out)::y
real(8),intent(out),optional::dydx
end
subroutine polint(xi,yi,n,x,y,dydx)
real(8),intent(in)::xi(1_8:*)
real(8),intent(in)::yi(1_8:*)
integer(4),intent(in)::n
real(8),intent(in)::x
real(8),intent(out)::y
real(8),intent(out)::dydx
end
subroutine clean_spline(dat)
type(spline_t),intent(inout)::dat
end
end
