
#ifndef KUNITCONVERSION_EXPORT_H
#define KUNITCONVERSION_EXPORT_H

#ifdef KUNITCONVERSION_STATIC_DEFINE
#  define KUNITCONVERSION_EXPORT
#  define KUNITCONVERSION_NO_EXPORT
#else
#  ifndef KUNITCONVERSION_EXPORT
#    ifdef KF6UnitConversion_EXPORTS
        /* We are building this library */
#      define KUNITCONVERSION_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KUNITCONVERSION_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KUNITCONVERSION_NO_EXPORT
#    define KUNITCONVERSION_NO_EXPORT 
#  endif
#endif

#ifndef KUNITCONVERSION_DECL_DEPRECATED
#  define KUNITCONVERSION_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KUNITCONVERSION_DECL_DEPRECATED_EXPORT
#  define KUNITCONVERSION_DECL_DEPRECATED_EXPORT KUNITCONVERSION_EXPORT KUNITCONVERSION_DECL_DEPRECATED
#endif

#ifndef KUNITCONVERSION_DECL_DEPRECATED_NO_EXPORT
#  define KUNITCONVERSION_DECL_DEPRECATED_NO_EXPORT KUNITCONVERSION_NO_EXPORT KUNITCONVERSION_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KUNITCONVERSION_NO_DEPRECATED
#    define KUNITCONVERSION_NO_DEPRECATED
#  endif
#endif
#include <kunitconversion_version.h>

#define KUNITCONVERSION_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KUNITCONVERSION_NO_DEPRECATED) && !defined(KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KUNITCONVERSION_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KUNITCONVERSION_NO_DEPRECATED_WARNINGS) && !defined(KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KUNITCONVERSION_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KUNITCONVERSION_NO_DEPRECATED)
#  undef KUNITCONVERSION_DEPRECATED
#  define KUNITCONVERSION_DEPRECATED_EXPORT KUNITCONVERSION_EXPORT
#  define KUNITCONVERSION_DEPRECATED_NO_EXPORT KUNITCONVERSION_NO_EXPORT
#elif defined(KUNITCONVERSION_NO_DEPRECATED_WARNINGS)
#  define KUNITCONVERSION_DEPRECATED
#  define KUNITCONVERSION_DEPRECATED_EXPORT KUNITCONVERSION_EXPORT
#  define KUNITCONVERSION_DEPRECATED_NO_EXPORT KUNITCONVERSION_NO_EXPORT
#else
#  define KUNITCONVERSION_DEPRECATED KUNITCONVERSION_DECL_DEPRECATED
#  define KUNITCONVERSION_DEPRECATED_EXPORT KUNITCONVERSION_DECL_DEPRECATED_EXPORT
#  define KUNITCONVERSION_DEPRECATED_NO_EXPORT KUNITCONVERSION_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KUNITCONVERSION_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KUNITCONVERSION_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KUNITCONVERSION_NO_DEPRECATED
#  define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT KUNITCONVERSION_VERSION
#endif
#ifdef KUNITCONVERSION_NO_DEPRECATED_WARNINGS
#  define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE
#  ifdef KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KUNITCONVERSION_VERSION
#  endif
#endif

#ifndef KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KUNITCONVERSION_DEPRECATED
#  define KUNITCONVERSION_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KUNITCONVERSION_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KUNITCONVERSION_EXPORT_H */
