/**************************************************************************/
/*  animation_node_extension.hpp                                          */
/**************************************************************************/
/*                         This file is part of:                          */
/*                             GODOT ENGINE                               */
/*                        https://godotengine.org                         */
/**************************************************************************/
/* Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md). */
/* Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.                  */
/*                                                                        */
/* Permission is hereby granted, free of charge, to any person obtaining  */
/* a copy of this software and associated documentation files (the        */
/* "Software"), to deal in the Software without restriction, including    */
/* without limitation the rights to use, copy, modify, merge, publish,    */
/* distribute, sublicense, and/or sell copies of the Software, and to     */
/* permit persons to whom the Software is furnished to do so, subject to  */
/* the following conditions:                                              */
/*                                                                        */
/* The above copyright notice and this permission notice shall be         */
/* included in all copies or substantial portions of the Software.        */
/*                                                                        */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. */
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY   */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,   */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE      */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                 */
/**************************************************************************/

// THIS FILE IS GENERATED. EDITS WILL BE LOST.

#ifndef GODOT_CPP_ANIMATION_NODE_EXTENSION_HPP
#define GODOT_CPP_ANIMATION_NODE_EXTENSION_HPP

#include <godot_cpp/classes/animation_node.hpp>
#include <godot_cpp/classes/ref.hpp>
#include <godot_cpp/variant/packed_float32_array.hpp>

#include <godot_cpp/core/class_db.hpp>

#include <type_traits>

namespace godot {

class PackedFloat64Array;

class AnimationNodeExtension : public AnimationNode {
	GDEXTENSION_CLASS(AnimationNodeExtension, AnimationNode)

public:
	static bool is_looping(const PackedFloat32Array &p_node_info);
	static double get_remaining_time(const PackedFloat32Array &p_node_info, bool p_break_loop);
	virtual PackedFloat32Array _process_animation_node(const PackedFloat64Array &p_playback_info, bool p_test_only);

protected:
	template <typename T, typename B>
	static void register_virtuals() {
		AnimationNode::register_virtuals<T, B>();
		if constexpr (!std::is_same_v<decltype(&B::_process_animation_node), decltype(&T::_process_animation_node)>) {
			BIND_VIRTUAL_METHOD(T, _process_animation_node, 912931771);
		}
	}

public:
};

} // namespace godot

#endif // ! GODOT_CPP_ANIMATION_NODE_EXTENSION_HPP
