
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was DirectXMesh-config.cmake.in                            ########

get_filename_component(PACKAGE_${CMAKE_FIND_PACKAGE_NAME}_COUNTER_1 "${CMAKE_CURRENT_LIST_DIR}/../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

if ((NOT directxmesh_FIND_COMPONENTS) OR ("library" IN_LIST directxmesh_FIND_COMPONENTS))
  include(${CMAKE_CURRENT_LIST_DIR}/DirectXMesh-targets.cmake)
endif()

if ("utils" IN_LIST directxmesh_FIND_COMPONENTS)
  include(${CMAKE_CURRENT_LIST_DIR}/Utilities-targets.cmake)
endif()

include(CMakeFindDependencyMacro)

if(MINGW OR (NOT WIN32))
    find_dependency(directx-headers)
    find_dependency(directxmath)
else()
    find_package(directx-headers CONFIG QUIET)
    find_package(directxmath CONFIG QUIET)
endif()

check_required_components("DirectXMesh")
