// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_UI_Xaml_H
#define WINRT_Windows_UI_Xaml_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.UI.h"
#include "winrt/impl/Windows.ApplicationModel.2.h"
#include "winrt/impl/Windows.ApplicationModel.Activation.2.h"
#include "winrt/impl/Windows.ApplicationModel.Core.2.h"
#include "winrt/impl/Windows.ApplicationModel.DataTransfer.2.h"
#include "winrt/impl/Windows.ApplicationModel.DataTransfer.DragDrop.2.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Foundation.Numerics.2.h"
#include "winrt/impl/Windows.Graphics.Imaging.2.h"
#include "winrt/impl/Windows.UI.2.h"
#include "winrt/impl/Windows.UI.Composition.2.h"
#include "winrt/impl/Windows.UI.Core.2.h"
#include "winrt/impl/Windows.UI.Input.2.h"
#include "winrt/impl/Windows.UI.Xaml.Automation.Peers.2.h"
#include "winrt/impl/Windows.UI.Xaml.Controls.2.h"
#include "winrt/impl/Windows.UI.Xaml.Controls.Primitives.2.h"
#include "winrt/impl/Windows.UI.Xaml.Data.2.h"
#include "winrt/impl/Windows.UI.Xaml.Input.2.h"
#include "winrt/impl/Windows.UI.Xaml.Interop.2.h"
#include "winrt/impl/Windows.UI.Xaml.Media.2.h"
#include "winrt/impl/Windows.UI.Xaml.Media.Animation.2.h"
#include "winrt/impl/Windows.UI.Xaml.Media.Imaging.2.h"
#include "winrt/impl/Windows.UI.Xaml.Media.Media3D.2.h"
#include "winrt/impl/Windows.UI.Xaml.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_UI_Xaml_IAdaptiveTrigger<D>::MinWindowWidth() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IAdaptiveTrigger>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IAdaptiveTrigger, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTrigger>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinWindowWidth(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTrigger>**)this;
            check_hresult(_winrt_abi_type->get_MinWindowWidth(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IAdaptiveTrigger<D>::MinWindowWidth(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IAdaptiveTrigger>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IAdaptiveTrigger, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTrigger>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MinWindowWidth(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTrigger>**)this;
            check_hresult(_winrt_abi_type->put_MinWindowWidth(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IAdaptiveTrigger<D>::MinWindowHeight() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IAdaptiveTrigger>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IAdaptiveTrigger, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTrigger>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinWindowHeight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTrigger>**)this;
            check_hresult(_winrt_abi_type->get_MinWindowHeight(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IAdaptiveTrigger<D>::MinWindowHeight(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IAdaptiveTrigger>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IAdaptiveTrigger, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTrigger>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MinWindowHeight(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTrigger>**)this;
            check_hresult(_winrt_abi_type->put_MinWindowHeight(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IAdaptiveTriggerFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IAdaptiveTriggerFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IAdaptiveTriggerFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTriggerFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTriggerFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::AdaptiveTrigger{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IAdaptiveTriggerStatics<D>::MinWindowWidthProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinWindowWidthProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics>**)this;
            check_hresult(_winrt_abi_type->get_MinWindowWidthProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IAdaptiveTriggerStatics<D>::MinWindowHeightProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinWindowHeightProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics>**)this;
            check_hresult(_winrt_abi_type->get_MinWindowHeightProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::Resources() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Resources(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            check_hresult(_winrt_abi_type->get_Resources(&value));
        }
        return winrt::Windows::UI::Xaml::ResourceDictionary{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::Resources(winrt::Windows::UI::Xaml::ResourceDictionary const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Resources(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            check_hresult(_winrt_abi_type->put_Resources(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::DebugSettings() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DebugSettings(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            check_hresult(_winrt_abi_type->get_DebugSettings(&value));
        }
        return winrt::Windows::UI::Xaml::DebugSettings{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::RequestedTheme() const
    {
        winrt::Windows::UI::Xaml::ApplicationTheme value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RequestedTheme(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            check_hresult(_winrt_abi_type->get_RequestedTheme(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::RequestedTheme(winrt::Windows::UI::Xaml::ApplicationTheme const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RequestedTheme(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            check_hresult(_winrt_abi_type->put_RequestedTheme(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::UnhandledException(winrt::Windows::UI::Xaml::UnhandledExceptionEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_UnhandledException(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            check_hresult(_winrt_abi_type->add_UnhandledException(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::UnhandledException(auto_revoke_t, winrt::Windows::UI::Xaml::UnhandledExceptionEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, UnhandledException_revoker>(this, UnhandledException(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::UnhandledException(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            _winrt_abi_type->remove_UnhandledException(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            _winrt_abi_type->remove_UnhandledException(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::Suspending(winrt::Windows::UI::Xaml::SuspendingEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Suspending(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            check_hresult(_winrt_abi_type->add_Suspending(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::Suspending(auto_revoke_t, winrt::Windows::UI::Xaml::SuspendingEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, Suspending_revoker>(this, Suspending(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::Suspending(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Suspending(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            _winrt_abi_type->remove_Suspending(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::Resuming(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Resuming(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            check_hresult(_winrt_abi_type->add_Resuming(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::Resuming(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, Resuming_revoker>(this, Resuming(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::Resuming(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Resuming(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            _winrt_abi_type->remove_Resuming(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication<D>::Exit() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Exit());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication>**)this;
            check_hresult(_winrt_abi_type->Exit());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::FocusVisualKind() const
    {
        winrt::Windows::UI::Xaml::FocusVisualKind value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualKind(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualKind(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::FocusVisualKind(winrt::Windows::UI::Xaml::FocusVisualKind const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FocusVisualKind(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)this;
            check_hresult(_winrt_abi_type->put_FocusVisualKind(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::RequiresPointerMode() const
    {
        winrt::Windows::UI::Xaml::ApplicationRequiresPointerMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RequiresPointerMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)this;
            check_hresult(_winrt_abi_type->get_RequiresPointerMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::RequiresPointerMode(winrt::Windows::UI::Xaml::ApplicationRequiresPointerMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RequiresPointerMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)this;
            check_hresult(_winrt_abi_type->put_RequiresPointerMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::LeavingBackground(winrt::Windows::UI::Xaml::LeavingBackgroundEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_LeavingBackground(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)this;
            check_hresult(_winrt_abi_type->add_LeavingBackground(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::LeavingBackground(auto_revoke_t, winrt::Windows::UI::Xaml::LeavingBackgroundEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, LeavingBackground_revoker>(this, LeavingBackground(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::LeavingBackground(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_LeavingBackground(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)this;
            _winrt_abi_type->remove_LeavingBackground(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::EnteredBackground(winrt::Windows::UI::Xaml::EnteredBackgroundEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_EnteredBackground(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)this;
            check_hresult(_winrt_abi_type->add_EnteredBackground(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::EnteredBackground(auto_revoke_t, winrt::Windows::UI::Xaml::EnteredBackgroundEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, EnteredBackground_revoker>(this, EnteredBackground(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication2<D>::EnteredBackground(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_EnteredBackground(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication2>**)this;
            _winrt_abi_type->remove_EnteredBackground(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication3<D>::HighContrastAdjustment() const
    {
        winrt::Windows::UI::Xaml::ApplicationHighContrastAdjustment value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HighContrastAdjustment(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication3>**)this;
            check_hresult(_winrt_abi_type->get_HighContrastAdjustment(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplication3<D>::HighContrastAdjustment(winrt::Windows::UI::Xaml::ApplicationHighContrastAdjustment const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplication3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplication3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HighContrastAdjustment(static_cast<uint32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplication3>**)this;
            check_hresult(_winrt_abi_type->put_HighContrastAdjustment(static_cast<uint32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::Application{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides<D>::OnActivated(winrt::Windows::ApplicationModel::Activation::IActivatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnActivated(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)this;
            check_hresult(_winrt_abi_type->OnActivated(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides<D>::OnLaunched(winrt::Windows::ApplicationModel::Activation::LaunchActivatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnLaunched(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)this;
            check_hresult(_winrt_abi_type->OnLaunched(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides<D>::OnFileActivated(winrt::Windows::ApplicationModel::Activation::FileActivatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnFileActivated(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)this;
            check_hresult(_winrt_abi_type->OnFileActivated(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides<D>::OnSearchActivated(winrt::Windows::ApplicationModel::Activation::SearchActivatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnSearchActivated(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)this;
            check_hresult(_winrt_abi_type->OnSearchActivated(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides<D>::OnShareTargetActivated(winrt::Windows::ApplicationModel::Activation::ShareTargetActivatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnShareTargetActivated(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)this;
            check_hresult(_winrt_abi_type->OnShareTargetActivated(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides<D>::OnFileOpenPickerActivated(winrt::Windows::ApplicationModel::Activation::FileOpenPickerActivatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnFileOpenPickerActivated(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)this;
            check_hresult(_winrt_abi_type->OnFileOpenPickerActivated(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides<D>::OnFileSavePickerActivated(winrt::Windows::ApplicationModel::Activation::FileSavePickerActivatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnFileSavePickerActivated(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)this;
            check_hresult(_winrt_abi_type->OnFileSavePickerActivated(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides<D>::OnCachedFileUpdaterActivated(winrt::Windows::ApplicationModel::Activation::CachedFileUpdaterActivatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnCachedFileUpdaterActivated(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)this;
            check_hresult(_winrt_abi_type->OnCachedFileUpdaterActivated(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides<D>::OnWindowCreated(winrt::Windows::UI::Xaml::WindowCreatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnWindowCreated(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides>**)this;
            check_hresult(_winrt_abi_type->OnWindowCreated(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationOverrides2<D>::OnBackgroundActivated(winrt::Windows::ApplicationModel::Activation::BackgroundActivatedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationOverrides2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationOverrides2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnBackgroundActivated(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationOverrides2>**)this;
            check_hresult(_winrt_abi_type->OnBackgroundActivated(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationStatics<D>::Current() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Current(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationStatics>**)this;
            check_hresult(_winrt_abi_type->get_Current(&value));
        }
        return winrt::Windows::UI::Xaml::Application{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationStatics<D>::Start(winrt::Windows::UI::Xaml::ApplicationInitializationCallback const& callback) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Start(*(void**)(&callback)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationStatics>**)this;
            check_hresult(_winrt_abi_type->Start(*(void**)(&callback)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationStatics<D>::LoadComponent(winrt::Windows::Foundation::IInspectable const& component, winrt::Windows::Foundation::Uri const& resourceLocator) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LoadComponent(*(void**)(&component), *(void**)(&resourceLocator)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationStatics>**)this;
            check_hresult(_winrt_abi_type->LoadComponent(*(void**)(&component), *(void**)(&resourceLocator)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IApplicationStatics<D>::LoadComponent(winrt::Windows::Foundation::IInspectable const& component, winrt::Windows::Foundation::Uri const& resourceLocator, winrt::Windows::UI::Xaml::Controls::Primitives::ComponentResourceLocation const& componentResourceLocation) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IApplicationStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IApplicationStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LoadComponentWithResourceLocation(*(void**)(&component), *(void**)(&resourceLocator), static_cast<int32_t>(componentResourceLocation)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IApplicationStatics>**)this;
            check_hresult(_winrt_abi_type->LoadComponentWithResourceLocation(*(void**)(&component), *(void**)(&resourceLocator), static_cast<int32_t>(componentResourceLocation)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBindingFailedEventArgs<D>::Message() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBindingFailedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBindingFailedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBindingFailedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBindingFailedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions<D>::AnimationDesired() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AnimationDesired(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions>**)this;
            check_hresult(_winrt_abi_type->get_AnimationDesired(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions<D>::AnimationDesired(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AnimationDesired(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions>**)this;
            check_hresult(_winrt_abi_type->put_AnimationDesired(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions<D>::TargetRect() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TargetRect(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions>**)this;
            check_hresult(_winrt_abi_type->get_TargetRect(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Rect>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions<D>::TargetRect(winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Rect> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TargetRect(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions>**)this;
            check_hresult(_winrt_abi_type->put_TargetRect(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions2<D>::HorizontalAlignmentRatio() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions2<D>::HorizontalAlignmentRatio(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HorizontalAlignmentRatio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)this;
            check_hresult(_winrt_abi_type->put_HorizontalAlignmentRatio(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions2<D>::VerticalAlignmentRatio() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)this;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions2<D>::VerticalAlignmentRatio(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_VerticalAlignmentRatio(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)this;
            check_hresult(_winrt_abi_type->put_VerticalAlignmentRatio(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions2<D>::HorizontalOffset() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalOffset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalOffset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions2<D>::HorizontalOffset(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HorizontalOffset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)this;
            check_hresult(_winrt_abi_type->put_HorizontalOffset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions2<D>::VerticalOffset() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VerticalOffset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)this;
            check_hresult(_winrt_abi_type->get_VerticalOffset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewOptions2<D>::VerticalOffset(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_VerticalOffset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewOptions2>**)this;
            check_hresult(_winrt_abi_type->put_VerticalOffset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::TargetElement() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TargetElement(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_TargetElement(&value));
        }
        return winrt::Windows::UI::Xaml::UIElement{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::TargetElement(winrt::Windows::UI::Xaml::UIElement const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TargetElement(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_TargetElement(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::AnimationDesired() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AnimationDesired(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AnimationDesired(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::AnimationDesired(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AnimationDesired(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_AnimationDesired(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::TargetRect() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TargetRect(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_TargetRect(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::TargetRect(winrt::Windows::Foundation::Rect const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TargetRect(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_TargetRect(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::HorizontalAlignmentRatio() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::VerticalAlignmentRatio() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentRatio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentRatio(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::HorizontalOffset() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalOffset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalOffset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::HorizontalOffset(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HorizontalOffset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_HorizontalOffset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::VerticalOffset() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VerticalOffset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_VerticalOffset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::VerticalOffset(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_VerticalOffset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_VerticalOffset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::Handled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Handled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Handled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBringIntoViewRequestedEventArgs<D>::Handled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Handled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_Handled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBrushTransition<D>::Duration() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBrushTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBrushTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBrushTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBrushTransition>**)this;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBrushTransition<D>::Duration(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBrushTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBrushTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBrushTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Duration(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBrushTransition>**)this;
            check_hresult(_winrt_abi_type->put_Duration(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IBrushTransitionFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IBrushTransitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IBrushTransitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBrushTransitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IBrushTransitionFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::BrushTransition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltHigh() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AltHigh(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_AltHigh(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltHigh(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AltHigh(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_AltHigh(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AltLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_AltLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AltLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_AltLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltMedium() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AltMedium(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_AltMedium(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltMedium(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AltMedium(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_AltMedium(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltMediumHigh() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AltMediumHigh(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_AltMediumHigh(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltMediumHigh(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AltMediumHigh(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_AltMediumHigh(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltMediumLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AltMediumLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_AltMediumLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::AltMediumLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AltMediumLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_AltMediumLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseHigh() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BaseHigh(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_BaseHigh(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseHigh(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BaseHigh(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_BaseHigh(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BaseLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_BaseLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BaseLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_BaseLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseMedium() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BaseMedium(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_BaseMedium(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseMedium(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BaseMedium(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_BaseMedium(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseMediumHigh() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BaseMediumHigh(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_BaseMediumHigh(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseMediumHigh(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BaseMediumHigh(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_BaseMediumHigh(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseMediumLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BaseMediumLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_BaseMediumLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::BaseMediumLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BaseMediumLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_BaseMediumLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeAltLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeAltLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeAltLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeAltLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeAltLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeAltLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeBlackHigh() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeBlackHigh(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeBlackHigh(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeBlackHigh(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeBlackHigh(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeBlackHigh(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeBlackLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeBlackLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeBlackLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeBlackLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeBlackLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeBlackLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeBlackMediumLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeBlackMediumLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeBlackMediumLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeBlackMediumLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeBlackMediumLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeBlackMediumLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeBlackMedium() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeBlackMedium(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeBlackMedium(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeBlackMedium(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeBlackMedium(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeBlackMedium(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeDisabledHigh() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeDisabledHigh(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeDisabledHigh(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeDisabledHigh(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeDisabledHigh(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeDisabledHigh(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeDisabledLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeDisabledLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeDisabledLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeDisabledLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeDisabledLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeDisabledLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeHigh() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeHigh(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeHigh(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeHigh(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeHigh(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeHigh(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeMedium() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeMedium(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeMedium(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeMedium(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeMedium(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeMedium(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeMediumLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeMediumLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeMediumLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeMediumLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeMediumLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeMediumLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeWhite() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeWhite(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeWhite(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeWhite(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeWhite(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeWhite(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeGray() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChromeGray(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ChromeGray(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ChromeGray(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChromeGray(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ChromeGray(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ListLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ListLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ListLow(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ListLow(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ListLow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ListLow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ListMedium() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ListMedium(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ListMedium(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ListMedium(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ListMedium(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ListMedium(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ErrorText() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ErrorText(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_ErrorText(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::ErrorText(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ErrorText(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_ErrorText(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::Accent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Accent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->get_Accent(&value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResources<D>::Accent(winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResources>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResources, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Accent(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResources>**)this;
            check_hresult(_winrt_abi_type->put_Accent(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IColorPaletteResourcesFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IColorPaletteResourcesFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IColorPaletteResourcesFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResourcesFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IColorPaletteResourcesFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::ColorPaletteResources{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_ICornerRadiusHelperStatics<D>::FromRadii(double topLeft, double topRight, double bottomRight, double bottomLeft) const
    {
        winrt::Windows::UI::Xaml::CornerRadius result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromRadii(topLeft, topRight, bottomRight, bottomLeft, put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromRadii(topLeft, topRight, bottomRight, bottomLeft, put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_ICornerRadiusHelperStatics<D>::FromUniformRadius(double uniformRadius) const
    {
        winrt::Windows::UI::Xaml::CornerRadius result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromUniformRadius(uniformRadius, put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromUniformRadius(uniformRadius, put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataContextChangedEventArgs<D>::NewValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataContextChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_NewValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_NewValue(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataContextChangedEventArgs<D>::Handled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataContextChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Handled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Handled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataContextChangedEventArgs<D>::Handled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataContextChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Handled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_Handled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplate<D>::LoadContent() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplate>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplate, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplate>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LoadContent(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplate>**)this;
            check_hresult(_winrt_abi_type->LoadContent(&result));
        }
        return winrt::Windows::UI::Xaml::DependencyObject{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateExtension<D>::ResetTemplate() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ResetTemplate());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateExtension>**)this;
            check_hresult(_winrt_abi_type->ResetTemplate());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateExtension<D>::ProcessBinding(uint32_t phase) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ProcessBinding(phase, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateExtension>**)this;
            check_hresult(_winrt_abi_type->ProcessBinding(phase, &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateExtension<D>::ProcessBindings(winrt::Windows::UI::Xaml::Controls::ContainerContentChangingEventArgs const& arg) const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ProcessBindings(*(void**)(&arg), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateExtension>**)this;
            check_hresult(_winrt_abi_type->ProcessBindings(*(void**)(&arg), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::DataTemplate{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateKey<D>::DataType() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateKey>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateKey, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateKey>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DataType(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateKey>**)this;
            check_hresult(_winrt_abi_type->get_DataType(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateKey<D>::DataType(winrt::Windows::Foundation::IInspectable const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateKey>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateKey, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateKey>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DataType(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateKey>**)this;
            check_hresult(_winrt_abi_type->put_DataType(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateKeyFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateKeyFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateKeyFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateKeyFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateKeyFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::DataTemplateKey{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateKeyFactory<D>::CreateInstanceWithType(winrt::Windows::Foundation::IInspectable const& dataType, winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateKeyFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateKeyFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateKeyFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstanceWithType(*(void**)(&dataType), *(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateKeyFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstanceWithType(*(void**)(&dataType), *(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::DataTemplateKey{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateStatics2<D>::ExtensionInstanceProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtensionInstanceProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateStatics2>**)this;
            check_hresult(_winrt_abi_type->get_ExtensionInstanceProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateStatics2<D>::GetExtensionInstance(winrt::Windows::UI::Xaml::FrameworkElement const& element) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetExtensionInstance(*(void**)(&element), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateStatics2>**)this;
            check_hresult(_winrt_abi_type->GetExtensionInstance(*(void**)(&element), &result));
        }
        return winrt::Windows::UI::Xaml::IDataTemplateExtension{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDataTemplateStatics2<D>::SetExtensionInstance(winrt::Windows::UI::Xaml::FrameworkElement const& element, winrt::Windows::UI::Xaml::IDataTemplateExtension const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDataTemplateStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDataTemplateStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetExtensionInstance(*(void**)(&element), *(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDataTemplateStatics2>**)this;
            check_hresult(_winrt_abi_type->SetExtensionInstance(*(void**)(&element), *(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings<D>::EnableFrameRateCounter() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EnableFrameRateCounter(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)this;
            check_hresult(_winrt_abi_type->get_EnableFrameRateCounter(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings<D>::EnableFrameRateCounter(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_EnableFrameRateCounter(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)this;
            check_hresult(_winrt_abi_type->put_EnableFrameRateCounter(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings<D>::IsBindingTracingEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsBindingTracingEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)this;
            check_hresult(_winrt_abi_type->get_IsBindingTracingEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings<D>::IsBindingTracingEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsBindingTracingEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)this;
            check_hresult(_winrt_abi_type->put_IsBindingTracingEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings<D>::IsOverdrawHeatMapEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsOverdrawHeatMapEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)this;
            check_hresult(_winrt_abi_type->get_IsOverdrawHeatMapEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings<D>::IsOverdrawHeatMapEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsOverdrawHeatMapEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)this;
            check_hresult(_winrt_abi_type->put_IsOverdrawHeatMapEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings<D>::BindingFailed(winrt::Windows::UI::Xaml::BindingFailedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_BindingFailed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)this;
            check_hresult(_winrt_abi_type->add_BindingFailed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings<D>::BindingFailed(auto_revoke_t, winrt::Windows::UI::Xaml::BindingFailedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, BindingFailed_revoker>(this, BindingFailed(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings<D>::BindingFailed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)&_winrt_casted_result;
            _winrt_abi_type->remove_BindingFailed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings>**)this;
            _winrt_abi_type->remove_BindingFailed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings2<D>::EnableRedrawRegions() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EnableRedrawRegions(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings2>**)this;
            check_hresult(_winrt_abi_type->get_EnableRedrawRegions(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings2<D>::EnableRedrawRegions(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_EnableRedrawRegions(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings2>**)this;
            check_hresult(_winrt_abi_type->put_EnableRedrawRegions(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings3<D>::IsTextPerformanceVisualizationEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTextPerformanceVisualizationEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings3>**)this;
            check_hresult(_winrt_abi_type->get_IsTextPerformanceVisualizationEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings3<D>::IsTextPerformanceVisualizationEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsTextPerformanceVisualizationEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings3>**)this;
            check_hresult(_winrt_abi_type->put_IsTextPerformanceVisualizationEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings4<D>::FailFastOnErrors() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FailFastOnErrors(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings4>**)this;
            check_hresult(_winrt_abi_type->get_FailFastOnErrors(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDebugSettings4<D>::FailFastOnErrors(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDebugSettings4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDebugSettings4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FailFastOnErrors(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDebugSettings4>**)this;
            check_hresult(_winrt_abi_type->put_FailFastOnErrors(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObject<D>::GetValue(winrt::Windows::UI::Xaml::DependencyProperty const& dp) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetValue(*(void**)(&dp), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)this;
            check_hresult(_winrt_abi_type->GetValue(*(void**)(&dp), &result));
        }
        return winrt::Windows::Foundation::IInspectable{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObject<D>::SetValue(winrt::Windows::UI::Xaml::DependencyProperty const& dp, winrt::Windows::Foundation::IInspectable const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetValue(*(void**)(&dp), *(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)this;
            check_hresult(_winrt_abi_type->SetValue(*(void**)(&dp), *(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObject<D>::ClearValue(winrt::Windows::UI::Xaml::DependencyProperty const& dp) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClearValue(*(void**)(&dp)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)this;
            check_hresult(_winrt_abi_type->ClearValue(*(void**)(&dp)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObject<D>::ReadLocalValue(winrt::Windows::UI::Xaml::DependencyProperty const& dp) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadLocalValue(*(void**)(&dp), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)this;
            check_hresult(_winrt_abi_type->ReadLocalValue(*(void**)(&dp), &result));
        }
        return winrt::Windows::Foundation::IInspectable{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObject<D>::GetAnimationBaseValue(winrt::Windows::UI::Xaml::DependencyProperty const& dp) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetAnimationBaseValue(*(void**)(&dp), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)this;
            check_hresult(_winrt_abi_type->GetAnimationBaseValue(*(void**)(&dp), &result));
        }
        return winrt::Windows::Foundation::IInspectable{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObject<D>::Dispatcher() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObject>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObject, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Dispatcher(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject>**)this;
            check_hresult(_winrt_abi_type->get_Dispatcher(&value));
        }
        return winrt::Windows::UI::Core::CoreDispatcher{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObject2<D>::RegisterPropertyChangedCallback(winrt::Windows::UI::Xaml::DependencyProperty const& dp, winrt::Windows::UI::Xaml::DependencyPropertyChangedCallback const& callback) const
    {
        int64_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObject2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObject2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RegisterPropertyChangedCallback(*(void**)(&dp), *(void**)(&callback), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject2>**)this;
            check_hresult(_winrt_abi_type->RegisterPropertyChangedCallback(*(void**)(&dp), *(void**)(&callback), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObject2<D>::UnregisterPropertyChangedCallback(winrt::Windows::UI::Xaml::DependencyProperty const& dp, int64_t token) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObject2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObject2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UnregisterPropertyChangedCallback(*(void**)(&dp), token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObject2>**)this;
            check_hresult(_winrt_abi_type->UnregisterPropertyChangedCallback(*(void**)(&dp), token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObjectCollectionFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObjectCollectionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObjectCollectionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObjectCollectionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObjectCollectionFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::DependencyObjectCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyObjectFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyObjectFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyObjectFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObjectFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyObjectFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::DependencyObject{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyProperty<D>::GetMetadata(winrt::Windows::UI::Xaml::Interop::TypeName const& forType) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyProperty>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyProperty, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyProperty>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetMetadata(impl::bind_in(forType), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyProperty>**)this;
            check_hresult(_winrt_abi_type->GetMetadata(impl::bind_in(forType), &result));
        }
        return winrt::Windows::UI::Xaml::PropertyMetadata{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyPropertyChangedEventArgs<D>::Property() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Property(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Property(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyPropertyChangedEventArgs<D>::OldValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OldValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_OldValue(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyPropertyChangedEventArgs<D>::NewValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_NewValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_NewValue(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyPropertyStatics<D>::UnsetValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyPropertyStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyPropertyStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UnsetValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyStatics>**)this;
            check_hresult(_winrt_abi_type->get_UnsetValue(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyPropertyStatics<D>::Register(param::hstring const& name, winrt::Windows::UI::Xaml::Interop::TypeName const& propertyType, winrt::Windows::UI::Xaml::Interop::TypeName const& ownerType, winrt::Windows::UI::Xaml::PropertyMetadata const& typeMetadata) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyPropertyStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyPropertyStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Register(*(void**)(&name), impl::bind_in(propertyType), impl::bind_in(ownerType), *(void**)(&typeMetadata), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyStatics>**)this;
            check_hresult(_winrt_abi_type->Register(*(void**)(&name), impl::bind_in(propertyType), impl::bind_in(ownerType), *(void**)(&typeMetadata), &result));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDependencyPropertyStatics<D>::RegisterAttached(param::hstring const& name, winrt::Windows::UI::Xaml::Interop::TypeName const& propertyType, winrt::Windows::UI::Xaml::Interop::TypeName const& ownerType, winrt::Windows::UI::Xaml::PropertyMetadata const& defaultMetadata) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDependencyPropertyStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDependencyPropertyStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RegisterAttached(*(void**)(&name), impl::bind_in(propertyType), impl::bind_in(ownerType), *(void**)(&defaultMetadata), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDependencyPropertyStatics>**)this;
            check_hresult(_winrt_abi_type->RegisterAttached(*(void**)(&name), impl::bind_in(propertyType), impl::bind_in(ownerType), *(void**)(&defaultMetadata), &result));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDispatcherTimer<D>::Interval() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDispatcherTimer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDispatcherTimer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Interval(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)this;
            check_hresult(_winrt_abi_type->get_Interval(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDispatcherTimer<D>::Interval(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDispatcherTimer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDispatcherTimer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Interval(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)this;
            check_hresult(_winrt_abi_type->put_Interval(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDispatcherTimer<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDispatcherTimer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDispatcherTimer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDispatcherTimer<D>::Tick(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDispatcherTimer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDispatcherTimer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Tick(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)this;
            check_hresult(_winrt_abi_type->add_Tick(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDispatcherTimer<D>::Tick(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, Tick_revoker>(this, Tick(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDispatcherTimer<D>::Tick(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDispatcherTimer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDispatcherTimer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Tick(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)this;
            _winrt_abi_type->remove_Tick(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDispatcherTimer<D>::Start() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDispatcherTimer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDispatcherTimer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Start());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)this;
            check_hresult(_winrt_abi_type->Start());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDispatcherTimer<D>::Stop() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDispatcherTimer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDispatcherTimer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Stop());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimer>**)this;
            check_hresult(_winrt_abi_type->Stop());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDispatcherTimerFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDispatcherTimerFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDispatcherTimerFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimerFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDispatcherTimerFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::DispatcherTimer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs<D>::Handled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Handled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Handled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs<D>::Handled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Handled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_Handled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs<D>::Data() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        return winrt::Windows::ApplicationModel::DataTransfer::DataPackage{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs<D>::Data(winrt::Windows::ApplicationModel::DataTransfer::DataPackage const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Data(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_Data(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs<D>::GetPosition(winrt::Windows::UI::Xaml::UIElement const& relativeTo) const
    {
        winrt::Windows::Foundation::Point result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetPosition(*(void**)(&relativeTo), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs>**)this;
            check_hresult(_winrt_abi_type->GetPosition(*(void**)(&relativeTo), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs2<D>::DataView() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DataView(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)this;
            check_hresult(_winrt_abi_type->get_DataView(&value));
        }
        return winrt::Windows::ApplicationModel::DataTransfer::DataPackageView{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs2<D>::DragUIOverride() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DragUIOverride(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)this;
            check_hresult(_winrt_abi_type->get_DragUIOverride(&value));
        }
        return winrt::Windows::UI::Xaml::DragUIOverride{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs2<D>::Modifiers() const
    {
        winrt::Windows::ApplicationModel::DataTransfer::DragDrop::DragDropModifiers value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Modifiers(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)this;
            check_hresult(_winrt_abi_type->get_Modifiers(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs2<D>::AcceptedOperation() const
    {
        winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AcceptedOperation(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)this;
            check_hresult(_winrt_abi_type->get_AcceptedOperation(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs2<D>::AcceptedOperation(winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AcceptedOperation(static_cast<uint32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)this;
            check_hresult(_winrt_abi_type->put_AcceptedOperation(static_cast<uint32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs2<D>::GetDeferral() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs2>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        return winrt::Windows::UI::Xaml::DragOperationDeferral{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragEventArgs3<D>::AllowedOperations() const
    {
        winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragEventArgs3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragEventArgs3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowedOperations(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragEventArgs3>**)this;
            check_hresult(_winrt_abi_type->get_AllowedOperations(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragOperationDeferral<D>::Complete() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragOperationDeferral>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragOperationDeferral, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragOperationDeferral>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Complete());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragOperationDeferral>**)this;
            check_hresult(_winrt_abi_type->Complete());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragStartingEventArgs<D>::Cancel() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragStartingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Cancel(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Cancel(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragStartingEventArgs<D>::Cancel(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragStartingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Cancel(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_Cancel(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragStartingEventArgs<D>::Data() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragStartingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        return winrt::Windows::ApplicationModel::DataTransfer::DataPackage{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragStartingEventArgs<D>::DragUI() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragStartingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DragUI(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_DragUI(&value));
        }
        return winrt::Windows::UI::Xaml::DragUI{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragStartingEventArgs<D>::GetDeferral() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragStartingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        return winrt::Windows::UI::Xaml::DragOperationDeferral{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragStartingEventArgs<D>::GetPosition(winrt::Windows::UI::Xaml::UIElement const& relativeTo) const
    {
        winrt::Windows::Foundation::Point result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragStartingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetPosition(*(void**)(&relativeTo), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs>**)this;
            check_hresult(_winrt_abi_type->GetPosition(*(void**)(&relativeTo), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragStartingEventArgs2<D>::AllowedOperations() const
    {
        winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragStartingEventArgs2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowedOperations(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs2>**)this;
            check_hresult(_winrt_abi_type->get_AllowedOperations(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragStartingEventArgs2<D>::AllowedOperations(winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragStartingEventArgs2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AllowedOperations(static_cast<uint32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragStartingEventArgs2>**)this;
            check_hresult(_winrt_abi_type->put_AllowedOperations(static_cast<uint32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUI<D>::SetContentFromBitmapImage(winrt::Windows::UI::Xaml::Media::Imaging::BitmapImage const& bitmapImage) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetContentFromBitmapImage(*(void**)(&bitmapImage)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)this;
            check_hresult(_winrt_abi_type->SetContentFromBitmapImage(*(void**)(&bitmapImage)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUI<D>::SetContentFromBitmapImage(winrt::Windows::UI::Xaml::Media::Imaging::BitmapImage const& bitmapImage, winrt::Windows::Foundation::Point const& anchorPoint) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetContentFromBitmapImageWithAnchorPoint(*(void**)(&bitmapImage), impl::bind_in(anchorPoint)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)this;
            check_hresult(_winrt_abi_type->SetContentFromBitmapImageWithAnchorPoint(*(void**)(&bitmapImage), impl::bind_in(anchorPoint)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUI<D>::SetContentFromSoftwareBitmap(winrt::Windows::Graphics::Imaging::SoftwareBitmap const& softwareBitmap) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetContentFromSoftwareBitmap(*(void**)(&softwareBitmap)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)this;
            check_hresult(_winrt_abi_type->SetContentFromSoftwareBitmap(*(void**)(&softwareBitmap)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUI<D>::SetContentFromSoftwareBitmap(winrt::Windows::Graphics::Imaging::SoftwareBitmap const& softwareBitmap, winrt::Windows::Foundation::Point const& anchorPoint) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetContentFromSoftwareBitmapWithAnchorPoint(*(void**)(&softwareBitmap), impl::bind_in(anchorPoint)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)this;
            check_hresult(_winrt_abi_type->SetContentFromSoftwareBitmapWithAnchorPoint(*(void**)(&softwareBitmap), impl::bind_in(anchorPoint)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUI<D>::SetContentFromDataPackage() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetContentFromDataPackage());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUI>**)this;
            check_hresult(_winrt_abi_type->SetContentFromDataPackage());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::Caption() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Caption(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->get_Caption(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::Caption(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Caption(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->put_Caption(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::IsContentVisible() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsContentVisible(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->get_IsContentVisible(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::IsContentVisible(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsContentVisible(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->put_IsContentVisible(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::IsCaptionVisible() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCaptionVisible(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->get_IsCaptionVisible(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::IsCaptionVisible(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsCaptionVisible(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->put_IsCaptionVisible(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::IsGlyphVisible() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsGlyphVisible(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->get_IsGlyphVisible(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::IsGlyphVisible(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsGlyphVisible(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->put_IsGlyphVisible(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::Clear() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Clear());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->Clear());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::SetContentFromBitmapImage(winrt::Windows::UI::Xaml::Media::Imaging::BitmapImage const& bitmapImage) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetContentFromBitmapImage(*(void**)(&bitmapImage)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->SetContentFromBitmapImage(*(void**)(&bitmapImage)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::SetContentFromBitmapImage(winrt::Windows::UI::Xaml::Media::Imaging::BitmapImage const& bitmapImage, winrt::Windows::Foundation::Point const& anchorPoint) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetContentFromBitmapImageWithAnchorPoint(*(void**)(&bitmapImage), impl::bind_in(anchorPoint)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->SetContentFromBitmapImageWithAnchorPoint(*(void**)(&bitmapImage), impl::bind_in(anchorPoint)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::SetContentFromSoftwareBitmap(winrt::Windows::Graphics::Imaging::SoftwareBitmap const& softwareBitmap) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetContentFromSoftwareBitmap(*(void**)(&softwareBitmap)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->SetContentFromSoftwareBitmap(*(void**)(&softwareBitmap)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDragUIOverride<D>::SetContentFromSoftwareBitmap(winrt::Windows::Graphics::Imaging::SoftwareBitmap const& softwareBitmap, winrt::Windows::Foundation::Point const& anchorPoint) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDragUIOverride>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDragUIOverride, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetContentFromSoftwareBitmapWithAnchorPoint(*(void**)(&softwareBitmap), impl::bind_in(anchorPoint)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDragUIOverride>**)this;
            check_hresult(_winrt_abi_type->SetContentFromSoftwareBitmapWithAnchorPoint(*(void**)(&softwareBitmap), impl::bind_in(anchorPoint)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDropCompletedEventArgs<D>::DropResult() const
    {
        winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDropCompletedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDropCompletedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDropCompletedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DropResult(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDropCompletedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_DropResult(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDurationHelperStatics<D>::Automatic() const
    {
        winrt::Windows::UI::Xaml::Duration value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDurationHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDurationHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Automatic(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)this;
            check_hresult(_winrt_abi_type->get_Automatic(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDurationHelperStatics<D>::Forever() const
    {
        winrt::Windows::UI::Xaml::Duration value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDurationHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDurationHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Forever(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)this;
            check_hresult(_winrt_abi_type->get_Forever(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDurationHelperStatics<D>::Compare(winrt::Windows::UI::Xaml::Duration const& duration1, winrt::Windows::UI::Xaml::Duration const& duration2) const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDurationHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDurationHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Compare(impl::bind_in(duration1), impl::bind_in(duration2), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)this;
            check_hresult(_winrt_abi_type->Compare(impl::bind_in(duration1), impl::bind_in(duration2), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDurationHelperStatics<D>::FromTimeSpan(winrt::Windows::Foundation::TimeSpan const& timeSpan) const
    {
        winrt::Windows::UI::Xaml::Duration result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDurationHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDurationHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromTimeSpan(impl::bind_in(timeSpan), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromTimeSpan(impl::bind_in(timeSpan), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDurationHelperStatics<D>::GetHasTimeSpan(winrt::Windows::UI::Xaml::Duration const& target) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDurationHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDurationHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetHasTimeSpan(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetHasTimeSpan(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDurationHelperStatics<D>::Add(winrt::Windows::UI::Xaml::Duration const& target, winrt::Windows::UI::Xaml::Duration const& duration) const
    {
        winrt::Windows::UI::Xaml::Duration result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDurationHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDurationHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Add(impl::bind_in(target), impl::bind_in(duration), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)this;
            check_hresult(_winrt_abi_type->Add(impl::bind_in(target), impl::bind_in(duration), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDurationHelperStatics<D>::Equals(winrt::Windows::UI::Xaml::Duration const& target, winrt::Windows::UI::Xaml::Duration const& value) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDurationHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDurationHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Equals(impl::bind_in(target), impl::bind_in(value), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)this;
            check_hresult(_winrt_abi_type->Equals(impl::bind_in(target), impl::bind_in(value), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IDurationHelperStatics<D>::Subtract(winrt::Windows::UI::Xaml::Duration const& target, winrt::Windows::UI::Xaml::Duration const& duration) const
    {
        winrt::Windows::UI::Xaml::Duration result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IDurationHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IDurationHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Subtract(impl::bind_in(target), impl::bind_in(duration), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IDurationHelperStatics>**)this;
            check_hresult(_winrt_abi_type->Subtract(impl::bind_in(target), impl::bind_in(duration), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IEffectiveViewportChangedEventArgs<D>::EffectiveViewport() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EffectiveViewport(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_EffectiveViewport(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IEffectiveViewportChangedEventArgs<D>::MaxViewport() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxViewport(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_MaxViewport(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IEffectiveViewportChangedEventArgs<D>::BringIntoViewDistanceX() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BringIntoViewDistanceX(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_BringIntoViewDistanceX(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IEffectiveViewportChangedEventArgs<D>::BringIntoViewDistanceY() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BringIntoViewDistanceY(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_BringIntoViewDistanceY(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactory<D>::GetElement(winrt::Windows::UI::Xaml::ElementFactoryGetArgs const& args) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetElement(*(void**)(&args), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactory>**)this;
            check_hresult(_winrt_abi_type->GetElement(*(void**)(&args), &result));
        }
        return winrt::Windows::UI::Xaml::UIElement{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactory<D>::RecycleElement(winrt::Windows::UI::Xaml::ElementFactoryRecycleArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RecycleElement(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactory>**)this;
            check_hresult(_winrt_abi_type->RecycleElement(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryGetArgs<D>::Data() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryGetArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryGetArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgs>**)this;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryGetArgs<D>::Data(winrt::Windows::Foundation::IInspectable const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryGetArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryGetArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Data(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgs>**)this;
            check_hresult(_winrt_abi_type->put_Data(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryGetArgs<D>::Parent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryGetArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryGetArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgs>**)this;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        return winrt::Windows::UI::Xaml::UIElement{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryGetArgs<D>::Parent(winrt::Windows::UI::Xaml::UIElement const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryGetArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryGetArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Parent(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgs>**)this;
            check_hresult(_winrt_abi_type->put_Parent(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryGetArgsFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryGetArgsFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryGetArgsFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgsFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryGetArgsFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::ElementFactoryGetArgs{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryRecycleArgs<D>::Element() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Element(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>**)this;
            check_hresult(_winrt_abi_type->get_Element(&value));
        }
        return winrt::Windows::UI::Xaml::UIElement{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryRecycleArgs<D>::Element(winrt::Windows::UI::Xaml::UIElement const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Element(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>**)this;
            check_hresult(_winrt_abi_type->put_Element(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryRecycleArgs<D>::Parent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>**)this;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        return winrt::Windows::UI::Xaml::UIElement{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryRecycleArgs<D>::Parent(winrt::Windows::UI::Xaml::UIElement const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Parent(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>**)this;
            check_hresult(_winrt_abi_type->put_Parent(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementFactoryRecycleArgsFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementFactoryRecycleArgsFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgsFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgsFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementFactoryRecycleArgsFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::ElementFactoryRecycleArgs{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementSoundPlayerStatics<D>::Volume() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Volume(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)this;
            check_hresult(_winrt_abi_type->get_Volume(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementSoundPlayerStatics<D>::Volume(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Volume(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)this;
            check_hresult(_winrt_abi_type->put_Volume(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementSoundPlayerStatics<D>::State() const
    {
        winrt::Windows::UI::Xaml::ElementSoundPlayerState value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_State(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)this;
            check_hresult(_winrt_abi_type->get_State(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementSoundPlayerStatics<D>::State(winrt::Windows::UI::Xaml::ElementSoundPlayerState const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_State(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)this;
            check_hresult(_winrt_abi_type->put_State(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementSoundPlayerStatics<D>::Play(winrt::Windows::UI::Xaml::ElementSoundKind const& sound) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Play(static_cast<int32_t>(sound)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>**)this;
            check_hresult(_winrt_abi_type->Play(static_cast<int32_t>(sound)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementSoundPlayerStatics2<D>::SpatialAudioMode() const
    {
        winrt::Windows::UI::Xaml::ElementSpatialAudioMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SpatialAudioMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2>**)this;
            check_hresult(_winrt_abi_type->get_SpatialAudioMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IElementSoundPlayerStatics2<D>::SpatialAudioMode(winrt::Windows::UI::Xaml::ElementSpatialAudioMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SpatialAudioMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2>**)this;
            check_hresult(_winrt_abi_type->put_SpatialAudioMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IEventTrigger<D>::RoutedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IEventTrigger>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IEventTrigger, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEventTrigger>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RoutedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEventTrigger>**)this;
            check_hresult(_winrt_abi_type->get_RoutedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IEventTrigger<D>::RoutedEvent(winrt::Windows::UI::Xaml::RoutedEvent const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IEventTrigger>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IEventTrigger, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEventTrigger>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RoutedEvent(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEventTrigger>**)this;
            check_hresult(_winrt_abi_type->put_RoutedEvent(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IEventTrigger<D>::Actions() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IEventTrigger>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IEventTrigger, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEventTrigger>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Actions(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IEventTrigger>**)this;
            check_hresult(_winrt_abi_type->get_Actions(&value));
        }
        return winrt::Windows::UI::Xaml::TriggerActionCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IExceptionRoutedEventArgs<D>::ErrorMessage() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IExceptionRoutedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IExceptionRoutedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IExceptionRoutedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ErrorMessage(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IExceptionRoutedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ErrorMessage(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Triggers() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Triggers(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Triggers(&value));
        }
        return winrt::Windows::UI::Xaml::TriggerCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Resources() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Resources(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Resources(&value));
        }
        return winrt::Windows::UI::Xaml::ResourceDictionary{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Resources(winrt::Windows::UI::Xaml::ResourceDictionary const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Resources(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_Resources(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Tag() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Tag(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Tag(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Tag(winrt::Windows::Foundation::IInspectable const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Tag(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_Tag(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Language() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Language(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Language(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Language(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Language(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_Language(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::ActualWidth() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualWidth(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_ActualWidth(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::ActualHeight() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualHeight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_ActualHeight(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Width() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Width(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Width(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Width(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Width(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_Width(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Height() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Height(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Height(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Height(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Height(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_Height(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::MinWidth() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinWidth(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_MinWidth(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::MinWidth(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MinWidth(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_MinWidth(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::MaxWidth() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxWidth(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_MaxWidth(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::MaxWidth(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MaxWidth(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_MaxWidth(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::MinHeight() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinHeight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_MinHeight(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::MinHeight(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MinHeight(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_MinHeight(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::MaxHeight() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxHeight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_MaxHeight(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::MaxHeight(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MaxHeight(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_MaxHeight(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::HorizontalAlignment() const
    {
        winrt::Windows::UI::Xaml::HorizontalAlignment value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalAlignment(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalAlignment(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::HorizontalAlignment(winrt::Windows::UI::Xaml::HorizontalAlignment const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HorizontalAlignment(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_HorizontalAlignment(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::VerticalAlignment() const
    {
        winrt::Windows::UI::Xaml::VerticalAlignment value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VerticalAlignment(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_VerticalAlignment(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::VerticalAlignment(winrt::Windows::UI::Xaml::VerticalAlignment const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_VerticalAlignment(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_VerticalAlignment(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Margin() const
    {
        winrt::Windows::UI::Xaml::Thickness value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Margin(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Margin(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Margin(winrt::Windows::UI::Xaml::Thickness const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Margin(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_Margin(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Name(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Name(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_Name(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::BaseUri() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BaseUri(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_BaseUri(&value));
        }
        return winrt::Windows::Foundation::Uri{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::DataContext() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DataContext(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_DataContext(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::DataContext(winrt::Windows::Foundation::IInspectable const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DataContext(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_DataContext(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Style() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Style(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Style(&value));
        }
        return winrt::Windows::UI::Xaml::Style{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Style(winrt::Windows::UI::Xaml::Style const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Style(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_Style(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Parent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyObject{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::FlowDirection() const
    {
        winrt::Windows::UI::Xaml::FlowDirection value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FlowDirection(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->get_FlowDirection(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::FlowDirection(winrt::Windows::UI::Xaml::FlowDirection const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FlowDirection(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->put_FlowDirection(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Loaded(winrt::Windows::UI::Xaml::RoutedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Loaded(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->add_Loaded(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Loaded(auto_revoke_t, winrt::Windows::UI::Xaml::RoutedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, Loaded_revoker>(this, Loaded(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Loaded(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Loaded(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            _winrt_abi_type->remove_Loaded(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Unloaded(winrt::Windows::UI::Xaml::RoutedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Unloaded(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->add_Unloaded(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Unloaded(auto_revoke_t, winrt::Windows::UI::Xaml::RoutedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, Unloaded_revoker>(this, Unloaded(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::Unloaded(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Unloaded(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            _winrt_abi_type->remove_Unloaded(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::SizeChanged(winrt::Windows::UI::Xaml::SizeChangedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_SizeChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->add_SizeChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::SizeChanged(auto_revoke_t, winrt::Windows::UI::Xaml::SizeChangedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, SizeChanged_revoker>(this, SizeChanged(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::SizeChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_SizeChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            _winrt_abi_type->remove_SizeChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::LayoutUpdated(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_LayoutUpdated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->add_LayoutUpdated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::LayoutUpdated(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, LayoutUpdated_revoker>(this, LayoutUpdated(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::LayoutUpdated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_LayoutUpdated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            _winrt_abi_type->remove_LayoutUpdated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::FindName(param::hstring const& name) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FindName(*(void**)(&name), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->FindName(*(void**)(&name), &result));
        }
        return winrt::Windows::Foundation::IInspectable{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement<D>::SetBinding(winrt::Windows::UI::Xaml::DependencyProperty const& dp, winrt::Windows::UI::Xaml::Data::BindingBase const& binding) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetBinding(*(void**)(&dp), *(void**)(&binding)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement>**)this;
            check_hresult(_winrt_abi_type->SetBinding(*(void**)(&dp), *(void**)(&binding)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement2<D>::RequestedTheme() const
    {
        winrt::Windows::UI::Xaml::ElementTheme value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RequestedTheme(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)this;
            check_hresult(_winrt_abi_type->get_RequestedTheme(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement2<D>::RequestedTheme(winrt::Windows::UI::Xaml::ElementTheme const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RequestedTheme(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)this;
            check_hresult(_winrt_abi_type->put_RequestedTheme(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement2<D>::DataContextChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::UI::Xaml::DataContextChangedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DataContextChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)this;
            check_hresult(_winrt_abi_type->add_DataContextChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement2<D>::DataContextChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::UI::Xaml::DataContextChangedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, DataContextChanged_revoker>(this, DataContextChanged(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement2<D>::DataContextChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DataContextChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)this;
            _winrt_abi_type->remove_DataContextChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement2<D>::GetBindingExpression(winrt::Windows::UI::Xaml::DependencyProperty const& dp) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBindingExpression(*(void**)(&dp), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement2>**)this;
            check_hresult(_winrt_abi_type->GetBindingExpression(*(void**)(&dp), &result));
        }
        return winrt::Windows::UI::Xaml::Data::BindingExpression{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement3<D>::Loading(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Loading(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement3>**)this;
            check_hresult(_winrt_abi_type->add_Loading(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement3<D>::Loading(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, Loading_revoker>(this, Loading(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement3<D>::Loading(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement3>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Loading(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement3>**)this;
            _winrt_abi_type->remove_Loading(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::AllowFocusOnInteraction() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowFocusOnInteraction(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->get_AllowFocusOnInteraction(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::AllowFocusOnInteraction(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AllowFocusOnInteraction(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->put_AllowFocusOnInteraction(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualMargin() const
    {
        winrt::Windows::UI::Xaml::Thickness value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualMargin(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualMargin(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualMargin(winrt::Windows::UI::Xaml::Thickness const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FocusVisualMargin(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->put_FocusVisualMargin(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualSecondaryThickness() const
    {
        winrt::Windows::UI::Xaml::Thickness value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualSecondaryThickness(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualSecondaryThickness(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualSecondaryThickness(winrt::Windows::UI::Xaml::Thickness const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FocusVisualSecondaryThickness(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->put_FocusVisualSecondaryThickness(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualPrimaryThickness() const
    {
        winrt::Windows::UI::Xaml::Thickness value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualPrimaryThickness(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualPrimaryThickness(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualPrimaryThickness(winrt::Windows::UI::Xaml::Thickness const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FocusVisualPrimaryThickness(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->put_FocusVisualPrimaryThickness(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualSecondaryBrush() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualSecondaryBrush(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualSecondaryBrush(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Brush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualSecondaryBrush(winrt::Windows::UI::Xaml::Media::Brush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FocusVisualSecondaryBrush(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->put_FocusVisualSecondaryBrush(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualPrimaryBrush() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualPrimaryBrush(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualPrimaryBrush(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Brush{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::FocusVisualPrimaryBrush(winrt::Windows::UI::Xaml::Media::Brush const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_FocusVisualPrimaryBrush(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->put_FocusVisualPrimaryBrush(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::AllowFocusWhenDisabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowFocusWhenDisabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->get_AllowFocusWhenDisabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement4<D>::AllowFocusWhenDisabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AllowFocusWhenDisabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement4>**)this;
            check_hresult(_winrt_abi_type->put_AllowFocusWhenDisabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement6<D>::ActualTheme() const
    {
        winrt::Windows::UI::Xaml::ElementTheme value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualTheme(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement6>**)this;
            check_hresult(_winrt_abi_type->get_ActualTheme(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement6<D>::ActualThemeChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ActualThemeChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement6>**)this;
            check_hresult(_winrt_abi_type->add_ActualThemeChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement6<D>::ActualThemeChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, ActualThemeChanged_revoker>(this, ActualThemeChanged(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement6<D>::ActualThemeChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement6>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ActualThemeChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement6>**)this;
            _winrt_abi_type->remove_ActualThemeChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement7<D>::IsLoaded() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsLoaded(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement7>**)this;
            check_hresult(_winrt_abi_type->get_IsLoaded(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement7<D>::EffectiveViewportChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::UI::Xaml::EffectiveViewportChangedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_EffectiveViewportChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement7>**)this;
            check_hresult(_winrt_abi_type->add_EffectiveViewportChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement7<D>::EffectiveViewportChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::UI::Xaml::EffectiveViewportChangedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, EffectiveViewportChanged_revoker>(this, EffectiveViewportChanged(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElement7<D>::EffectiveViewportChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement7>**)&_winrt_casted_result;
            _winrt_abi_type->remove_EffectiveViewportChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElement7>**)this;
            _winrt_abi_type->remove_EffectiveViewportChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::FrameworkElement{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementOverrides<D>::MeasureOverride(winrt::Windows::Foundation::Size const& availableSize) const
    {
        winrt::Windows::Foundation::Size result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MeasureOverride(impl::bind_in(availableSize), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementOverrides>**)this;
            check_hresult(_winrt_abi_type->MeasureOverride(impl::bind_in(availableSize), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementOverrides<D>::ArrangeOverride(winrt::Windows::Foundation::Size const& finalSize) const
    {
        winrt::Windows::Foundation::Size result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ArrangeOverride(impl::bind_in(finalSize), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementOverrides>**)this;
            check_hresult(_winrt_abi_type->ArrangeOverride(impl::bind_in(finalSize), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementOverrides<D>::OnApplyTemplate() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnApplyTemplate());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementOverrides>**)this;
            check_hresult(_winrt_abi_type->OnApplyTemplate());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementOverrides2<D>::GoToElementStateCore(param::hstring const& stateName, bool useTransitions) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementOverrides2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementOverrides2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementOverrides2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GoToElementStateCore(*(void**)(&stateName), useTransitions, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementOverrides2>**)this;
            check_hresult(_winrt_abi_type->GoToElementStateCore(*(void**)(&stateName), useTransitions, &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementProtected7<D>::InvalidateViewport() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementProtected7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementProtected7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementProtected7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InvalidateViewport());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementProtected7>**)this;
            check_hresult(_winrt_abi_type->InvalidateViewport());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::TagProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TagProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_TagProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::LanguageProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LanguageProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_LanguageProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::ActualWidthProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualWidthProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ActualWidthProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::ActualHeightProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualHeightProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ActualHeightProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::WidthProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_WidthProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_WidthProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::HeightProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HeightProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_HeightProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::MinWidthProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinWidthProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_MinWidthProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::MaxWidthProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxWidthProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_MaxWidthProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::MinHeightProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinHeightProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_MinHeightProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::MaxHeightProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxHeightProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_MaxHeightProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::HorizontalAlignmentProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalAlignmentProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::VerticalAlignmentProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_VerticalAlignmentProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::MarginProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MarginProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_MarginProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::NameProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_NameProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_NameProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::DataContextProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DataContextProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_DataContextProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::StyleProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StyleProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_StyleProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics<D>::FlowDirectionProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FlowDirectionProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_FlowDirectionProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics2<D>::RequestedThemeProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RequestedThemeProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics2>**)this;
            check_hresult(_winrt_abi_type->get_RequestedThemeProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics4<D>::AllowFocusOnInteractionProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowFocusOnInteractionProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_AllowFocusOnInteractionProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics4<D>::FocusVisualMarginProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualMarginProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualMarginProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics4<D>::FocusVisualSecondaryThicknessProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualSecondaryThicknessProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualSecondaryThicknessProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics4<D>::FocusVisualPrimaryThicknessProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualPrimaryThicknessProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualPrimaryThicknessProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics4<D>::FocusVisualSecondaryBrushProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualSecondaryBrushProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualSecondaryBrushProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics4<D>::FocusVisualPrimaryBrushProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FocusVisualPrimaryBrushProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_FocusVisualPrimaryBrushProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics4<D>::AllowFocusWhenDisabledProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowFocusWhenDisabledProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_AllowFocusWhenDisabledProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics5<D>::DeferTree(winrt::Windows::UI::Xaml::DependencyObject const& element) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DeferTree(*(void**)(&element)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics5>**)this;
            check_hresult(_winrt_abi_type->DeferTree(*(void**)(&element)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkElementStatics6<D>::ActualThemeProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkElementStatics6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkElementStatics6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualThemeProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkElementStatics6>**)this;
            check_hresult(_winrt_abi_type->get_ActualThemeProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IFrameworkTemplateFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IFrameworkTemplateFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IFrameworkTemplateFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkTemplateFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IFrameworkTemplateFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::FrameworkTemplate{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IGridLengthHelperStatics<D>::Auto() const
    {
        winrt::Windows::UI::Xaml::GridLength value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IGridLengthHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IGridLengthHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Auto(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)this;
            check_hresult(_winrt_abi_type->get_Auto(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IGridLengthHelperStatics<D>::FromPixels(double pixels) const
    {
        winrt::Windows::UI::Xaml::GridLength result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IGridLengthHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IGridLengthHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromPixels(pixels, put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromPixels(pixels, put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IGridLengthHelperStatics<D>::FromValueAndType(double value, winrt::Windows::UI::Xaml::GridUnitType const& type) const
    {
        winrt::Windows::UI::Xaml::GridLength result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IGridLengthHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IGridLengthHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromValueAndType(value, static_cast<int32_t>(type), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromValueAndType(value, static_cast<int32_t>(type), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IGridLengthHelperStatics<D>::GetIsAbsolute(winrt::Windows::UI::Xaml::GridLength const& target) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IGridLengthHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IGridLengthHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsAbsolute(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetIsAbsolute(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IGridLengthHelperStatics<D>::GetIsAuto(winrt::Windows::UI::Xaml::GridLength const& target) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IGridLengthHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IGridLengthHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsAuto(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetIsAuto(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IGridLengthHelperStatics<D>::GetIsStar(winrt::Windows::UI::Xaml::GridLength const& target) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IGridLengthHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IGridLengthHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsStar(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetIsStar(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IGridLengthHelperStatics<D>::Equals(winrt::Windows::UI::Xaml::GridLength const& target, winrt::Windows::UI::Xaml::GridLength const& value) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IGridLengthHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IGridLengthHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Equals(impl::bind_in(target), impl::bind_in(value), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IGridLengthHelperStatics>**)this;
            check_hresult(_winrt_abi_type->Equals(impl::bind_in(target), impl::bind_in(value), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IMediaFailedRoutedEventArgs<D>::ErrorTrace() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IMediaFailedRoutedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IMediaFailedRoutedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IMediaFailedRoutedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ErrorTrace(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IMediaFailedRoutedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ErrorTrace(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPointHelperStatics<D>::FromCoordinates(float x, float y) const
    {
        winrt::Windows::Foundation::Point result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPointHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPointHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPointHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromCoordinates(x, y, put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPointHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromCoordinates(x, y, put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyMetadata<D>::DefaultValue() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyMetadata>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyMetadata, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadata>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DefaultValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadata>**)this;
            check_hresult(_winrt_abi_type->get_DefaultValue(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyMetadata<D>::CreateDefaultValueCallback() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyMetadata>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyMetadata, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadata>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CreateDefaultValueCallback(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadata>**)this;
            check_hresult(_winrt_abi_type->get_CreateDefaultValueCallback(&value));
        }
        return winrt::Windows::UI::Xaml::CreateDefaultValueCallback{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyMetadataFactory<D>::CreateInstanceWithDefaultValue(winrt::Windows::Foundation::IInspectable const& defaultValue, winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyMetadataFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyMetadataFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstanceWithDefaultValue(*(void**)(&defaultValue), *(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstanceWithDefaultValue(*(void**)(&defaultValue), *(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::PropertyMetadata{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyMetadataFactory<D>::CreateInstanceWithDefaultValueAndCallback(winrt::Windows::Foundation::IInspectable const& defaultValue, winrt::Windows::UI::Xaml::PropertyChangedCallback const& propertyChangedCallback, winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyMetadataFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyMetadataFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstanceWithDefaultValueAndCallback(*(void**)(&defaultValue), *(void**)(&propertyChangedCallback), *(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstanceWithDefaultValueAndCallback(*(void**)(&defaultValue), *(void**)(&propertyChangedCallback), *(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::PropertyMetadata{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyMetadataStatics<D>::Create(winrt::Windows::Foundation::IInspectable const& defaultValue) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyMetadataStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyMetadataStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithDefaultValue(*(void**)(&defaultValue), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataStatics>**)this;
            check_hresult(_winrt_abi_type->CreateWithDefaultValue(*(void**)(&defaultValue), &result));
        }
        return winrt::Windows::UI::Xaml::PropertyMetadata{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyMetadataStatics<D>::Create(winrt::Windows::Foundation::IInspectable const& defaultValue, winrt::Windows::UI::Xaml::PropertyChangedCallback const& propertyChangedCallback) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyMetadataStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyMetadataStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithDefaultValueAndCallback(*(void**)(&defaultValue), *(void**)(&propertyChangedCallback), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataStatics>**)this;
            check_hresult(_winrt_abi_type->CreateWithDefaultValueAndCallback(*(void**)(&defaultValue), *(void**)(&propertyChangedCallback), &result));
        }
        return winrt::Windows::UI::Xaml::PropertyMetadata{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyMetadataStatics<D>::Create(winrt::Windows::UI::Xaml::CreateDefaultValueCallback const& createDefaultValueCallback) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyMetadataStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyMetadataStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithFactory(*(void**)(&createDefaultValueCallback), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataStatics>**)this;
            check_hresult(_winrt_abi_type->CreateWithFactory(*(void**)(&createDefaultValueCallback), &result));
        }
        return winrt::Windows::UI::Xaml::PropertyMetadata{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyMetadataStatics<D>::Create(winrt::Windows::UI::Xaml::CreateDefaultValueCallback const& createDefaultValueCallback, winrt::Windows::UI::Xaml::PropertyChangedCallback const& propertyChangedCallback) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyMetadataStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyMetadataStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateWithFactoryAndCallback(*(void**)(&createDefaultValueCallback), *(void**)(&propertyChangedCallback), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyMetadataStatics>**)this;
            check_hresult(_winrt_abi_type->CreateWithFactoryAndCallback(*(void**)(&createDefaultValueCallback), *(void**)(&propertyChangedCallback), &result));
        }
        return winrt::Windows::UI::Xaml::PropertyMetadata{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyPath<D>::Path() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyPath>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyPath, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyPath>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyPath>**)this;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IPropertyPathFactory<D>::CreateInstance(param::hstring const& path) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IPropertyPathFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IPropertyPathFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyPathFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&path), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IPropertyPathFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&path), &value));
        }
        return winrt::Windows::UI::Xaml::PropertyPath{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::Empty() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Empty(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->get_Empty(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::FromCoordinatesAndDimensions(float x, float y, float width, float height) const
    {
        winrt::Windows::Foundation::Rect result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromCoordinatesAndDimensions(x, y, width, height, put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromCoordinatesAndDimensions(x, y, width, height, put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::FromPoints(winrt::Windows::Foundation::Point const& point1, winrt::Windows::Foundation::Point const& point2) const
    {
        winrt::Windows::Foundation::Rect result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromPoints(impl::bind_in(point1), impl::bind_in(point2), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromPoints(impl::bind_in(point1), impl::bind_in(point2), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::FromLocationAndSize(winrt::Windows::Foundation::Point const& location, winrt::Windows::Foundation::Size const& size) const
    {
        winrt::Windows::Foundation::Rect result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromLocationAndSize(impl::bind_in(location), impl::bind_in(size), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromLocationAndSize(impl::bind_in(location), impl::bind_in(size), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::GetIsEmpty(winrt::Windows::Foundation::Rect const& target) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsEmpty(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetIsEmpty(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::GetBottom(winrt::Windows::Foundation::Rect const& target) const
    {
        float result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBottom(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetBottom(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::GetLeft(winrt::Windows::Foundation::Rect const& target) const
    {
        float result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetLeft(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetLeft(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::GetRight(winrt::Windows::Foundation::Rect const& target) const
    {
        float result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetRight(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetRight(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::GetTop(winrt::Windows::Foundation::Rect const& target) const
    {
        float result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetTop(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetTop(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::Contains(winrt::Windows::Foundation::Rect const& target, winrt::Windows::Foundation::Point const& point) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Contains(impl::bind_in(target), impl::bind_in(point), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->Contains(impl::bind_in(target), impl::bind_in(point), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::Equals(winrt::Windows::Foundation::Rect const& target, winrt::Windows::Foundation::Rect const& value) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Equals(impl::bind_in(target), impl::bind_in(value), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->Equals(impl::bind_in(target), impl::bind_in(value), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::Intersect(winrt::Windows::Foundation::Rect const& target, winrt::Windows::Foundation::Rect const& rect) const
    {
        winrt::Windows::Foundation::Rect result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Intersect(impl::bind_in(target), impl::bind_in(rect), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->Intersect(impl::bind_in(target), impl::bind_in(rect), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::Union(winrt::Windows::Foundation::Rect const& target, winrt::Windows::Foundation::Point const& point) const
    {
        winrt::Windows::Foundation::Rect result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UnionWithPoint(impl::bind_in(target), impl::bind_in(point), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->UnionWithPoint(impl::bind_in(target), impl::bind_in(point), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRectHelperStatics<D>::Union(winrt::Windows::Foundation::Rect const& target, winrt::Windows::Foundation::Rect const& rect) const
    {
        winrt::Windows::Foundation::Rect result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRectHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRectHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UnionWithRect(impl::bind_in(target), impl::bind_in(rect), put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRectHelperStatics>**)this;
            check_hresult(_winrt_abi_type->UnionWithRect(impl::bind_in(target), impl::bind_in(rect), put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IResourceDictionary<D>::Source() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IResourceDictionary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IResourceDictionary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionary>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Source(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionary>**)this;
            check_hresult(_winrt_abi_type->get_Source(&value));
        }
        return winrt::Windows::Foundation::Uri{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IResourceDictionary<D>::Source(winrt::Windows::Foundation::Uri const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IResourceDictionary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IResourceDictionary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionary>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Source(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionary>**)this;
            check_hresult(_winrt_abi_type->put_Source(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IResourceDictionary<D>::MergedDictionaries() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IResourceDictionary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IResourceDictionary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionary>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MergedDictionaries(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionary>**)this;
            check_hresult(_winrt_abi_type->get_MergedDictionaries(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::UI::Xaml::ResourceDictionary>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IResourceDictionary<D>::ThemeDictionaries() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IResourceDictionary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IResourceDictionary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionary>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ThemeDictionaries(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionary>**)this;
            check_hresult(_winrt_abi_type->get_ThemeDictionaries(&value));
        }
        return winrt::Windows::Foundation::Collections::IMap<winrt::Windows::Foundation::IInspectable, winrt::Windows::Foundation::IInspectable>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IResourceDictionaryFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IResourceDictionaryFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IResourceDictionaryFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionaryFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IResourceDictionaryFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::ResourceDictionary{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRoutedEventArgs<D>::OriginalSource() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRoutedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRoutedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRoutedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OriginalSource(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRoutedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_OriginalSource(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IRoutedEventArgsFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IRoutedEventArgsFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IRoutedEventArgsFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRoutedEventArgsFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IRoutedEventArgsFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::RoutedEventArgs{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IScalarTransition<D>::Duration() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IScalarTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IScalarTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IScalarTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IScalarTransition>**)this;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IScalarTransition<D>::Duration(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IScalarTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IScalarTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IScalarTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Duration(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IScalarTransition>**)this;
            check_hresult(_winrt_abi_type->put_Duration(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IScalarTransitionFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IScalarTransitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IScalarTransitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IScalarTransitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IScalarTransitionFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::ScalarTransition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISetter<D>::Property() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISetter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISetter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Property(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter>**)this;
            check_hresult(_winrt_abi_type->get_Property(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISetter<D>::Property(winrt::Windows::UI::Xaml::DependencyProperty const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISetter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISetter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Property(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter>**)this;
            check_hresult(_winrt_abi_type->put_Property(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISetter<D>::Value() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISetter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISetter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter>**)this;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISetter<D>::Value(winrt::Windows::Foundation::IInspectable const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISetter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISetter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter>**)this;
            check_hresult(_winrt_abi_type->put_Value(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISetter2<D>::Target() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISetter2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISetter2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Target(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter2>**)this;
            check_hresult(_winrt_abi_type->get_Target(&value));
        }
        return winrt::Windows::UI::Xaml::TargetPropertyPath{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISetter2<D>::Target(winrt::Windows::UI::Xaml::TargetPropertyPath const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISetter2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISetter2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Target(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetter2>**)this;
            check_hresult(_winrt_abi_type->put_Target(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISetterBase<D>::IsSealed() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISetterBase>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISetterBase, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetterBase>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSealed(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetterBase>**)this;
            check_hresult(_winrt_abi_type->get_IsSealed(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISetterBaseCollection<D>::IsSealed() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISetterBaseCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISetterBaseCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetterBaseCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSealed(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetterBaseCollection>**)this;
            check_hresult(_winrt_abi_type->get_IsSealed(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISetterFactory<D>::CreateInstance(winrt::Windows::UI::Xaml::DependencyProperty const& targetProperty, winrt::Windows::Foundation::IInspectable const& value) const
    {
        void* instance{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISetterFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISetterFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetterFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&targetProperty), *(void**)(&value), &instance));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISetterFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&targetProperty), *(void**)(&value), &instance));
        }
        return winrt::Windows::UI::Xaml::Setter{ instance, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISizeChangedEventArgs<D>::PreviousSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISizeChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISizeChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PreviousSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_PreviousSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISizeChangedEventArgs<D>::NewSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISizeChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISizeChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_NewSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_NewSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISizeHelperStatics<D>::Empty() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISizeHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISizeHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Empty(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeHelperStatics>**)this;
            check_hresult(_winrt_abi_type->get_Empty(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISizeHelperStatics<D>::FromDimensions(float width, float height) const
    {
        winrt::Windows::Foundation::Size result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISizeHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISizeHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromDimensions(width, height, put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromDimensions(width, height, put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISizeHelperStatics<D>::GetIsEmpty(winrt::Windows::Foundation::Size const& target) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISizeHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISizeHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsEmpty(impl::bind_in(target), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeHelperStatics>**)this;
            check_hresult(_winrt_abi_type->GetIsEmpty(impl::bind_in(target), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_ISizeHelperStatics<D>::Equals(winrt::Windows::Foundation::Size const& target, winrt::Windows::Foundation::Size const& value) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ISizeHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ISizeHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Equals(impl::bind_in(target), impl::bind_in(value), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ISizeHelperStatics>**)this;
            check_hresult(_winrt_abi_type->Equals(impl::bind_in(target), impl::bind_in(value), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStateTrigger<D>::IsActive() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStateTrigger>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStateTrigger, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTrigger>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTrigger>**)this;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStateTrigger<D>::IsActive(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStateTrigger>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStateTrigger, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTrigger>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsActive(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTrigger>**)this;
            check_hresult(_winrt_abi_type->put_IsActive(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStateTriggerBaseFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStateTriggerBaseFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStateTriggerBaseFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTriggerBaseFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTriggerBaseFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::StateTriggerBase{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStateTriggerBaseProtected<D>::SetActive(bool IsActive) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStateTriggerBaseProtected>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStateTriggerBaseProtected, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTriggerBaseProtected>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetActive(IsActive));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTriggerBaseProtected>**)this;
            check_hresult(_winrt_abi_type->SetActive(IsActive));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStateTriggerStatics<D>::IsActiveProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStateTriggerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStateTriggerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTriggerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsActiveProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStateTriggerStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsActiveProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStyle<D>::IsSealed() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStyle>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStyle, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSealed(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)this;
            check_hresult(_winrt_abi_type->get_IsSealed(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStyle<D>::Setters() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStyle>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStyle, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Setters(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)this;
            check_hresult(_winrt_abi_type->get_Setters(&value));
        }
        return winrt::Windows::UI::Xaml::SetterBaseCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStyle<D>::TargetType() const
    {
        winrt::Windows::UI::Xaml::Interop::TypeName value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStyle>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStyle, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TargetType(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)this;
            check_hresult(_winrt_abi_type->get_TargetType(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStyle<D>::TargetType(winrt::Windows::UI::Xaml::Interop::TypeName const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStyle>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStyle, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TargetType(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)this;
            check_hresult(_winrt_abi_type->put_TargetType(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStyle<D>::BasedOn() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStyle>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStyle, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BasedOn(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)this;
            check_hresult(_winrt_abi_type->get_BasedOn(&value));
        }
        return winrt::Windows::UI::Xaml::Style{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStyle<D>::BasedOn(winrt::Windows::UI::Xaml::Style const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStyle>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStyle, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BasedOn(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)this;
            check_hresult(_winrt_abi_type->put_BasedOn(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStyle<D>::Seal() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStyle>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStyle, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Seal());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyle>**)this;
            check_hresult(_winrt_abi_type->Seal());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IStyleFactory<D>::CreateInstance(winrt::Windows::UI::Xaml::Interop::TypeName const& targetType) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IStyleFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IStyleFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyleFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(impl::bind_in(targetType), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IStyleFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(impl::bind_in(targetType), &value));
        }
        return winrt::Windows::UI::Xaml::Style{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_ITargetPropertyPath<D>::Path() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ITargetPropertyPath>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ITargetPropertyPath, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPath>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPath>**)this;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        return winrt::Windows::UI::Xaml::PropertyPath{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_ITargetPropertyPath<D>::Path(winrt::Windows::UI::Xaml::PropertyPath const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ITargetPropertyPath>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ITargetPropertyPath, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPath>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Path(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPath>**)this;
            check_hresult(_winrt_abi_type->put_Path(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_ITargetPropertyPath<D>::Target() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ITargetPropertyPath>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ITargetPropertyPath, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPath>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Target(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPath>**)this;
            check_hresult(_winrt_abi_type->get_Target(&value));
        }
        return winrt::Windows::Foundation::IInspectable{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_ITargetPropertyPath<D>::Target(winrt::Windows::Foundation::IInspectable const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ITargetPropertyPath>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ITargetPropertyPath, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPath>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Target(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPath>**)this;
            check_hresult(_winrt_abi_type->put_Target(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_ITargetPropertyPathFactory<D>::CreateInstance(winrt::Windows::UI::Xaml::DependencyProperty const& targetProperty) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::ITargetPropertyPathFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::ITargetPropertyPathFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPathFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&targetProperty), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::ITargetPropertyPathFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&targetProperty), &value));
        }
        return winrt::Windows::UI::Xaml::TargetPropertyPath{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IThicknessHelperStatics<D>::FromLengths(double left, double top, double right, double bottom) const
    {
        winrt::Windows::UI::Xaml::Thickness result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IThicknessHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IThicknessHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IThicknessHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromLengths(left, top, right, bottom, put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IThicknessHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromLengths(left, top, right, bottom, put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IThicknessHelperStatics<D>::FromUniformLength(double uniformLength) const
    {
        winrt::Windows::UI::Xaml::Thickness result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IThicknessHelperStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IThicknessHelperStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IThicknessHelperStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromUniformLength(uniformLength, put_abi(result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IThicknessHelperStatics>**)this;
            check_hresult(_winrt_abi_type->FromUniformLength(uniformLength, put_abi(result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DesiredSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DesiredSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_DesiredSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::AllowDrop() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowDrop(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_AllowDrop(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::AllowDrop(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AllowDrop(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_AllowDrop(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Opacity() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Opacity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_Opacity(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Opacity(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Opacity(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_Opacity(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Clip() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Clip(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_Clip(&value));
        }
        return winrt::Windows::UI::Xaml::Media::RectangleGeometry{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Clip(winrt::Windows::UI::Xaml::Media::RectangleGeometry const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Clip(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_Clip(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::RenderTransform() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RenderTransform(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_RenderTransform(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Transform{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::RenderTransform(winrt::Windows::UI::Xaml::Media::Transform const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RenderTransform(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_RenderTransform(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Projection() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Projection(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_Projection(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Projection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Projection(winrt::Windows::UI::Xaml::Media::Projection const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Projection(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_Projection(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::RenderTransformOrigin() const
    {
        winrt::Windows::Foundation::Point value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RenderTransformOrigin(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_RenderTransformOrigin(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::RenderTransformOrigin(winrt::Windows::Foundation::Point const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RenderTransformOrigin(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_RenderTransformOrigin(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsHitTestVisible() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHitTestVisible(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_IsHitTestVisible(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsHitTestVisible(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsHitTestVisible(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_IsHitTestVisible(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Visibility() const
    {
        winrt::Windows::UI::Xaml::Visibility value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Visibility(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_Visibility(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Visibility(winrt::Windows::UI::Xaml::Visibility const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Visibility(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_Visibility(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::RenderSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RenderSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_RenderSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::UseLayoutRounding() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UseLayoutRounding(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_UseLayoutRounding(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::UseLayoutRounding(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_UseLayoutRounding(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_UseLayoutRounding(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Transitions() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Transitions(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_Transitions(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Animation::TransitionCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Transitions(winrt::Windows::UI::Xaml::Media::Animation::TransitionCollection const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Transitions(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_Transitions(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::CacheMode() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CacheMode(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_CacheMode(&value));
        }
        return winrt::Windows::UI::Xaml::Media::CacheMode{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::CacheMode(winrt::Windows::UI::Xaml::Media::CacheMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CacheMode(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_CacheMode(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsTapEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTapEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_IsTapEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsTapEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsTapEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_IsTapEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsDoubleTapEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDoubleTapEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_IsDoubleTapEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsDoubleTapEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsDoubleTapEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_IsDoubleTapEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsRightTapEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsRightTapEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_IsRightTapEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsRightTapEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsRightTapEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_IsRightTapEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsHoldingEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHoldingEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_IsHoldingEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::IsHoldingEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsHoldingEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_IsHoldingEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationMode() const
    {
        winrt::Windows::UI::Xaml::Input::ManipulationModes value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ManipulationMode(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_ManipulationMode(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationMode(winrt::Windows::UI::Xaml::Input::ManipulationModes const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ManipulationMode(static_cast<uint32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->put_ManipulationMode(static_cast<uint32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerCaptures() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerCaptures(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->get_PointerCaptures(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::UI::Xaml::Input::Pointer>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::KeyUp(winrt::Windows::UI::Xaml::Input::KeyEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_KeyUp(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_KeyUp(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::KeyUp(auto_revoke_t, winrt::Windows::UI::Xaml::Input::KeyEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, KeyUp_revoker>(this, KeyUp(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::KeyUp(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_KeyUp(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_KeyUp(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::KeyDown(winrt::Windows::UI::Xaml::Input::KeyEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_KeyDown(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_KeyDown(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::KeyDown(auto_revoke_t, winrt::Windows::UI::Xaml::Input::KeyEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, KeyDown_revoker>(this, KeyDown(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::KeyDown(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_KeyDown(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_KeyDown(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::GotFocus(winrt::Windows::UI::Xaml::RoutedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_GotFocus(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_GotFocus(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::GotFocus(auto_revoke_t, winrt::Windows::UI::Xaml::RoutedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, GotFocus_revoker>(this, GotFocus(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::GotFocus(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_GotFocus(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_GotFocus(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::LostFocus(winrt::Windows::UI::Xaml::RoutedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_LostFocus(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_LostFocus(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::LostFocus(auto_revoke_t, winrt::Windows::UI::Xaml::RoutedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, LostFocus_revoker>(this, LostFocus(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::LostFocus(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_LostFocus(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_LostFocus(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DragEnter(winrt::Windows::UI::Xaml::DragEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DragEnter(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_DragEnter(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DragEnter(auto_revoke_t, winrt::Windows::UI::Xaml::DragEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, DragEnter_revoker>(this, DragEnter(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DragEnter(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DragEnter(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_DragEnter(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DragLeave(winrt::Windows::UI::Xaml::DragEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DragLeave(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_DragLeave(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DragLeave(auto_revoke_t, winrt::Windows::UI::Xaml::DragEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, DragLeave_revoker>(this, DragLeave(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DragLeave(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DragLeave(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_DragLeave(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DragOver(winrt::Windows::UI::Xaml::DragEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DragOver(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_DragOver(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DragOver(auto_revoke_t, winrt::Windows::UI::Xaml::DragEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, DragOver_revoker>(this, DragOver(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DragOver(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DragOver(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_DragOver(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Drop(winrt::Windows::UI::Xaml::DragEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Drop(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_Drop(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Drop(auto_revoke_t, winrt::Windows::UI::Xaml::DragEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, Drop_revoker>(this, Drop(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Drop(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Drop(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_Drop(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerPressed(winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PointerPressed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_PointerPressed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerPressed(auto_revoke_t, winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PointerPressed_revoker>(this, PointerPressed(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerPressed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PointerPressed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_PointerPressed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerMoved(winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PointerMoved(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_PointerMoved(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerMoved(auto_revoke_t, winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PointerMoved_revoker>(this, PointerMoved(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerMoved(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PointerMoved(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_PointerMoved(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerReleased(winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PointerReleased(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_PointerReleased(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerReleased(auto_revoke_t, winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PointerReleased_revoker>(this, PointerReleased(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerReleased(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PointerReleased(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_PointerReleased(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerEntered(winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PointerEntered(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_PointerEntered(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerEntered(auto_revoke_t, winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PointerEntered_revoker>(this, PointerEntered(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerEntered(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PointerEntered(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_PointerEntered(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerExited(winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PointerExited(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_PointerExited(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerExited(auto_revoke_t, winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PointerExited_revoker>(this, PointerExited(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerExited(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PointerExited(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_PointerExited(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerCaptureLost(winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PointerCaptureLost(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_PointerCaptureLost(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerCaptureLost(auto_revoke_t, winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PointerCaptureLost_revoker>(this, PointerCaptureLost(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerCaptureLost(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PointerCaptureLost(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_PointerCaptureLost(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerCanceled(winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PointerCanceled(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_PointerCanceled(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerCanceled(auto_revoke_t, winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PointerCanceled_revoker>(this, PointerCanceled(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerCanceled(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PointerCanceled(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_PointerCanceled(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerWheelChanged(winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PointerWheelChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_PointerWheelChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerWheelChanged(auto_revoke_t, winrt::Windows::UI::Xaml::Input::PointerEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PointerWheelChanged_revoker>(this, PointerWheelChanged(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::PointerWheelChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PointerWheelChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_PointerWheelChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Tapped(winrt::Windows::UI::Xaml::Input::TappedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Tapped(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_Tapped(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Tapped(auto_revoke_t, winrt::Windows::UI::Xaml::Input::TappedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, Tapped_revoker>(this, Tapped(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Tapped(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Tapped(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_Tapped(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DoubleTapped(winrt::Windows::UI::Xaml::Input::DoubleTappedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DoubleTapped(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_DoubleTapped(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DoubleTapped(auto_revoke_t, winrt::Windows::UI::Xaml::Input::DoubleTappedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, DoubleTapped_revoker>(this, DoubleTapped(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::DoubleTapped(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DoubleTapped(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_DoubleTapped(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Holding(winrt::Windows::UI::Xaml::Input::HoldingEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Holding(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_Holding(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Holding(auto_revoke_t, winrt::Windows::UI::Xaml::Input::HoldingEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, Holding_revoker>(this, Holding(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Holding(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Holding(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_Holding(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::RightTapped(winrt::Windows::UI::Xaml::Input::RightTappedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_RightTapped(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_RightTapped(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::RightTapped(auto_revoke_t, winrt::Windows::UI::Xaml::Input::RightTappedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, RightTapped_revoker>(this, RightTapped(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::RightTapped(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_RightTapped(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_RightTapped(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationStarting(winrt::Windows::UI::Xaml::Input::ManipulationStartingEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ManipulationStarting(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_ManipulationStarting(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationStarting(auto_revoke_t, winrt::Windows::UI::Xaml::Input::ManipulationStartingEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, ManipulationStarting_revoker>(this, ManipulationStarting(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationStarting(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ManipulationStarting(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_ManipulationStarting(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationInertiaStarting(winrt::Windows::UI::Xaml::Input::ManipulationInertiaStartingEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ManipulationInertiaStarting(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_ManipulationInertiaStarting(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationInertiaStarting(auto_revoke_t, winrt::Windows::UI::Xaml::Input::ManipulationInertiaStartingEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, ManipulationInertiaStarting_revoker>(this, ManipulationInertiaStarting(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationInertiaStarting(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ManipulationInertiaStarting(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_ManipulationInertiaStarting(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationStarted(winrt::Windows::UI::Xaml::Input::ManipulationStartedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ManipulationStarted(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_ManipulationStarted(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationStarted(auto_revoke_t, winrt::Windows::UI::Xaml::Input::ManipulationStartedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, ManipulationStarted_revoker>(this, ManipulationStarted(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationStarted(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ManipulationStarted(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_ManipulationStarted(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationDelta(winrt::Windows::UI::Xaml::Input::ManipulationDeltaEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ManipulationDelta(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_ManipulationDelta(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationDelta(auto_revoke_t, winrt::Windows::UI::Xaml::Input::ManipulationDeltaEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, ManipulationDelta_revoker>(this, ManipulationDelta(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationDelta(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ManipulationDelta(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_ManipulationDelta(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationCompleted(winrt::Windows::UI::Xaml::Input::ManipulationCompletedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ManipulationCompleted(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->add_ManipulationCompleted(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationCompleted(auto_revoke_t, winrt::Windows::UI::Xaml::Input::ManipulationCompletedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, ManipulationCompleted_revoker>(this, ManipulationCompleted(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ManipulationCompleted(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ManipulationCompleted(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            _winrt_abi_type->remove_ManipulationCompleted(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Measure(winrt::Windows::Foundation::Size const& availableSize) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Measure(impl::bind_in(availableSize)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->Measure(impl::bind_in(availableSize)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::Arrange(winrt::Windows::Foundation::Rect const& finalRect) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Arrange(impl::bind_in(finalRect)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->Arrange(impl::bind_in(finalRect)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::CapturePointer(winrt::Windows::UI::Xaml::Input::Pointer const& value) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CapturePointer(*(void**)(&value), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->CapturePointer(*(void**)(&value), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ReleasePointerCapture(winrt::Windows::UI::Xaml::Input::Pointer const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReleasePointerCapture(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->ReleasePointerCapture(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::ReleasePointerCaptures() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReleasePointerCaptures());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->ReleasePointerCaptures());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::AddHandler(winrt::Windows::UI::Xaml::RoutedEvent const& routedEvent, winrt::Windows::Foundation::IInspectable const& handler, bool handledEventsToo) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AddHandler(*(void**)(&routedEvent), *(void**)(&handler), handledEventsToo));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->AddHandler(*(void**)(&routedEvent), *(void**)(&handler), handledEventsToo));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::RemoveHandler(winrt::Windows::UI::Xaml::RoutedEvent const& routedEvent, winrt::Windows::Foundation::IInspectable const& handler) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveHandler(*(void**)(&routedEvent), *(void**)(&handler)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->RemoveHandler(*(void**)(&routedEvent), *(void**)(&handler)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::TransformToVisual(winrt::Windows::UI::Xaml::UIElement const& visual) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TransformToVisual(*(void**)(&visual), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->TransformToVisual(*(void**)(&visual), &result));
        }
        return winrt::Windows::UI::Xaml::Media::GeneralTransform{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::InvalidateMeasure() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InvalidateMeasure());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->InvalidateMeasure());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::InvalidateArrange() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InvalidateArrange());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->InvalidateArrange());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement<D>::UpdateLayout() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateLayout());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement>**)this;
            check_hresult(_winrt_abi_type->UpdateLayout());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement10<D>::ActualOffset() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement10>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement10, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualOffset(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)this;
            check_hresult(_winrt_abi_type->get_ActualOffset(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement10<D>::ActualSize() const
    {
        winrt::Windows::Foundation::Numerics::float2 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement10>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement10, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)this;
            check_hresult(_winrt_abi_type->get_ActualSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement10<D>::XamlRoot() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement10>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement10, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XamlRoot(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)this;
            check_hresult(_winrt_abi_type->get_XamlRoot(&value));
        }
        return winrt::Windows::UI::Xaml::XamlRoot{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement10<D>::XamlRoot(winrt::Windows::UI::Xaml::XamlRoot const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement10>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement10, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_XamlRoot(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)this;
            check_hresult(_winrt_abi_type->put_XamlRoot(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement10<D>::UIContext() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement10>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement10, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UIContext(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)this;
            check_hresult(_winrt_abi_type->get_UIContext(&value));
        }
        return winrt::Windows::UI::UIContext{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement10<D>::Shadow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement10>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement10, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Shadow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)this;
            check_hresult(_winrt_abi_type->get_Shadow(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Shadow{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement10<D>::Shadow(winrt::Windows::UI::Xaml::Media::Shadow const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement10>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement10, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Shadow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement10>**)this;
            check_hresult(_winrt_abi_type->put_Shadow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement2<D>::CompositeMode() const
    {
        winrt::Windows::UI::Xaml::Media::ElementCompositeMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CompositeMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement2>**)this;
            check_hresult(_winrt_abi_type->get_CompositeMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement2<D>::CompositeMode(winrt::Windows::UI::Xaml::Media::ElementCompositeMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CompositeMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement2>**)this;
            check_hresult(_winrt_abi_type->put_CompositeMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement2<D>::CancelDirectManipulations() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CancelDirectManipulations(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement2>**)this;
            check_hresult(_winrt_abi_type->CancelDirectManipulations(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::Transform3D() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Transform3D(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)this;
            check_hresult(_winrt_abi_type->get_Transform3D(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Media3D::Transform3D{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::Transform3D(winrt::Windows::UI::Xaml::Media::Media3D::Transform3D const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Transform3D(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)this;
            check_hresult(_winrt_abi_type->put_Transform3D(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::CanDrag() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanDrag(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)this;
            check_hresult(_winrt_abi_type->get_CanDrag(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::CanDrag(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CanDrag(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)this;
            check_hresult(_winrt_abi_type->put_CanDrag(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::DragStarting(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::DragStartingEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DragStarting(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)this;
            check_hresult(_winrt_abi_type->add_DragStarting(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::DragStarting(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::DragStartingEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, DragStarting_revoker>(this, DragStarting(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::DragStarting(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DragStarting(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)this;
            _winrt_abi_type->remove_DragStarting(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::DropCompleted(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::DropCompletedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DropCompleted(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)this;
            check_hresult(_winrt_abi_type->add_DropCompleted(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::DropCompleted(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::DropCompletedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, DropCompleted_revoker>(this, DropCompleted(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::DropCompleted(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DropCompleted(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)this;
            _winrt_abi_type->remove_DropCompleted(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement3<D>::StartDragAsync(winrt::Windows::UI::Input::PointerPoint const& pointerPoint) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartDragAsync(*(void**)(&pointerPoint), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement3>**)this;
            check_hresult(_winrt_abi_type->StartDragAsync(*(void**)(&pointerPoint), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ContextFlyout() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ContextFlyout(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->get_ContextFlyout(&value));
        }
        return winrt::Windows::UI::Xaml::Controls::Primitives::FlyoutBase{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ContextFlyout(winrt::Windows::UI::Xaml::Controls::Primitives::FlyoutBase const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ContextFlyout(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->put_ContextFlyout(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ExitDisplayModeOnAccessKeyInvoked() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExitDisplayModeOnAccessKeyInvoked(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->get_ExitDisplayModeOnAccessKeyInvoked(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ExitDisplayModeOnAccessKeyInvoked(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ExitDisplayModeOnAccessKeyInvoked(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->put_ExitDisplayModeOnAccessKeyInvoked(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::IsAccessKeyScope() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAccessKeyScope(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->get_IsAccessKeyScope(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::IsAccessKeyScope(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsAccessKeyScope(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->put_IsAccessKeyScope(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyScopeOwner() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AccessKeyScopeOwner(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->get_AccessKeyScopeOwner(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyObject{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyScopeOwner(winrt::Windows::UI::Xaml::DependencyObject const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AccessKeyScopeOwner(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->put_AccessKeyScopeOwner(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKey() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AccessKey(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->get_AccessKey(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKey(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AccessKey(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->put_AccessKey(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ContextRequested(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::ContextRequestedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ContextRequested(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->add_ContextRequested(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ContextRequested(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::ContextRequestedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ContextRequested_revoker>(this, ContextRequested(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ContextRequested(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ContextRequested(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            _winrt_abi_type->remove_ContextRequested(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ContextCanceled(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::RoutedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ContextCanceled(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->add_ContextCanceled(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ContextCanceled(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::RoutedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ContextCanceled_revoker>(this, ContextCanceled(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::ContextCanceled(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ContextCanceled(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            _winrt_abi_type->remove_ContextCanceled(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyDisplayRequested(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::AccessKeyDisplayRequestedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_AccessKeyDisplayRequested(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->add_AccessKeyDisplayRequested(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyDisplayRequested(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::AccessKeyDisplayRequestedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, AccessKeyDisplayRequested_revoker>(this, AccessKeyDisplayRequested(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyDisplayRequested(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            _winrt_abi_type->remove_AccessKeyDisplayRequested(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            _winrt_abi_type->remove_AccessKeyDisplayRequested(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyDisplayDismissed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::AccessKeyDisplayDismissedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_AccessKeyDisplayDismissed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->add_AccessKeyDisplayDismissed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyDisplayDismissed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::AccessKeyDisplayDismissedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, AccessKeyDisplayDismissed_revoker>(this, AccessKeyDisplayDismissed(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyDisplayDismissed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            _winrt_abi_type->remove_AccessKeyDisplayDismissed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            _winrt_abi_type->remove_AccessKeyDisplayDismissed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyInvoked(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::AccessKeyInvokedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_AccessKeyInvoked(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            check_hresult(_winrt_abi_type->add_AccessKeyInvoked(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyInvoked(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::AccessKeyInvokedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, AccessKeyInvoked_revoker>(this, AccessKeyInvoked(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement4<D>::AccessKeyInvoked(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)&_winrt_casted_result;
            _winrt_abi_type->remove_AccessKeyInvoked(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement4>**)this;
            _winrt_abi_type->remove_AccessKeyInvoked(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::Lights() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Lights(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_Lights(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::UI::Xaml::Media::XamlLight>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::KeyTipPlacementMode() const
    {
        winrt::Windows::UI::Xaml::Input::KeyTipPlacementMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyTipPlacementMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_KeyTipPlacementMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::KeyTipPlacementMode(winrt::Windows::UI::Xaml::Input::KeyTipPlacementMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_KeyTipPlacementMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_KeyTipPlacementMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::KeyTipHorizontalOffset() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyTipHorizontalOffset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_KeyTipHorizontalOffset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::KeyTipHorizontalOffset(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_KeyTipHorizontalOffset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_KeyTipHorizontalOffset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::KeyTipVerticalOffset() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyTipVerticalOffset(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_KeyTipVerticalOffset(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::KeyTipVerticalOffset(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_KeyTipVerticalOffset(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_KeyTipVerticalOffset(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusKeyboardNavigation() const
    {
        winrt::Windows::UI::Xaml::Input::XYFocusKeyboardNavigationMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusKeyboardNavigation(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusKeyboardNavigation(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusKeyboardNavigation(winrt::Windows::UI::Xaml::Input::XYFocusKeyboardNavigationMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_XYFocusKeyboardNavigation(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_XYFocusKeyboardNavigation(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusUpNavigationStrategy() const
    {
        winrt::Windows::UI::Xaml::Input::XYFocusNavigationStrategy value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusUpNavigationStrategy(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusUpNavigationStrategy(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusUpNavigationStrategy(winrt::Windows::UI::Xaml::Input::XYFocusNavigationStrategy const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_XYFocusUpNavigationStrategy(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_XYFocusUpNavigationStrategy(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusDownNavigationStrategy() const
    {
        winrt::Windows::UI::Xaml::Input::XYFocusNavigationStrategy value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusDownNavigationStrategy(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusDownNavigationStrategy(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusDownNavigationStrategy(winrt::Windows::UI::Xaml::Input::XYFocusNavigationStrategy const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_XYFocusDownNavigationStrategy(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_XYFocusDownNavigationStrategy(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusLeftNavigationStrategy() const
    {
        winrt::Windows::UI::Xaml::Input::XYFocusNavigationStrategy value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusLeftNavigationStrategy(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusLeftNavigationStrategy(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusLeftNavigationStrategy(winrt::Windows::UI::Xaml::Input::XYFocusNavigationStrategy const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_XYFocusLeftNavigationStrategy(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_XYFocusLeftNavigationStrategy(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusRightNavigationStrategy() const
    {
        winrt::Windows::UI::Xaml::Input::XYFocusNavigationStrategy value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusRightNavigationStrategy(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusRightNavigationStrategy(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::XYFocusRightNavigationStrategy(winrt::Windows::UI::Xaml::Input::XYFocusNavigationStrategy const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_XYFocusRightNavigationStrategy(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_XYFocusRightNavigationStrategy(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::HighContrastAdjustment() const
    {
        winrt::Windows::UI::Xaml::ElementHighContrastAdjustment value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HighContrastAdjustment(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_HighContrastAdjustment(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::HighContrastAdjustment(winrt::Windows::UI::Xaml::ElementHighContrastAdjustment const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HighContrastAdjustment(static_cast<uint32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_HighContrastAdjustment(static_cast<uint32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::TabFocusNavigation() const
    {
        winrt::Windows::UI::Xaml::Input::KeyboardNavigationMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TabFocusNavigation(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->get_TabFocusNavigation(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::TabFocusNavigation(winrt::Windows::UI::Xaml::Input::KeyboardNavigationMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TabFocusNavigation(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->put_TabFocusNavigation(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::GettingFocus(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::GettingFocusEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_GettingFocus(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->add_GettingFocus(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::GettingFocus(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::GettingFocusEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, GettingFocus_revoker>(this, GettingFocus(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::GettingFocus(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            _winrt_abi_type->remove_GettingFocus(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            _winrt_abi_type->remove_GettingFocus(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::LosingFocus(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::LosingFocusEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_LosingFocus(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->add_LosingFocus(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::LosingFocus(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::LosingFocusEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, LosingFocus_revoker>(this, LosingFocus(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::LosingFocus(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            _winrt_abi_type->remove_LosingFocus(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            _winrt_abi_type->remove_LosingFocus(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::NoFocusCandidateFound(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::NoFocusCandidateFoundEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_NoFocusCandidateFound(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->add_NoFocusCandidateFound(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::NoFocusCandidateFound(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::NoFocusCandidateFoundEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, NoFocusCandidateFound_revoker>(this, NoFocusCandidateFound(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::NoFocusCandidateFound(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            _winrt_abi_type->remove_NoFocusCandidateFound(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            _winrt_abi_type->remove_NoFocusCandidateFound(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::StartBringIntoView() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartBringIntoView());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->StartBringIntoView());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement5<D>::StartBringIntoView(winrt::Windows::UI::Xaml::BringIntoViewOptions const& options) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartBringIntoViewWithOptions(*(void**)(&options)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement5>**)this;
            check_hresult(_winrt_abi_type->StartBringIntoViewWithOptions(*(void**)(&options)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::KeyboardAccelerators() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyboardAccelerators(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            check_hresult(_winrt_abi_type->get_KeyboardAccelerators(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::UI::Xaml::Input::KeyboardAccelerator>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::CharacterReceived(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::CharacterReceivedRoutedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_CharacterReceived(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            check_hresult(_winrt_abi_type->add_CharacterReceived(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::CharacterReceived(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::CharacterReceivedRoutedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, CharacterReceived_revoker>(this, CharacterReceived(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::CharacterReceived(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            _winrt_abi_type->remove_CharacterReceived(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            _winrt_abi_type->remove_CharacterReceived(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::ProcessKeyboardAccelerators(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::ProcessKeyboardAcceleratorEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ProcessKeyboardAccelerators(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            check_hresult(_winrt_abi_type->add_ProcessKeyboardAccelerators(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::ProcessKeyboardAccelerators(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::Input::ProcessKeyboardAcceleratorEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ProcessKeyboardAccelerators_revoker>(this, ProcessKeyboardAccelerators(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::ProcessKeyboardAccelerators(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ProcessKeyboardAccelerators(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            _winrt_abi_type->remove_ProcessKeyboardAccelerators(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::PreviewKeyDown(winrt::Windows::UI::Xaml::Input::KeyEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PreviewKeyDown(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            check_hresult(_winrt_abi_type->add_PreviewKeyDown(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::PreviewKeyDown(auto_revoke_t, winrt::Windows::UI::Xaml::Input::KeyEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PreviewKeyDown_revoker>(this, PreviewKeyDown(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::PreviewKeyDown(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PreviewKeyDown(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            _winrt_abi_type->remove_PreviewKeyDown(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::PreviewKeyUp(winrt::Windows::UI::Xaml::Input::KeyEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PreviewKeyUp(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            check_hresult(_winrt_abi_type->add_PreviewKeyUp(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::PreviewKeyUp(auto_revoke_t, winrt::Windows::UI::Xaml::Input::KeyEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, PreviewKeyUp_revoker>(this, PreviewKeyUp(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::PreviewKeyUp(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PreviewKeyUp(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            _winrt_abi_type->remove_PreviewKeyUp(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement7<D>::TryInvokeKeyboardAccelerator(winrt::Windows::UI::Xaml::Input::ProcessKeyboardAcceleratorEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryInvokeKeyboardAccelerator(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement7>**)this;
            check_hresult(_winrt_abi_type->TryInvokeKeyboardAccelerator(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement8<D>::KeyTipTarget() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyTipTarget(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)this;
            check_hresult(_winrt_abi_type->get_KeyTipTarget(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyObject{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement8<D>::KeyTipTarget(winrt::Windows::UI::Xaml::DependencyObject const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_KeyTipTarget(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)this;
            check_hresult(_winrt_abi_type->put_KeyTipTarget(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement8<D>::KeyboardAcceleratorPlacementTarget() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyboardAcceleratorPlacementTarget(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)this;
            check_hresult(_winrt_abi_type->get_KeyboardAcceleratorPlacementTarget(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyObject{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement8<D>::KeyboardAcceleratorPlacementTarget(winrt::Windows::UI::Xaml::DependencyObject const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_KeyboardAcceleratorPlacementTarget(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)this;
            check_hresult(_winrt_abi_type->put_KeyboardAcceleratorPlacementTarget(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement8<D>::KeyboardAcceleratorPlacementMode() const
    {
        winrt::Windows::UI::Xaml::Input::KeyboardAcceleratorPlacementMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyboardAcceleratorPlacementMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)this;
            check_hresult(_winrt_abi_type->get_KeyboardAcceleratorPlacementMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement8<D>::KeyboardAcceleratorPlacementMode(winrt::Windows::UI::Xaml::Input::KeyboardAcceleratorPlacementMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_KeyboardAcceleratorPlacementMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)this;
            check_hresult(_winrt_abi_type->put_KeyboardAcceleratorPlacementMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement8<D>::BringIntoViewRequested(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::BringIntoViewRequestedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_BringIntoViewRequested(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)this;
            check_hresult(_winrt_abi_type->add_BringIntoViewRequested(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement8<D>::BringIntoViewRequested(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::UIElement, winrt::Windows::UI::Xaml::BringIntoViewRequestedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, BringIntoViewRequested_revoker>(this, BringIntoViewRequested(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement8<D>::BringIntoViewRequested(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)&_winrt_casted_result;
            _winrt_abi_type->remove_BringIntoViewRequested(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement8>**)this;
            _winrt_abi_type->remove_BringIntoViewRequested(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::CanBeScrollAnchor() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanBeScrollAnchor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_CanBeScrollAnchor(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::CanBeScrollAnchor(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CanBeScrollAnchor(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_CanBeScrollAnchor(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::OpacityTransition() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OpacityTransition(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_OpacityTransition(&value));
        }
        return winrt::Windows::UI::Xaml::ScalarTransition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::OpacityTransition(winrt::Windows::UI::Xaml::ScalarTransition const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_OpacityTransition(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_OpacityTransition(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::Translation() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Translation(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_Translation(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::Translation(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Translation(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_Translation(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::TranslationTransition() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TranslationTransition(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_TranslationTransition(&value));
        }
        return winrt::Windows::UI::Xaml::Vector3Transition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::TranslationTransition(winrt::Windows::UI::Xaml::Vector3Transition const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TranslationTransition(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_TranslationTransition(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::Rotation() const
    {
        float value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Rotation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_Rotation(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::Rotation(float value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Rotation(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_Rotation(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::RotationTransition() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationTransition(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_RotationTransition(&value));
        }
        return winrt::Windows::UI::Xaml::ScalarTransition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::RotationTransition(winrt::Windows::UI::Xaml::ScalarTransition const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationTransition(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_RotationTransition(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::Scale() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_Scale(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::Scale(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_Scale(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::ScaleTransition() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ScaleTransition(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_ScaleTransition(&value));
        }
        return winrt::Windows::UI::Xaml::Vector3Transition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::ScaleTransition(winrt::Windows::UI::Xaml::Vector3Transition const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ScaleTransition(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_ScaleTransition(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::TransformMatrix() const
    {
        winrt::Windows::Foundation::Numerics::float4x4 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_TransformMatrix(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::TransformMatrix(winrt::Windows::Foundation::Numerics::float4x4 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_TransformMatrix(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::CenterPoint() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_CenterPoint(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::CenterPoint(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_CenterPoint(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::RotationAxis() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotationAxis(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->get_RotationAxis(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::RotationAxis(winrt::Windows::Foundation::Numerics::float3 const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RotationAxis(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->put_RotationAxis(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::StartAnimation(winrt::Windows::UI::Composition::ICompositionAnimationBase const& animation) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAnimation(*(void**)(&animation)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->StartAnimation(*(void**)(&animation)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElement9<D>::StopAnimation(winrt::Windows::UI::Composition::ICompositionAnimationBase const& animation) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElement9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElement9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StopAnimation(*(void**)(&animation)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElement9>**)this;
            check_hresult(_winrt_abi_type->StopAnimation(*(void**)(&animation)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementOverrides<D>::OnCreateAutomationPeer() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnCreateAutomationPeer(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides>**)this;
            check_hresult(_winrt_abi_type->OnCreateAutomationPeer(&result));
        }
        return winrt::Windows::UI::Xaml::Automation::Peers::AutomationPeer{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementOverrides<D>::OnDisconnectVisualChildren() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnDisconnectVisualChildren());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides>**)this;
            check_hresult(_winrt_abi_type->OnDisconnectVisualChildren());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementOverrides<D>::FindSubElementsForTouchTargeting(winrt::Windows::Foundation::Point const& point, winrt::Windows::Foundation::Rect const& boundingRect) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FindSubElementsForTouchTargeting(impl::bind_in(point), impl::bind_in(boundingRect), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides>**)this;
            check_hresult(_winrt_abi_type->FindSubElementsForTouchTargeting(impl::bind_in(point), impl::bind_in(boundingRect), &result));
        }
        return winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Foundation::Point>>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementOverrides7<D>::GetChildrenInTabFocusOrder() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementOverrides7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementOverrides7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetChildrenInTabFocusOrder(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides7>**)this;
            check_hresult(_winrt_abi_type->GetChildrenInTabFocusOrder(&result));
        }
        return winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::UI::Xaml::DependencyObject>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementOverrides7<D>::OnProcessKeyboardAccelerators(winrt::Windows::UI::Xaml::Input::ProcessKeyboardAcceleratorEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementOverrides7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementOverrides7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnProcessKeyboardAccelerators(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides7>**)this;
            check_hresult(_winrt_abi_type->OnProcessKeyboardAccelerators(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementOverrides8<D>::OnKeyboardAcceleratorInvoked(winrt::Windows::UI::Xaml::Input::KeyboardAcceleratorInvokedEventArgs const& args) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementOverrides8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementOverrides8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnKeyboardAcceleratorInvoked(*(void**)(&args)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides8>**)this;
            check_hresult(_winrt_abi_type->OnKeyboardAcceleratorInvoked(*(void**)(&args)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementOverrides8<D>::OnBringIntoViewRequested(winrt::Windows::UI::Xaml::BringIntoViewRequestedEventArgs const& e) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementOverrides8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementOverrides8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OnBringIntoViewRequested(*(void**)(&e)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides8>**)this;
            check_hresult(_winrt_abi_type->OnBringIntoViewRequested(*(void**)(&e)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementOverrides9<D>::PopulatePropertyInfoOverride(param::hstring const& propertyName, winrt::Windows::UI::Composition::AnimationPropertyInfo const& animationPropertyInfo) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementOverrides9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementOverrides9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PopulatePropertyInfoOverride(*(void**)(&propertyName), *(void**)(&animationPropertyInfo)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementOverrides9>**)this;
            check_hresult(_winrt_abi_type->PopulatePropertyInfoOverride(*(void**)(&propertyName), *(void**)(&animationPropertyInfo)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::KeyDownEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyDownEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_KeyDownEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::KeyUpEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyUpEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_KeyUpEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::PointerEnteredEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerEnteredEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_PointerEnteredEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::PointerPressedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerPressedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_PointerPressedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::PointerMovedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerMovedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_PointerMovedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::PointerReleasedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerReleasedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_PointerReleasedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::PointerExitedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerExitedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_PointerExitedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::PointerCaptureLostEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerCaptureLostEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_PointerCaptureLostEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::PointerCanceledEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerCanceledEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_PointerCanceledEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::PointerWheelChangedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerWheelChangedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_PointerWheelChangedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::TappedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TappedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_TappedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::DoubleTappedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DoubleTappedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_DoubleTappedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::HoldingEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HoldingEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_HoldingEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::RightTappedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RightTappedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_RightTappedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::ManipulationStartingEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ManipulationStartingEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ManipulationStartingEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::ManipulationInertiaStartingEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ManipulationInertiaStartingEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ManipulationInertiaStartingEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::ManipulationStartedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ManipulationStartedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ManipulationStartedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::ManipulationDeltaEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ManipulationDeltaEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ManipulationDeltaEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::ManipulationCompletedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ManipulationCompletedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ManipulationCompletedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::DragEnterEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DragEnterEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_DragEnterEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::DragLeaveEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DragLeaveEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_DragLeaveEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::DragOverEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DragOverEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_DragOverEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::DropEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DropEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_DropEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::AllowDropProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowDropProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_AllowDropProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::OpacityProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OpacityProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_OpacityProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::ClipProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ClipProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ClipProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::RenderTransformProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RenderTransformProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_RenderTransformProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::ProjectionProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProjectionProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ProjectionProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::RenderTransformOriginProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RenderTransformOriginProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_RenderTransformOriginProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::IsHitTestVisibleProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHitTestVisibleProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsHitTestVisibleProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::VisibilityProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VisibilityProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_VisibilityProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::UseLayoutRoundingProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UseLayoutRoundingProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_UseLayoutRoundingProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::TransitionsProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransitionsProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_TransitionsProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::CacheModeProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CacheModeProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_CacheModeProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::IsTapEnabledProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTapEnabledProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsTapEnabledProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::IsDoubleTapEnabledProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDoubleTapEnabledProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsDoubleTapEnabledProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::IsRightTapEnabledProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsRightTapEnabledProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsRightTapEnabledProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::IsHoldingEnabledProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHoldingEnabledProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsHoldingEnabledProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::ManipulationModeProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ManipulationModeProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_ManipulationModeProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics<D>::PointerCapturesProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PointerCapturesProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics>**)this;
            check_hresult(_winrt_abi_type->get_PointerCapturesProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics10<D>::ShadowProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics10>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics10, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics10>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ShadowProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics10>**)this;
            check_hresult(_winrt_abi_type->get_ShadowProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics2<D>::CompositeModeProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CompositeModeProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics2>**)this;
            check_hresult(_winrt_abi_type->get_CompositeModeProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics3<D>::Transform3DProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Transform3DProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics3>**)this;
            check_hresult(_winrt_abi_type->get_Transform3DProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics3<D>::CanDragProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanDragProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics3>**)this;
            check_hresult(_winrt_abi_type->get_CanDragProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics3<D>::TryStartDirectManipulation(winrt::Windows::UI::Xaml::Input::Pointer const& value) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryStartDirectManipulation(*(void**)(&value), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics3>**)this;
            check_hresult(_winrt_abi_type->TryStartDirectManipulation(*(void**)(&value), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics4<D>::ContextFlyoutProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ContextFlyoutProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_ContextFlyoutProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics4<D>::ExitDisplayModeOnAccessKeyInvokedProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExitDisplayModeOnAccessKeyInvokedProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_ExitDisplayModeOnAccessKeyInvokedProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics4<D>::IsAccessKeyScopeProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAccessKeyScopeProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_IsAccessKeyScopeProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics4<D>::AccessKeyScopeOwnerProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AccessKeyScopeOwnerProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_AccessKeyScopeOwnerProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics4<D>::AccessKeyProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AccessKeyProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics4>**)this;
            check_hresult(_winrt_abi_type->get_AccessKeyProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::LightsProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LightsProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_LightsProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::KeyTipPlacementModeProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyTipPlacementModeProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_KeyTipPlacementModeProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::KeyTipHorizontalOffsetProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyTipHorizontalOffsetProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_KeyTipHorizontalOffsetProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::KeyTipVerticalOffsetProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyTipVerticalOffsetProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_KeyTipVerticalOffsetProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::XYFocusKeyboardNavigationProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusKeyboardNavigationProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusKeyboardNavigationProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::XYFocusUpNavigationStrategyProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusUpNavigationStrategyProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusUpNavigationStrategyProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::XYFocusDownNavigationStrategyProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusDownNavigationStrategyProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusDownNavigationStrategyProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::XYFocusLeftNavigationStrategyProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusLeftNavigationStrategyProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusLeftNavigationStrategyProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::XYFocusRightNavigationStrategyProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_XYFocusRightNavigationStrategyProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_XYFocusRightNavigationStrategyProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::HighContrastAdjustmentProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HighContrastAdjustmentProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_HighContrastAdjustmentProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics5<D>::TabFocusNavigationProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TabFocusNavigationProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics5>**)this;
            check_hresult(_winrt_abi_type->get_TabFocusNavigationProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics6<D>::GettingFocusEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GettingFocusEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics6>**)this;
            check_hresult(_winrt_abi_type->get_GettingFocusEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics6<D>::LosingFocusEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LosingFocusEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics6>**)this;
            check_hresult(_winrt_abi_type->get_LosingFocusEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics6<D>::NoFocusCandidateFoundEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_NoFocusCandidateFoundEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics6>**)this;
            check_hresult(_winrt_abi_type->get_NoFocusCandidateFoundEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics7<D>::PreviewKeyDownEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PreviewKeyDownEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics7>**)this;
            check_hresult(_winrt_abi_type->get_PreviewKeyDownEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics7<D>::CharacterReceivedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CharacterReceivedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics7>**)this;
            check_hresult(_winrt_abi_type->get_CharacterReceivedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics7<D>::PreviewKeyUpEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PreviewKeyUpEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics7>**)this;
            check_hresult(_winrt_abi_type->get_PreviewKeyUpEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics8<D>::BringIntoViewRequestedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BringIntoViewRequestedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)this;
            check_hresult(_winrt_abi_type->get_BringIntoViewRequestedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics8<D>::ContextRequestedEvent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ContextRequestedEvent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)this;
            check_hresult(_winrt_abi_type->get_ContextRequestedEvent(&value));
        }
        return winrt::Windows::UI::Xaml::RoutedEvent{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics8<D>::KeyTipTargetProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyTipTargetProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)this;
            check_hresult(_winrt_abi_type->get_KeyTipTargetProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics8<D>::KeyboardAcceleratorPlacementTargetProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyboardAcceleratorPlacementTargetProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)this;
            check_hresult(_winrt_abi_type->get_KeyboardAcceleratorPlacementTargetProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics8<D>::KeyboardAcceleratorPlacementModeProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KeyboardAcceleratorPlacementModeProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)this;
            check_hresult(_winrt_abi_type->get_KeyboardAcceleratorPlacementModeProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics8<D>::RegisterAsScrollPort(winrt::Windows::UI::Xaml::UIElement const& element) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics8>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics8, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RegisterAsScrollPort(*(void**)(&element)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics8>**)this;
            check_hresult(_winrt_abi_type->RegisterAsScrollPort(*(void**)(&element)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementStatics9<D>::CanBeScrollAnchorProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementStatics9>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementStatics9, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics9>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanBeScrollAnchorProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementStatics9>**)this;
            check_hresult(_winrt_abi_type->get_CanBeScrollAnchorProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUIElementWeakCollectionFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUIElementWeakCollectionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUIElementWeakCollectionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementWeakCollectionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUIElementWeakCollectionFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::UIElementWeakCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUnhandledExceptionEventArgs<D>::Exception() const
    {
        winrt::hresult value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Exception(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Exception(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUnhandledExceptionEventArgs<D>::Message() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUnhandledExceptionEventArgs<D>::Handled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Handled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Handled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IUnhandledExceptionEventArgs<D>::Handled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Handled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IUnhandledExceptionEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_Handled(value));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVector3Transition<D>::Duration() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVector3Transition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVector3Transition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3Transition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3Transition>**)this;
            check_hresult(_winrt_abi_type->get_Duration(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVector3Transition<D>::Duration(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVector3Transition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVector3Transition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3Transition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Duration(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3Transition>**)this;
            check_hresult(_winrt_abi_type->put_Duration(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVector3Transition<D>::Components() const
    {
        winrt::Windows::UI::Xaml::Vector3TransitionComponents value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVector3Transition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVector3Transition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3Transition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Components(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3Transition>**)this;
            check_hresult(_winrt_abi_type->get_Components(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVector3Transition<D>::Components(winrt::Windows::UI::Xaml::Vector3TransitionComponents const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVector3Transition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVector3Transition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3Transition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Components(static_cast<uint32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3Transition>**)this;
            check_hresult(_winrt_abi_type->put_Components(static_cast<uint32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVector3TransitionFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVector3TransitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVector3TransitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3TransitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVector3TransitionFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::Vector3Transition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualState<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualState>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualState, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualState<D>::Storyboard() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualState>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualState, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Storyboard(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState>**)this;
            check_hresult(_winrt_abi_type->get_Storyboard(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Animation::Storyboard{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualState<D>::Storyboard(winrt::Windows::UI::Xaml::Media::Animation::Storyboard const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualState>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualState, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Storyboard(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState>**)this;
            check_hresult(_winrt_abi_type->put_Storyboard(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualState2<D>::Setters() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualState2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualState2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Setters(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState2>**)this;
            check_hresult(_winrt_abi_type->get_Setters(&value));
        }
        return winrt::Windows::UI::Xaml::SetterBaseCollection{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualState2<D>::StateTriggers() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualState2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualState2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StateTriggers(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualState2>**)this;
            check_hresult(_winrt_abi_type->get_StateTriggers(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::UI::Xaml::StateTriggerBase>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateChangedEventArgs<D>::OldState() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OldState(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_OldState(&value));
        }
        return winrt::Windows::UI::Xaml::VisualState{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateChangedEventArgs<D>::OldState(winrt::Windows::UI::Xaml::VisualState const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_OldState(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_OldState(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateChangedEventArgs<D>::NewState() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_NewState(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_NewState(&value));
        }
        return winrt::Windows::UI::Xaml::VisualState{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateChangedEventArgs<D>::NewState(winrt::Windows::UI::Xaml::VisualState const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_NewState(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_NewState(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateChangedEventArgs<D>::Control() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Control(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Control(&value));
        }
        return winrt::Windows::UI::Xaml::Controls::Control{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateChangedEventArgs<D>::Control(winrt::Windows::UI::Xaml::Controls::Control const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Control(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->put_Control(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::Transitions() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Transitions(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)this;
            check_hresult(_winrt_abi_type->get_Transitions(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::UI::Xaml::VisualTransition>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::States() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_States(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)this;
            check_hresult(_winrt_abi_type->get_States(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::UI::Xaml::VisualState>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::CurrentState() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CurrentState(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)this;
            check_hresult(_winrt_abi_type->get_CurrentState(&value));
        }
        return winrt::Windows::UI::Xaml::VisualState{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::CurrentStateChanged(winrt::Windows::UI::Xaml::VisualStateChangedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_CurrentStateChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)this;
            check_hresult(_winrt_abi_type->add_CurrentStateChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::CurrentStateChanged(auto_revoke_t, winrt::Windows::UI::Xaml::VisualStateChangedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, CurrentStateChanged_revoker>(this, CurrentStateChanged(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::CurrentStateChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)&_winrt_casted_result;
            _winrt_abi_type->remove_CurrentStateChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)this;
            _winrt_abi_type->remove_CurrentStateChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::CurrentStateChanging(winrt::Windows::UI::Xaml::VisualStateChangedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_CurrentStateChanging(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)this;
            check_hresult(_winrt_abi_type->add_CurrentStateChanging(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::CurrentStateChanging(auto_revoke_t, winrt::Windows::UI::Xaml::VisualStateChangedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, CurrentStateChanging_revoker>(this, CurrentStateChanging(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateGroup<D>::CurrentStateChanging(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateGroup>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateGroup, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)&_winrt_casted_result;
            _winrt_abi_type->remove_CurrentStateChanging(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateGroup>**)this;
            _winrt_abi_type->remove_CurrentStateChanging(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateManagerFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateManagerFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateManagerFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::VisualStateManager{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateManagerOverrides<D>::GoToStateCore(winrt::Windows::UI::Xaml::Controls::Control const& control, winrt::Windows::UI::Xaml::FrameworkElement const& templateRoot, param::hstring const& stateName, winrt::Windows::UI::Xaml::VisualStateGroup const& group, winrt::Windows::UI::Xaml::VisualState const& state, bool useTransitions) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateManagerOverrides>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateManagerOverrides, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerOverrides>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GoToStateCore(*(void**)(&control), *(void**)(&templateRoot), *(void**)(&stateName), *(void**)(&group), *(void**)(&state), useTransitions, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerOverrides>**)this;
            check_hresult(_winrt_abi_type->GoToStateCore(*(void**)(&control), *(void**)(&templateRoot), *(void**)(&stateName), *(void**)(&group), *(void**)(&state), useTransitions, &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateManagerProtected<D>::RaiseCurrentStateChanging(winrt::Windows::UI::Xaml::VisualStateGroup const& stateGroup, winrt::Windows::UI::Xaml::VisualState const& oldState, winrt::Windows::UI::Xaml::VisualState const& newState, winrt::Windows::UI::Xaml::Controls::Control const& control) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateManagerProtected>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateManagerProtected, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerProtected>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RaiseCurrentStateChanging(*(void**)(&stateGroup), *(void**)(&oldState), *(void**)(&newState), *(void**)(&control)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerProtected>**)this;
            check_hresult(_winrt_abi_type->RaiseCurrentStateChanging(*(void**)(&stateGroup), *(void**)(&oldState), *(void**)(&newState), *(void**)(&control)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateManagerProtected<D>::RaiseCurrentStateChanged(winrt::Windows::UI::Xaml::VisualStateGroup const& stateGroup, winrt::Windows::UI::Xaml::VisualState const& oldState, winrt::Windows::UI::Xaml::VisualState const& newState, winrt::Windows::UI::Xaml::Controls::Control const& control) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateManagerProtected>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateManagerProtected, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerProtected>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RaiseCurrentStateChanged(*(void**)(&stateGroup), *(void**)(&oldState), *(void**)(&newState), *(void**)(&control)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerProtected>**)this;
            check_hresult(_winrt_abi_type->RaiseCurrentStateChanged(*(void**)(&stateGroup), *(void**)(&oldState), *(void**)(&newState), *(void**)(&control)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateManagerStatics<D>::GetVisualStateGroups(winrt::Windows::UI::Xaml::FrameworkElement const& obj) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetVisualStateGroups(*(void**)(&obj), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)this;
            check_hresult(_winrt_abi_type->GetVisualStateGroups(*(void**)(&obj), &result));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::UI::Xaml::VisualStateGroup>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateManagerStatics<D>::CustomVisualStateManagerProperty() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CustomVisualStateManagerProperty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)this;
            check_hresult(_winrt_abi_type->get_CustomVisualStateManagerProperty(&value));
        }
        return winrt::Windows::UI::Xaml::DependencyProperty{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateManagerStatics<D>::GetCustomVisualStateManager(winrt::Windows::UI::Xaml::FrameworkElement const& obj) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCustomVisualStateManager(*(void**)(&obj), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)this;
            check_hresult(_winrt_abi_type->GetCustomVisualStateManager(*(void**)(&obj), &result));
        }
        return winrt::Windows::UI::Xaml::VisualStateManager{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateManagerStatics<D>::SetCustomVisualStateManager(winrt::Windows::UI::Xaml::FrameworkElement const& obj, winrt::Windows::UI::Xaml::VisualStateManager const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetCustomVisualStateManager(*(void**)(&obj), *(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)this;
            check_hresult(_winrt_abi_type->SetCustomVisualStateManager(*(void**)(&obj), *(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualStateManagerStatics<D>::GoToState(winrt::Windows::UI::Xaml::Controls::Control const& control, param::hstring const& stateName, bool useTransitions) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualStateManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualStateManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GoToState(*(void**)(&control), *(void**)(&stateName), useTransitions, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualStateManagerStatics>**)this;
            check_hresult(_winrt_abi_type->GoToState(*(void**)(&control), *(void**)(&stateName), useTransitions, &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::GeneratedDuration() const
    {
        winrt::Windows::UI::Xaml::Duration value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GeneratedDuration(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->get_GeneratedDuration(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::GeneratedDuration(winrt::Windows::UI::Xaml::Duration const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_GeneratedDuration(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->put_GeneratedDuration(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::GeneratedEasingFunction() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GeneratedEasingFunction(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->get_GeneratedEasingFunction(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Animation::EasingFunctionBase{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::GeneratedEasingFunction(winrt::Windows::UI::Xaml::Media::Animation::EasingFunctionBase const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_GeneratedEasingFunction(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->put_GeneratedEasingFunction(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::To() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_To(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->get_To(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::To(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_To(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->put_To(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::From() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_From(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->get_From(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::From(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_From(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->put_From(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::Storyboard() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Storyboard(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->get_Storyboard(&value));
        }
        return winrt::Windows::UI::Xaml::Media::Animation::Storyboard{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransition<D>::Storyboard(winrt::Windows::UI::Xaml::Media::Animation::Storyboard const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransition>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransition, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Storyboard(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransition>**)this;
            check_hresult(_winrt_abi_type->put_Storyboard(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IVisualTransitionFactory<D>::CreateInstance(winrt::Windows::Foundation::IInspectable const& baseInterface, winrt::Windows::Foundation::IInspectable& innerInterface) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IVisualTransitionFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IVisualTransitionFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransitionFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IVisualTransitionFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&baseInterface), impl::bind_out(innerInterface), &value));
        }
        return winrt::Windows::UI::Xaml::VisualTransition{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Bounds() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Bounds(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->get_Bounds(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Visible() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Visible(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->get_Visible(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Content() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Content(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->get_Content(&value));
        }
        return winrt::Windows::UI::Xaml::UIElement{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Content(winrt::Windows::UI::Xaml::UIElement const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Content(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->put_Content(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::CoreWindow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CoreWindow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->get_CoreWindow(&value));
        }
        return winrt::Windows::UI::Core::CoreWindow{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Dispatcher() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Dispatcher(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->get_Dispatcher(&value));
        }
        return winrt::Windows::UI::Core::CoreDispatcher{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Activated(winrt::Windows::UI::Xaml::WindowActivatedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Activated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->add_Activated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Activated(auto_revoke_t, winrt::Windows::UI::Xaml::WindowActivatedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, Activated_revoker>(this, Activated(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Activated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Activated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            _winrt_abi_type->remove_Activated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Closed(winrt::Windows::UI::Xaml::WindowClosedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Closed(auto_revoke_t, winrt::Windows::UI::Xaml::WindowClosedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, Closed_revoker>(this, Closed(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Closed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::SizeChanged(winrt::Windows::UI::Xaml::WindowSizeChangedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_SizeChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->add_SizeChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::SizeChanged(auto_revoke_t, winrt::Windows::UI::Xaml::WindowSizeChangedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, SizeChanged_revoker>(this, SizeChanged(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::SizeChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            _winrt_abi_type->remove_SizeChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            _winrt_abi_type->remove_SizeChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::VisibilityChanged(winrt::Windows::UI::Xaml::WindowVisibilityChangedEventHandler const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_VisibilityChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->add_VisibilityChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::VisibilityChanged(auto_revoke_t, winrt::Windows::UI::Xaml::WindowVisibilityChangedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, VisibilityChanged_revoker>(this, VisibilityChanged(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::VisibilityChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            _winrt_abi_type->remove_VisibilityChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            _winrt_abi_type->remove_VisibilityChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Activate() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Activate());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->Activate());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow<D>::Close() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Close());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow>**)this;
            check_hresult(_winrt_abi_type->Close());
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow2<D>::SetTitleBar(winrt::Windows::UI::Xaml::UIElement const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetTitleBar(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow2>**)this;
            check_hresult(_winrt_abi_type->SetTitleBar(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow3<D>::Compositor() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Compositor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow3>**)this;
            check_hresult(_winrt_abi_type->get_Compositor(&value));
        }
        return winrt::Windows::UI::Composition::Compositor{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindow4<D>::UIContext() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindow4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindow4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UIContext(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindow4>**)this;
            check_hresult(_winrt_abi_type->get_UIContext(&value));
        }
        return winrt::Windows::UI::UIContext{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindowCreatedEventArgs<D>::Window() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindowCreatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindowCreatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindowCreatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Window(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindowCreatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Window(&value));
        }
        return winrt::Windows::UI::Xaml::Window{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IWindowStatics<D>::Current() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IWindowStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IWindowStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindowStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Current(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IWindowStatics>**)this;
            check_hresult(_winrt_abi_type->get_Current(&value));
        }
        return winrt::Windows::UI::Xaml::Window{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IXamlRoot<D>::Content() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IXamlRoot>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IXamlRoot, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Content(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)this;
            check_hresult(_winrt_abi_type->get_Content(&value));
        }
        return winrt::Windows::UI::Xaml::UIElement{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IXamlRoot<D>::Size() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IXamlRoot>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IXamlRoot, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)this;
            check_hresult(_winrt_abi_type->get_Size(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IXamlRoot<D>::RasterizationScale() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IXamlRoot>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IXamlRoot, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RasterizationScale(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)this;
            check_hresult(_winrt_abi_type->get_RasterizationScale(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IXamlRoot<D>::IsHostVisible() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IXamlRoot>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IXamlRoot, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHostVisible(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)this;
            check_hresult(_winrt_abi_type->get_IsHostVisible(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IXamlRoot<D>::UIContext() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IXamlRoot>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IXamlRoot, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UIContext(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)this;
            check_hresult(_winrt_abi_type->get_UIContext(&value));
        }
        return winrt::Windows::UI::UIContext{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Xaml_IXamlRoot<D>::Changed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::XamlRoot, winrt::Windows::UI::Xaml::XamlRootChangedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IXamlRoot>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IXamlRoot, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Changed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)this;
            check_hresult(_winrt_abi_type->add_Changed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_UI_Xaml_IXamlRoot<D>::Changed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::XamlRoot, winrt::Windows::UI::Xaml::XamlRootChangedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Changed_revoker>(this, Changed(handler));
    }
    template <typename D> auto consume_Windows_UI_Xaml_IXamlRoot<D>::Changed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Xaml::IXamlRoot>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Xaml::IXamlRoot, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Changed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Xaml::IXamlRoot>**)this;
            _winrt_abi_type->remove_Changed(impl::bind_in(token));
        }
    }
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::ApplicationInitializationCallback, H> final : implements_delegate<winrt::Windows::UI::Xaml::ApplicationInitializationCallback, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::ApplicationInitializationCallback, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* p) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::UI::Xaml::ApplicationInitializationCallbackParams const*>(&p));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::BindingFailedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::BindingFailedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::BindingFailedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Xaml::BindingFailedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::CreateDefaultValueCallback, H> final : implements_delegate<winrt::Windows::UI::Xaml::CreateDefaultValueCallback, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::CreateDefaultValueCallback, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void** result) noexcept final try
        {
            clear_abi(result);
            *result = detach_from<winrt::Windows::Foundation::IInspectable>((*this)());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::DependencyPropertyChangedCallback, H> final : implements_delegate<winrt::Windows::UI::Xaml::DependencyPropertyChangedCallback, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::DependencyPropertyChangedCallback, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* dp) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyObject const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::DependencyPropertyChangedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::DependencyPropertyChangedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::DependencyPropertyChangedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Xaml::DependencyPropertyChangedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::DragEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::DragEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::DragEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Xaml::DragEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::EnteredBackgroundEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::EnteredBackgroundEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::EnteredBackgroundEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::ApplicationModel::EnteredBackgroundEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::ExceptionRoutedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::ExceptionRoutedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::ExceptionRoutedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Xaml::ExceptionRoutedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::LeavingBackgroundEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::LeavingBackgroundEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::LeavingBackgroundEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::ApplicationModel::LeavingBackgroundEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::PropertyChangedCallback, H> final : implements_delegate<winrt::Windows::UI::Xaml::PropertyChangedCallback, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::PropertyChangedCallback, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* d, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyObject const*>(&d), *reinterpret_cast<winrt::Windows::UI::Xaml::DependencyPropertyChangedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::RoutedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::RoutedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::RoutedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Xaml::RoutedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::SizeChangedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::SizeChangedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::SizeChangedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Xaml::SizeChangedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::SuspendingEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::SuspendingEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::SuspendingEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::ApplicationModel::SuspendingEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::UnhandledExceptionEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::UnhandledExceptionEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::UnhandledExceptionEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Xaml::UnhandledExceptionEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::VisualStateChangedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::VisualStateChangedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::VisualStateChangedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Xaml::VisualStateChangedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::WindowActivatedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::WindowActivatedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::WindowActivatedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Core::WindowActivatedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::WindowClosedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::WindowClosedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::WindowClosedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Core::CoreWindowEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::WindowSizeChangedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::WindowSizeChangedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::WindowSizeChangedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Core::WindowSizeChangedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::UI::Xaml::WindowVisibilityChangedEventHandler, H> final : implements_delegate<winrt::Windows::UI::Xaml::WindowVisibilityChangedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::UI::Xaml::WindowVisibilityChangedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* sender, void* e) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&sender), *reinterpret_cast<winrt::Windows::UI::Core::VisibilityChangedEventArgs const*>(&e));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IAdaptiveTrigger> : produce_base<D, winrt::Windows::UI::Xaml::IAdaptiveTrigger>
    {
        int32_t __stdcall get_MinWindowWidth(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().MinWindowWidth());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MinWindowWidth(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MinWindowWidth(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinWindowHeight(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().MinWindowHeight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MinWindowHeight(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MinWindowHeight(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IAdaptiveTriggerFactory> : produce_base<D, winrt::Windows::UI::Xaml::IAdaptiveTriggerFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::AdaptiveTrigger>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics> : produce_base<D, winrt::Windows::UI::Xaml::IAdaptiveTriggerStatics>
    {
        int32_t __stdcall get_MinWindowWidthProperty(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DependencyProperty>(this->shim().MinWindowWidthProperty());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinWindowHeightProperty(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DependencyProperty>(this->shim().MinWindowHeightProperty());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IApplication> : produce_base<D, winrt::Windows::UI::Xaml::IApplication>
    {
        int32_t __stdcall get_Resources(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ResourceDictionary>(this->shim().Resources());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Resources(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Resources(*reinterpret_cast<winrt::Windows::UI::Xaml::ResourceDictionary const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DebugSettings(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DebugSettings>(this->shim().DebugSettings());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RequestedTheme(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ApplicationTheme>(this->shim().RequestedTheme());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RequestedTheme(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RequestedTheme(*reinterpret_cast<winrt::Windows::UI::Xaml::ApplicationTheme const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_UnhandledException(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().UnhandledException(*reinterpret_cast<winrt::Windows::UI::Xaml::UnhandledExceptionEventHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_UnhandledException(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().UnhandledException(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_Suspending(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Suspending(*reinterpret_cast<winrt::Windows::UI::Xaml::SuspendingEventHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Suspending(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Suspending(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_Resuming(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Resuming(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Resuming(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Resuming(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall Exit() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Exit();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IApplication2> : produce_base<D, winrt::Windows::UI::Xaml::IApplication2>
    {
        int32_t __stdcall get_FocusVisualKind(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::FocusVisualKind>(this->shim().FocusVisualKind());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FocusVisualKind(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FocusVisualKind(*reinterpret_cast<winrt::Windows::UI::Xaml::FocusVisualKind const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RequiresPointerMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ApplicationRequiresPointerMode>(this->shim().RequiresPointerMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RequiresPointerMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RequiresPointerMode(*reinterpret_cast<winrt::Windows::UI::Xaml::ApplicationRequiresPointerMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_LeavingBackground(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().LeavingBackground(*reinterpret_cast<winrt::Windows::UI::Xaml::LeavingBackgroundEventHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_LeavingBackground(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LeavingBackground(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_EnteredBackground(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().EnteredBackground(*reinterpret_cast<winrt::Windows::UI::Xaml::EnteredBackgroundEventHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_EnteredBackground(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EnteredBackground(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IApplication3> : produce_base<D, winrt::Windows::UI::Xaml::IApplication3>
    {
        int32_t __stdcall get_HighContrastAdjustment(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ApplicationHighContrastAdjustment>(this->shim().HighContrastAdjustment());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_HighContrastAdjustment(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HighContrastAdjustment(*reinterpret_cast<winrt::Windows::UI::Xaml::ApplicationHighContrastAdjustment const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IApplicationFactory> : produce_base<D, winrt::Windows::UI::Xaml::IApplicationFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Application>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IApplicationInitializationCallbackParams> : produce_base<D, winrt::Windows::UI::Xaml::IApplicationInitializationCallbackParams>
    {
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IApplicationOverrides> : produce_base<D, winrt::Windows::UI::Xaml::IApplicationOverrides>
    {
        int32_t __stdcall OnActivated(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnActivated(*reinterpret_cast<winrt::Windows::ApplicationModel::Activation::IActivatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OnLaunched(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnLaunched(*reinterpret_cast<winrt::Windows::ApplicationModel::Activation::LaunchActivatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OnFileActivated(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnFileActivated(*reinterpret_cast<winrt::Windows::ApplicationModel::Activation::FileActivatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OnSearchActivated(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnSearchActivated(*reinterpret_cast<winrt::Windows::ApplicationModel::Activation::SearchActivatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OnShareTargetActivated(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnShareTargetActivated(*reinterpret_cast<winrt::Windows::ApplicationModel::Activation::ShareTargetActivatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OnFileOpenPickerActivated(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnFileOpenPickerActivated(*reinterpret_cast<winrt::Windows::ApplicationModel::Activation::FileOpenPickerActivatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OnFileSavePickerActivated(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnFileSavePickerActivated(*reinterpret_cast<winrt::Windows::ApplicationModel::Activation::FileSavePickerActivatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OnCachedFileUpdaterActivated(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnCachedFileUpdaterActivated(*reinterpret_cast<winrt::Windows::ApplicationModel::Activation::CachedFileUpdaterActivatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OnWindowCreated(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnWindowCreated(*reinterpret_cast<winrt::Windows::UI::Xaml::WindowCreatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IApplicationOverrides2> : produce_base<D, winrt::Windows::UI::Xaml::IApplicationOverrides2>
    {
        int32_t __stdcall OnBackgroundActivated(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OnBackgroundActivated(*reinterpret_cast<winrt::Windows::ApplicationModel::Activation::BackgroundActivatedEventArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IApplicationStatics> : produce_base<D, winrt::Windows::UI::Xaml::IApplicationStatics>
    {
        int32_t __stdcall get_Current(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Application>(this->shim().Current());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Start(void* callback) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Start(*reinterpret_cast<winrt::Windows::UI::Xaml::ApplicationInitializationCallback const*>(&callback));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall LoadComponent(void* component, void* resourceLocator) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LoadComponent(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&component), *reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&resourceLocator));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall LoadComponentWithResourceLocation(void* component, void* resourceLocator, int32_t componentResourceLocation) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LoadComponent(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&component), *reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&resourceLocator), *reinterpret_cast<winrt::Windows::UI::Xaml::Controls::Primitives::ComponentResourceLocation const*>(&componentResourceLocation));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IBindingFailedEventArgs> : produce_base<D, winrt::Windows::UI::Xaml::IBindingFailedEventArgs>
    {
        int32_t __stdcall get_Message(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Message());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions> : produce_base<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions>
    {
        int32_t __stdcall get_AnimationDesired(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().AnimationDesired());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AnimationDesired(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AnimationDesired(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TargetRect(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Rect>>(this->shim().TargetRect());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TargetRect(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TargetRect(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::Rect> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2> : produce_base<D, winrt::Windows::UI::Xaml::IBringIntoViewOptions2>
    {
        int32_t __stdcall get_HorizontalAlignmentRatio(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().HorizontalAlignmentRatio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_HorizontalAlignmentRatio(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HorizontalAlignmentRatio(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VerticalAlignmentRatio(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().VerticalAlignmentRatio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_VerticalAlignmentRatio(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VerticalAlignmentRatio(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HorizontalOffset(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().HorizontalOffset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_HorizontalOffset(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HorizontalOffset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VerticalOffset(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().VerticalOffset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_VerticalOffset(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VerticalOffset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs> : produce_base<D, winrt::Windows::UI::Xaml::IBringIntoViewRequestedEventArgs>
    {
        int32_t __stdcall get_TargetElement(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::UIElement>(this->shim().TargetElement());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TargetElement(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TargetElement(*reinterpret_cast<winrt::Windows::UI::Xaml::UIElement const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AnimationDesired(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().AnimationDesired());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AnimationDesired(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AnimationDesired(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TargetRect(winrt::Windows::Foundation::Rect* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Rect>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Rect>(this->shim().TargetRect());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TargetRect(winrt::Windows::Foundation::Rect value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TargetRect(*reinterpret_cast<winrt::Windows::Foundation::Rect const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HorizontalAlignmentRatio(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().HorizontalAlignmentRatio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VerticalAlignmentRatio(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().VerticalAlignmentRatio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HorizontalOffset(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().HorizontalOffset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_HorizontalOffset(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HorizontalOffset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VerticalOffset(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().VerticalOffset());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_VerticalOffset(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VerticalOffset(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Handled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Handled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Handled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Handled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IBrushTransition> : produce_base<D, winrt::Windows::UI::Xaml::IBrushTransition>
    {
        int32_t __stdcall get_Duration(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().Duration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Duration(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Duration(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IBrushTransitionFactory> : produce_base<D, winrt::Windows::UI::Xaml::IBrushTransitionFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::BrushTransition>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IColorPaletteResources> : produce_base<D, winrt::Windows::UI::Xaml::IColorPaletteResources>
    {
        int32_t __stdcall get_AltHigh(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().AltHigh());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AltHigh(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AltHigh(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AltLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().AltLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AltLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AltLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AltMedium(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().AltMedium());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AltMedium(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AltMedium(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AltMediumHigh(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().AltMediumHigh());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AltMediumHigh(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AltMediumHigh(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AltMediumLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().AltMediumLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AltMediumLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AltMediumLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BaseHigh(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().BaseHigh());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BaseHigh(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BaseHigh(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BaseLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().BaseLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BaseLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BaseLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BaseMedium(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().BaseMedium());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BaseMedium(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BaseMedium(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BaseMediumHigh(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().BaseMediumHigh());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BaseMediumHigh(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BaseMediumHigh(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BaseMediumLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().BaseMediumLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BaseMediumLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BaseMediumLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeAltLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeAltLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeAltLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeAltLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeBlackHigh(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeBlackHigh());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeBlackHigh(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeBlackHigh(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeBlackLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeBlackLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeBlackLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeBlackLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeBlackMediumLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeBlackMediumLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeBlackMediumLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeBlackMediumLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeBlackMedium(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeBlackMedium());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeBlackMedium(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeBlackMedium(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeDisabledHigh(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeDisabledHigh());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeDisabledHigh(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeDisabledHigh(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeDisabledLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeDisabledLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeDisabledLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeDisabledLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeHigh(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeHigh());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeHigh(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeHigh(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeMedium(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeMedium());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeMedium(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeMedium(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeMediumLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeMediumLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeMediumLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeMediumLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeWhite(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeWhite());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeWhite(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeWhite(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChromeGray(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ChromeGray());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChromeGray(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChromeGray(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ListLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ListLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ListLow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ListLow(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ListMedium(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ListMedium());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ListMedium(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ListMedium(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ErrorText(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().ErrorText());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ErrorText(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ErrorText(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Accent(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color>>(this->shim().Accent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Accent(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Accent(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::UI::Color> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IColorPaletteResourcesFactory> : produce_base<D, winrt::Windows::UI::Xaml::IColorPaletteResourcesFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ColorPaletteResources>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::ICornerRadiusHelper> : produce_base<D, winrt::Windows::UI::Xaml::ICornerRadiusHelper>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics> : produce_base<D, winrt::Windows::UI::Xaml::ICornerRadiusHelperStatics>
    {
        int32_t __stdcall FromRadii(double topLeft, double topRight, double bottomRight, double bottomLeft, struct struct_Windows_UI_Xaml_CornerRadius* result) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::CornerRadius>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::CornerRadius>(this->shim().FromRadii(topLeft, topRight, bottomRight, bottomLeft));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FromUniformRadius(double uniformRadius, struct struct_Windows_UI_Xaml_CornerRadius* result) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::CornerRadius>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::CornerRadius>(this->shim().FromUniformRadius(uniformRadius));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDataContextChangedEventArgs> : produce_base<D, winrt::Windows::UI::Xaml::IDataContextChangedEventArgs>
    {
        int32_t __stdcall get_NewValue(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().NewValue());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Handled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Handled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Handled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Handled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDataTemplate> : produce_base<D, winrt::Windows::UI::Xaml::IDataTemplate>
    {
        int32_t __stdcall LoadContent(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::DependencyObject>(this->shim().LoadContent());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDataTemplateExtension> : produce_base<D, winrt::Windows::UI::Xaml::IDataTemplateExtension>
    {
        int32_t __stdcall ResetTemplate() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ResetTemplate();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ProcessBinding(uint32_t phase, bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().ProcessBinding(phase));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ProcessBindings(void* arg, int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().ProcessBindings(*reinterpret_cast<winrt::Windows::UI::Xaml::Controls::ContainerContentChangingEventArgs const*>(&arg)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDataTemplateFactory> : produce_base<D, winrt::Windows::UI::Xaml::IDataTemplateFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DataTemplate>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDataTemplateKey> : produce_base<D, winrt::Windows::UI::Xaml::IDataTemplateKey>
    {
        int32_t __stdcall get_DataType(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().DataType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DataType(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DataType(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDataTemplateKeyFactory> : produce_base<D, winrt::Windows::UI::Xaml::IDataTemplateKeyFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DataTemplateKey>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateInstanceWithType(void* dataType, void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DataTemplateKey>(this->shim().CreateInstanceWithType(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&dataType), *reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDataTemplateStatics2> : produce_base<D, winrt::Windows::UI::Xaml::IDataTemplateStatics2>
    {
        int32_t __stdcall get_ExtensionInstanceProperty(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DependencyProperty>(this->shim().ExtensionInstanceProperty());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetExtensionInstance(void* element, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::IDataTemplateExtension>(this->shim().GetExtensionInstance(*reinterpret_cast<winrt::Windows::UI::Xaml::FrameworkElement const*>(&element)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetExtensionInstance(void* element, void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetExtensionInstance(*reinterpret_cast<winrt::Windows::UI::Xaml::FrameworkElement const*>(&element), *reinterpret_cast<winrt::Windows::UI::Xaml::IDataTemplateExtension const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDebugSettings> : produce_base<D, winrt::Windows::UI::Xaml::IDebugSettings>
    {
        int32_t __stdcall get_EnableFrameRateCounter(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().EnableFrameRateCounter());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_EnableFrameRateCounter(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EnableFrameRateCounter(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsBindingTracingEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsBindingTracingEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsBindingTracingEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsBindingTracingEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsOverdrawHeatMapEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsOverdrawHeatMapEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsOverdrawHeatMapEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsOverdrawHeatMapEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_BindingFailed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().BindingFailed(*reinterpret_cast<winrt::Windows::UI::Xaml::BindingFailedEventHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_BindingFailed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BindingFailed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDebugSettings2> : produce_base<D, winrt::Windows::UI::Xaml::IDebugSettings2>
    {
        int32_t __stdcall get_EnableRedrawRegions(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().EnableRedrawRegions());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_EnableRedrawRegions(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EnableRedrawRegions(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDebugSettings3> : produce_base<D, winrt::Windows::UI::Xaml::IDebugSettings3>
    {
        int32_t __stdcall get_IsTextPerformanceVisualizationEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsTextPerformanceVisualizationEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsTextPerformanceVisualizationEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsTextPerformanceVisualizationEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDebugSettings4> : produce_base<D, winrt::Windows::UI::Xaml::IDebugSettings4>
    {
        int32_t __stdcall get_FailFastOnErrors(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().FailFastOnErrors());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FailFastOnErrors(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FailFastOnErrors(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDependencyObject> : produce_base<D, winrt::Windows::UI::Xaml::IDependencyObject>
    {
        int32_t __stdcall GetValue(void* dp, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().GetValue(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetValue(void* dp, void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetValue(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp), *reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClearValue(void* dp) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ClearValue(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadLocalValue(void* dp, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().ReadLocalValue(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetAnimationBaseValue(void* dp, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().GetAnimationBaseValue(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Dispatcher(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Core::CoreDispatcher>(this->shim().Dispatcher());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDependencyObject2> : produce_base<D, winrt::Windows::UI::Xaml::IDependencyObject2>
    {
        int32_t __stdcall RegisterPropertyChangedCallback(void* dp, void* callback, int64_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int64_t>(this->shim().RegisterPropertyChangedCallback(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp), *reinterpret_cast<winrt::Windows::UI::Xaml::DependencyPropertyChangedCallback const*>(&callback)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UnregisterPropertyChangedCallback(void* dp, int64_t token) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().UnregisterPropertyChangedCallback(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp), token);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDependencyObjectCollectionFactory> : produce_base<D, winrt::Windows::UI::Xaml::IDependencyObjectCollectionFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DependencyObjectCollection>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDependencyObjectFactory> : produce_base<D, winrt::Windows::UI::Xaml::IDependencyObjectFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DependencyObject>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDependencyProperty> : produce_base<D, winrt::Windows::UI::Xaml::IDependencyProperty>
    {
        int32_t __stdcall GetMetadata(struct struct_Windows_UI_Xaml_Interop_TypeName forType, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::PropertyMetadata>(this->shim().GetMetadata(*reinterpret_cast<winrt::Windows::UI::Xaml::Interop::TypeName const*>(&forType)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs> : produce_base<D, winrt::Windows::UI::Xaml::IDependencyPropertyChangedEventArgs>
    {
        int32_t __stdcall get_Property(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DependencyProperty>(this->shim().Property());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OldValue(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().OldValue());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_NewValue(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().NewValue());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDependencyPropertyStatics> : produce_base<D, winrt::Windows::UI::Xaml::IDependencyPropertyStatics>
    {
        int32_t __stdcall get_UnsetValue(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().UnsetValue());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Register(void* name, struct struct_Windows_UI_Xaml_Interop_TypeName propertyType, struct struct_Windows_UI_Xaml_Interop_TypeName ownerType, void* typeMetadata, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::DependencyProperty>(this->shim().Register(*reinterpret_cast<hstring const*>(&name), *reinterpret_cast<winrt::Windows::UI::Xaml::Interop::TypeName const*>(&propertyType), *reinterpret_cast<winrt::Windows::UI::Xaml::Interop::TypeName const*>(&ownerType), *reinterpret_cast<winrt::Windows::UI::Xaml::PropertyMetadata const*>(&typeMetadata)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RegisterAttached(void* name, struct struct_Windows_UI_Xaml_Interop_TypeName propertyType, struct struct_Windows_UI_Xaml_Interop_TypeName ownerType, void* defaultMetadata, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::DependencyProperty>(this->shim().RegisterAttached(*reinterpret_cast<hstring const*>(&name), *reinterpret_cast<winrt::Windows::UI::Xaml::Interop::TypeName const*>(&propertyType), *reinterpret_cast<winrt::Windows::UI::Xaml::Interop::TypeName const*>(&ownerType), *reinterpret_cast<winrt::Windows::UI::Xaml::PropertyMetadata const*>(&defaultMetadata)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDispatcherTimer> : produce_base<D, winrt::Windows::UI::Xaml::IDispatcherTimer>
    {
        int32_t __stdcall get_Interval(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().Interval());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Interval(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Interval(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_Tick(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Tick(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Tick(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Tick(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall Start() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Start();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Stop() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Stop();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDispatcherTimerFactory> : produce_base<D, winrt::Windows::UI::Xaml::IDispatcherTimerFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DispatcherTimer>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDragEventArgs> : produce_base<D, winrt::Windows::UI::Xaml::IDragEventArgs>
    {
        int32_t __stdcall get_Handled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Handled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Handled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Handled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Data(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::DataTransfer::DataPackage>(this->shim().Data());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Data(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Data(*reinterpret_cast<winrt::Windows::ApplicationModel::DataTransfer::DataPackage const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetPosition(void* relativeTo, winrt::Windows::Foundation::Point* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Point>(this->shim().GetPosition(*reinterpret_cast<winrt::Windows::UI::Xaml::UIElement const*>(&relativeTo)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDragEventArgs2> : produce_base<D, winrt::Windows::UI::Xaml::IDragEventArgs2>
    {
        int32_t __stdcall get_DataView(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::DataTransfer::DataPackageView>(this->shim().DataView());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DragUIOverride(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DragUIOverride>(this->shim().DragUIOverride());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Modifiers(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::DataTransfer::DragDrop::DragDropModifiers>(this->shim().Modifiers());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AcceptedOperation(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation>(this->shim().AcceptedOperation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AcceptedOperation(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AcceptedOperation(*reinterpret_cast<winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeferral(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::DragOperationDeferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDragEventArgs3> : produce_base<D, winrt::Windows::UI::Xaml::IDragEventArgs3>
    {
        int32_t __stdcall get_AllowedOperations(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation>(this->shim().AllowedOperations());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDragOperationDeferral> : produce_base<D, winrt::Windows::UI::Xaml::IDragOperationDeferral>
    {
        int32_t __stdcall Complete() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Complete();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs> : produce_base<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs>
    {
        int32_t __stdcall get_Cancel(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Cancel());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Cancel(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Cancel(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Data(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::DataTransfer::DataPackage>(this->shim().Data());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DragUI(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DragUI>(this->shim().DragUI());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeferral(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::DragOperationDeferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetPosition(void* relativeTo, winrt::Windows::Foundation::Point* result) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Point>(this->shim().GetPosition(*reinterpret_cast<winrt::Windows::UI::Xaml::UIElement const*>(&relativeTo)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs2> : produce_base<D, winrt::Windows::UI::Xaml::IDragStartingEventArgs2>
    {
        int32_t __stdcall get_AllowedOperations(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation>(this->shim().AllowedOperations());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AllowedOperations(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AllowedOperations(*reinterpret_cast<winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDragUI> : produce_base<D, winrt::Windows::UI::Xaml::IDragUI>
    {
        int32_t __stdcall SetContentFromBitmapImage(void* bitmapImage) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetContentFromBitmapImage(*reinterpret_cast<winrt::Windows::UI::Xaml::Media::Imaging::BitmapImage const*>(&bitmapImage));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetContentFromBitmapImageWithAnchorPoint(void* bitmapImage, winrt::Windows::Foundation::Point anchorPoint) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetContentFromBitmapImage(*reinterpret_cast<winrt::Windows::UI::Xaml::Media::Imaging::BitmapImage const*>(&bitmapImage), *reinterpret_cast<winrt::Windows::Foundation::Point const*>(&anchorPoint));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetContentFromSoftwareBitmap(void* softwareBitmap) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetContentFromSoftwareBitmap(*reinterpret_cast<winrt::Windows::Graphics::Imaging::SoftwareBitmap const*>(&softwareBitmap));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetContentFromSoftwareBitmapWithAnchorPoint(void* softwareBitmap, winrt::Windows::Foundation::Point anchorPoint) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetContentFromSoftwareBitmap(*reinterpret_cast<winrt::Windows::Graphics::Imaging::SoftwareBitmap const*>(&softwareBitmap), *reinterpret_cast<winrt::Windows::Foundation::Point const*>(&anchorPoint));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetContentFromDataPackage() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetContentFromDataPackage();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDragUIOverride> : produce_base<D, winrt::Windows::UI::Xaml::IDragUIOverride>
    {
        int32_t __stdcall get_Caption(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Caption());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Caption(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Caption(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsContentVisible(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsContentVisible());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsContentVisible(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsContentVisible(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCaptionVisible(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCaptionVisible());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsCaptionVisible(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsCaptionVisible(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsGlyphVisible(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsGlyphVisible());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsGlyphVisible(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsGlyphVisible(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Clear() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Clear();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetContentFromBitmapImage(void* bitmapImage) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetContentFromBitmapImage(*reinterpret_cast<winrt::Windows::UI::Xaml::Media::Imaging::BitmapImage const*>(&bitmapImage));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetContentFromBitmapImageWithAnchorPoint(void* bitmapImage, winrt::Windows::Foundation::Point anchorPoint) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetContentFromBitmapImage(*reinterpret_cast<winrt::Windows::UI::Xaml::Media::Imaging::BitmapImage const*>(&bitmapImage), *reinterpret_cast<winrt::Windows::Foundation::Point const*>(&anchorPoint));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetContentFromSoftwareBitmap(void* softwareBitmap) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetContentFromSoftwareBitmap(*reinterpret_cast<winrt::Windows::Graphics::Imaging::SoftwareBitmap const*>(&softwareBitmap));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetContentFromSoftwareBitmapWithAnchorPoint(void* softwareBitmap, winrt::Windows::Foundation::Point anchorPoint) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetContentFromSoftwareBitmap(*reinterpret_cast<winrt::Windows::Graphics::Imaging::SoftwareBitmap const*>(&softwareBitmap), *reinterpret_cast<winrt::Windows::Foundation::Point const*>(&anchorPoint));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDropCompletedEventArgs> : produce_base<D, winrt::Windows::UI::Xaml::IDropCompletedEventArgs>
    {
        int32_t __stdcall get_DropResult(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::DataTransfer::DataPackageOperation>(this->shim().DropResult());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDurationHelper> : produce_base<D, winrt::Windows::UI::Xaml::IDurationHelper>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IDurationHelperStatics> : produce_base<D, winrt::Windows::UI::Xaml::IDurationHelperStatics>
    {
        int32_t __stdcall get_Automatic(struct struct_Windows_UI_Xaml_Duration* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::Duration>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Duration>(this->shim().Automatic());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Forever(struct struct_Windows_UI_Xaml_Duration* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::Duration>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Duration>(this->shim().Forever());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Compare(struct struct_Windows_UI_Xaml_Duration duration1, struct struct_Windows_UI_Xaml_Duration duration2, int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().Compare(*reinterpret_cast<winrt::Windows::UI::Xaml::Duration const*>(&duration1), *reinterpret_cast<winrt::Windows::UI::Xaml::Duration const*>(&duration2)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FromTimeSpan(int64_t timeSpan, struct struct_Windows_UI_Xaml_Duration* result) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::Duration>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::Duration>(this->shim().FromTimeSpan(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&timeSpan)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetHasTimeSpan(struct struct_Windows_UI_Xaml_Duration target, bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().GetHasTimeSpan(*reinterpret_cast<winrt::Windows::UI::Xaml::Duration const*>(&target)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Add(struct struct_Windows_UI_Xaml_Duration target, struct struct_Windows_UI_Xaml_Duration duration, struct struct_Windows_UI_Xaml_Duration* result) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::Duration>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::Duration>(this->shim().Add(*reinterpret_cast<winrt::Windows::UI::Xaml::Duration const*>(&target), *reinterpret_cast<winrt::Windows::UI::Xaml::Duration const*>(&duration)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Equals(struct struct_Windows_UI_Xaml_Duration target, struct struct_Windows_UI_Xaml_Duration value, bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().Equals(*reinterpret_cast<winrt::Windows::UI::Xaml::Duration const*>(&target), *reinterpret_cast<winrt::Windows::UI::Xaml::Duration const*>(&value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Subtract(struct struct_Windows_UI_Xaml_Duration target, struct struct_Windows_UI_Xaml_Duration duration, struct struct_Windows_UI_Xaml_Duration* result) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::Duration>(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::Duration>(this->shim().Subtract(*reinterpret_cast<winrt::Windows::UI::Xaml::Duration const*>(&target), *reinterpret_cast<winrt::Windows::UI::Xaml::Duration const*>(&duration)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs> : produce_base<D, winrt::Windows::UI::Xaml::IEffectiveViewportChangedEventArgs>
    {
        int32_t __stdcall get_EffectiveViewport(winrt::Windows::Foundation::Rect* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Rect>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Rect>(this->shim().EffectiveViewport());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxViewport(winrt::Windows::Foundation::Rect* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Rect>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Rect>(this->shim().MaxViewport());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BringIntoViewDistanceX(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().BringIntoViewDistanceX());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BringIntoViewDistanceY(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().BringIntoViewDistanceY());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IElementFactory> : produce_base<D, winrt::Windows::UI::Xaml::IElementFactory>
    {
        int32_t __stdcall GetElement(void* args, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::UIElement>(this->shim().GetElement(*reinterpret_cast<winrt::Windows::UI::Xaml::ElementFactoryGetArgs const*>(&args)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RecycleElement(void* args) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RecycleElement(*reinterpret_cast<winrt::Windows::UI::Xaml::ElementFactoryRecycleArgs const*>(&args));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IElementFactoryGetArgs> : produce_base<D, winrt::Windows::UI::Xaml::IElementFactoryGetArgs>
    {
        int32_t __stdcall get_Data(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().Data());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Data(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Data(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Parent(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::UIElement>(this->shim().Parent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Parent(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Parent(*reinterpret_cast<winrt::Windows::UI::Xaml::UIElement const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IElementFactoryGetArgsFactory> : produce_base<D, winrt::Windows::UI::Xaml::IElementFactoryGetArgsFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ElementFactoryGetArgs>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs> : produce_base<D, winrt::Windows::UI::Xaml::IElementFactoryRecycleArgs>
    {
        int32_t __stdcall get_Element(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::UIElement>(this->shim().Element());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Element(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Element(*reinterpret_cast<winrt::Windows::UI::Xaml::UIElement const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Parent(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::UIElement>(this->shim().Parent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Parent(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Parent(*reinterpret_cast<winrt::Windows::UI::Xaml::UIElement const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IElementFactoryRecycleArgsFactory> : produce_base<D, winrt::Windows::UI::Xaml::IElementFactoryRecycleArgsFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ElementFactoryRecycleArgs>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&baseInterface), winrt_impl_innerInterface));
                if (innerInterface) *innerInterface = detach_abi(winrt_impl_innerInterface);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IElementSoundPlayer> : produce_base<D, winrt::Windows::UI::Xaml::IElementSoundPlayer>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics> : produce_base<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics>
    {
        int32_t __stdcall get_Volume(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().Volume());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Volume(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Volume(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_State(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ElementSoundPlayerState>(this->shim().State());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_State(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().State(*reinterpret_cast<winrt::Windows::UI::Xaml::ElementSoundPlayerState const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Play(int32_t sound) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Play(*reinterpret_cast<winrt::Windows::UI::Xaml::ElementSoundKind const*>(&sound));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2> : produce_base<D, winrt::Windows::UI::Xaml::IElementSoundPlayerStatics2>
    {
        int32_t __stdcall get_SpatialAudioMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ElementSpatialAudioMode>(this->shim().SpatialAudioMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SpatialAudioMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SpatialAudioMode(*reinterpret_cast<winrt::Windows::UI::Xaml::ElementSpatialAudioMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IEventTrigger> : produce_base<D, winrt::Windows::UI::Xaml::IEventTrigger>
    {
        int32_t __stdcall get_RoutedEvent(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::RoutedEvent>(this->shim().RoutedEvent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RoutedEvent(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RoutedEvent(*reinterpret_cast<winrt::Windows::UI::Xaml::RoutedEvent const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Actions(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::TriggerActionCollection>(this->shim().Actions());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IExceptionRoutedEventArgs> : produce_base<D, winrt::Windows::UI::Xaml::IExceptionRoutedEventArgs>
    {
        int32_t __stdcall get_ErrorMessage(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ErrorMessage());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IExceptionRoutedEventArgsFactory> : produce_base<D, winrt::Windows::UI::Xaml::IExceptionRoutedEventArgsFactory>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IFrameworkElement> : produce_base<D, winrt::Windows::UI::Xaml::IFrameworkElement>
    {
        int32_t __stdcall get_Triggers(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::TriggerCollection>(this->shim().Triggers());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Resources(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ResourceDictionary>(this->shim().Resources());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Resources(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Resources(*reinterpret_cast<winrt::Windows::UI::Xaml::ResourceDictionary const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Tag(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().Tag());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Tag(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Tag(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Language(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Language());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Language(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Language(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ActualWidth(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().ActualWidth());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ActualHeight(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().ActualHeight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Width(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().Width());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Width(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Width(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Height(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().Height());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Height(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Height(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinWidth(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().MinWidth());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MinWidth(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MinWidth(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxWidth(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().MaxWidth());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MaxWidth(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MaxWidth(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinHeight(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().MinHeight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MinHeight(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MinHeight(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxHeight(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().MaxHeight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MaxHeight(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MaxHeight(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HorizontalAlignment(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::HorizontalAlignment>(this->shim().HorizontalAlignment());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_HorizontalAlignment(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HorizontalAlignment(*reinterpret_cast<winrt::Windows::UI::Xaml::HorizontalAlignment const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VerticalAlignment(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::VerticalAlignment>(this->shim().VerticalAlignment());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_VerticalAlignment(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VerticalAlignment(*reinterpret_cast<winrt::Windows::UI::Xaml::VerticalAlignment const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Margin(struct struct_Windows_UI_Xaml_Thickness* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::Thickness>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Thickness>(this->shim().Margin());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Margin(struct struct_Windows_UI_Xaml_Thickness value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Margin(*reinterpret_cast<winrt::Windows::UI::Xaml::Thickness const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Name(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Name(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Name(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BaseUri(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Uri>(this->shim().BaseUri());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DataContext(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().DataContext());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DataContext(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DataContext(*reinterpret_cast<winrt::Windows::Foundation::IInspectable const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Style(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Style>(this->shim().Style());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Style(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Style(*reinterpret_cast<winrt::Windows::UI::Xaml::Style const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Parent(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::DependencyObject>(this->shim().Parent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FlowDirection(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::FlowDirection>(this->shim().FlowDirection());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FlowDirection(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FlowDirection(*reinterpret_cast<winrt::Windows::UI::Xaml::FlowDirection const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_Loaded(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Loaded(*reinterpret_cast<winrt::Windows::UI::Xaml::RoutedEventHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Loaded(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Loaded(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_Unloaded(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Unloaded(*reinterpret_cast<winrt::Windows::UI::Xaml::RoutedEventHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Unloaded(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Unloaded(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_SizeChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().SizeChanged(*reinterpret_cast<winrt::Windows::UI::Xaml::SizeChangedEventHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_SizeChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SizeChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_LayoutUpdated(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().LayoutUpdated(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_LayoutUpdated(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LayoutUpdated(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall FindName(void* name, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IInspectable>(this->shim().FindName(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetBinding(void* dp, void* binding) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetBinding(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp), *reinterpret_cast<winrt::Windows::UI::Xaml::Data::BindingBase const*>(&binding));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IFrameworkElement2> : produce_base<D, winrt::Windows::UI::Xaml::IFrameworkElement2>
    {
        int32_t __stdcall get_RequestedTheme(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ElementTheme>(this->shim().RequestedTheme());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RequestedTheme(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RequestedTheme(*reinterpret_cast<winrt::Windows::UI::Xaml::ElementTheme const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_DataContextChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().DataContextChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::UI::Xaml::DataContextChangedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_DataContextChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DataContextChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall GetBindingExpression(void* dp, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Xaml::Data::BindingExpression>(this->shim().GetBindingExpression(*reinterpret_cast<winrt::Windows::UI::Xaml::DependencyProperty const*>(&dp)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IFrameworkElement3> : produce_base<D, winrt::Windows::UI::Xaml::IFrameworkElement3>
    {
        int32_t __stdcall add_Loading(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Loading(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Loading(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Loading(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IFrameworkElement4> : produce_base<D, winrt::Windows::UI::Xaml::IFrameworkElement4>
    {
        int32_t __stdcall get_AllowFocusOnInteraction(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().AllowFocusOnInteraction());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AllowFocusOnInteraction(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AllowFocusOnInteraction(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FocusVisualMargin(struct struct_Windows_UI_Xaml_Thickness* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::Thickness>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Thickness>(this->shim().FocusVisualMargin());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FocusVisualMargin(struct struct_Windows_UI_Xaml_Thickness value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FocusVisualMargin(*reinterpret_cast<winrt::Windows::UI::Xaml::Thickness const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FocusVisualSecondaryThickness(struct struct_Windows_UI_Xaml_Thickness* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::Thickness>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Thickness>(this->shim().FocusVisualSecondaryThickness());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FocusVisualSecondaryThickness(struct struct_Windows_UI_Xaml_Thickness value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FocusVisualSecondaryThickness(*reinterpret_cast<winrt::Windows::UI::Xaml::Thickness const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FocusVisualPrimaryThickness(struct struct_Windows_UI_Xaml_Thickness* value) noexcept final try
        {
            zero_abi<winrt::Windows::UI::Xaml::Thickness>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Thickness>(this->shim().FocusVisualPrimaryThickness());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FocusVisualPrimaryThickness(struct struct_Windows_UI_Xaml_Thickness value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FocusVisualPrimaryThickness(*reinterpret_cast<winrt::Windows::UI::Xaml::Thickness const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FocusVisualSecondaryBrush(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Media::Brush>(this->shim().FocusVisualSecondaryBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FocusVisualSecondaryBrush(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FocusVisualSecondaryBrush(*reinterpret_cast<winrt::Windows::UI::Xaml::Media::Brush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FocusVisualPrimaryBrush(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::Media::Brush>(this->shim().FocusVisualPrimaryBrush());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_FocusVisualPrimaryBrush(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FocusVisualPrimaryBrush(*reinterpret_cast<winrt::Windows::UI::Xaml::Media::Brush const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AllowFocusWhenDisabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().AllowFocusWhenDisabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AllowFocusWhenDisabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AllowFocusWhenDisabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IFrameworkElement6> : produce_base<D, winrt::Windows::UI::Xaml::IFrameworkElement6>
    {
        int32_t __stdcall get_ActualTheme(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Xaml::ElementTheme>(this->shim().ActualTheme());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_ActualThemeChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ActualThemeChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ActualThemeChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ActualThemeChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IFrameworkElement7> : produce_base<D, winrt::Windows::UI::Xaml::IFrameworkElement7>
    {
        int32_t __stdcall get_IsLoaded(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsLoaded());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_EffectiveViewportChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().EffectiveViewportChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Xaml::FrameworkElement, winrt::Windows::UI::Xaml::EffectiveViewportChangedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_EffectiveViewportChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EffectiveViewportChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Xaml::IFrameworkElementFactory> : produce_base<D, winrt::Windows::UI::Xaml::IFrameworkElementFactory>
    {
        int32_t __stdcall CreateInstance(void* baseInterface, void** innerInterface, void** value) noexcept final try
        {
            if (innerInterface) *innerInterface = nullptr;
            winrt::Windows::Foundation::IInspectable winrt_impl_innerInterface;
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows: