#ifndef GODOT_CPP_TIME_HPP
#define GODOT_CPP_TIME_HPP


#include <gdnative_api_struct.gen.h>
#include <cstdint>

#include <core/CoreTypes.hpp>
#include <core/Ref.hpp>

#include "Object.hpp"
namespace godot {


class Time : public Object {
	static Time *_singleton;

	Time();

	struct ___method_bindings {
		godot_method_bind *mb_get_date_dict_from_system;
		godot_method_bind *mb_get_date_dict_from_unix_time;
		godot_method_bind *mb_get_date_string_from_system;
		godot_method_bind *mb_get_date_string_from_unix_time;
		godot_method_bind *mb_get_datetime_dict_from_datetime_string;
		godot_method_bind *mb_get_datetime_dict_from_system;
		godot_method_bind *mb_get_datetime_dict_from_unix_time;
		godot_method_bind *mb_get_datetime_string_from_datetime_dict;
		godot_method_bind *mb_get_datetime_string_from_system;
		godot_method_bind *mb_get_datetime_string_from_unix_time;
		godot_method_bind *mb_get_offset_string_from_offset_minutes;
		godot_method_bind *mb_get_ticks_msec;
		godot_method_bind *mb_get_ticks_usec;
		godot_method_bind *mb_get_time_dict_from_system;
		godot_method_bind *mb_get_time_dict_from_unix_time;
		godot_method_bind *mb_get_time_string_from_system;
		godot_method_bind *mb_get_time_string_from_unix_time;
		godot_method_bind *mb_get_time_zone_from_system;
		godot_method_bind *mb_get_unix_time_from_datetime_dict;
		godot_method_bind *mb_get_unix_time_from_datetime_string;
		godot_method_bind *mb_get_unix_time_from_system;
	};
	static ___method_bindings ___mb;
	static void *_detail_class_tag;

public:
	static void ___init_method_bindings();
	inline static size_t ___get_id() { return (size_t)_detail_class_tag; }

	static inline Time *get_singleton()
	{
		if (!Time::_singleton) {
			Time::_singleton = new Time;
		}
		return Time::_singleton;
	}

	static inline const char *___get_class_name() { return (const char *) "Time"; }
	static inline const char *___get_godot_class_name() { return (const char *) "Time"; }
	static inline Object *___get_from_variant(Variant a) { godot_object *o = (godot_object*) a; return (o) ? (Object *) godot::nativescript_1_1_api->godot_nativescript_get_instance_binding_data(godot::_RegisterState::language_index, o) : nullptr; }

	// enums
	enum Month {
		MONTH_JANUARY = 1,
		MONTH_FEBRUARY = 2,
		MONTH_MARCH = 3,
		MONTH_APRIL = 4,
		MONTH_MAY = 5,
		MONTH_JUNE = 6,
		MONTH_JULY = 7,
		MONTH_AUGUST = 8,
		MONTH_SEPTEMBER = 9,
		MONTH_OCTOBER = 10,
		MONTH_NOVEMBER = 11,
		MONTH_DECEMBER = 12,
	};
	enum Weekday {
		WEEKDAY_SUNDAY = 0,
		WEEKDAY_MONDAY = 1,
		WEEKDAY_TUESDAY = 2,
		WEEKDAY_WEDNESDAY = 3,
		WEEKDAY_THURSDAY = 4,
		WEEKDAY_FRIDAY = 5,
		WEEKDAY_SATURDAY = 6,
	};

	// constants

	// methods
	Dictionary get_date_dict_from_system(const bool utc = false) const;
	Dictionary get_date_dict_from_unix_time(const int64_t unix_time_val) const;
	String get_date_string_from_system(const bool utc = false) const;
	String get_date_string_from_unix_time(const int64_t unix_time_val) const;
	Dictionary get_datetime_dict_from_datetime_string(const String datetime, const bool weekday) const;
	Dictionary get_datetime_dict_from_system(const bool utc = false) const;
	Dictionary get_datetime_dict_from_unix_time(const int64_t unix_time_val) const;
	String get_datetime_string_from_datetime_dict(const Dictionary datetime, const bool use_space) const;
	String get_datetime_string_from_system(const bool utc = false, const bool use_space = false) const;
	String get_datetime_string_from_unix_time(const int64_t unix_time_val, const bool use_space = false) const;
	String get_offset_string_from_offset_minutes(const int64_t offset_minutes) const;
	int64_t get_ticks_msec() const;
	int64_t get_ticks_usec() const;
	Dictionary get_time_dict_from_system(const bool utc = false) const;
	Dictionary get_time_dict_from_unix_time(const int64_t unix_time_val) const;
	String get_time_string_from_system(const bool utc = false) const;
	String get_time_string_from_unix_time(const int64_t unix_time_val) const;
	Dictionary get_time_zone_from_system() const;
	int64_t get_unix_time_from_datetime_dict(const Dictionary datetime) const;
	int64_t get_unix_time_from_datetime_string(const String datetime) const;
	real_t get_unix_time_from_system() const;

};

}

#endif