/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import jakarta.servlet.SessionTrackingMode;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;

public class SessionConfig {
    private Integer sessionTimeout;
    private String cookieName;
    private final Map<String, String> cookieAttributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final EnumSet<SessionTrackingMode> sessionTrackingModes = EnumSet.noneOf(SessionTrackingMode.class);

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(String string) {
        this.sessionTimeout = Integer.valueOf(string);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String string) {
        this.cookieName = string;
    }

    public String getCookieDomain() {
        return this.getCookieAttribute("Domain");
    }

    public void setCookieDomain(String string) {
        this.setCookieAttribute("Domain", string);
    }

    public String getCookiePath() {
        return this.getCookieAttribute("Path");
    }

    public void setCookiePath(String string) {
        this.setCookieAttribute("Path", string);
    }

    public String getCookieComment() {
        return this.getCookieAttribute("Comment");
    }

    public void setCookieComment(String string) {
        this.setCookieAttribute("Comment", string);
    }

    public Boolean getCookieHttpOnly() {
        String string = this.getCookieAttribute("HttpOnly");
        if (string == null) {
            return null;
        }
        return Boolean.valueOf(string);
    }

    public void setCookieHttpOnly(String string) {
        this.setCookieAttribute("HttpOnly", string);
    }

    public Boolean getCookieSecure() {
        String string = this.getCookieAttribute("Secure");
        if (string == null) {
            return null;
        }
        return Boolean.valueOf(string);
    }

    public void setCookieSecure(String string) {
        this.setCookieAttribute("Secure", string);
    }

    public Integer getCookieMaxAge() {
        String string = this.getCookieAttribute("Max-Age");
        if (string == null) {
            return null;
        }
        return Integer.valueOf(string);
    }

    public void setCookieMaxAge(String string) {
        this.setCookieAttribute("Max-Age", string);
    }

    public Map<String, String> getCookieAttributes() {
        return this.cookieAttributes;
    }

    public void setCookieAttribute(String string, String string2) {
        this.cookieAttributes.put(string, string2);
    }

    public String getCookieAttribute(String string) {
        return this.cookieAttributes.get(string);
    }

    public EnumSet<SessionTrackingMode> getSessionTrackingModes() {
        return this.sessionTrackingModes;
    }

    public void addSessionTrackingMode(String string) {
        this.sessionTrackingModes.add(SessionTrackingMode.valueOf((String)string));
    }
}

